/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.AbstractScienceObjectNode;
import jsky.science.UnitsNotSupportedException;
import jsky.science.Wavelength;
import jsky.science.Wavelength1DModel;

public abstract class AbstractWavelength1D
extends AbstractScienceObjectNode
implements Wavelength1DModel {
    public static final String NUMPOINTS_PROPERTY = "NumPoints";
    public static final String MINWAVELENGTH_PROPERTY = "MinWavelength";
    public static final String MAXWAVELENGTH_PROPERTY = "MaxWavelength";
    protected String fFluxUnits = null;
    static /* synthetic */ Class class$jsky$science$Wavelength;

    public AbstractWavelength1D() {
    }

    public AbstractWavelength1D(String name) {
        super(name);
    }

    public double getArea() {
        return this.getArea(true);
    }

    public double getArea(Wavelength minWl, Wavelength maxWl) {
        return this.getArea(minWl, maxWl, true);
    }

    public double getArea(boolean interpolate) {
        return this.getArea(Wavelength.MIN_VALUE, Wavelength.MAX_VALUE, interpolate);
    }

    public double getArea(Wavelength minWl, Wavelength maxWl, boolean interpolate) {
        double[] wlArray = this.toArrayWavelengths(minWl, maxWl, 0);
        double[] dataArray = this.toArrayData(minWl, maxWl, 0);
        return this.calculateArea(wlArray, dataArray, minWl, maxWl, interpolate);
    }

    protected double calculateArea(double[] wlArray, double[] dataArray, Wavelength minWl, Wavelength maxWl, boolean interpolate) {
        int iRight;
        double area = 0.0;
        double minL = minWl.getValue();
        double maxL = maxWl.getValue();
        int iLeft = this.getIndexOf(minWl, wlArray);
        if (iLeft >= 0) {
            if (interpolate) {
                area += this.calcArea(minL, wlArray[iLeft], this.getValue(minWl), dataArray[iLeft], interpolate);
            }
        } else {
            iLeft = 0;
        }
        if ((iRight = this.getIndexOf(maxWl, wlArray) - 1) < 0) {
            iRight = wlArray.length - 1;
        } else {
            area += this.calcArea(wlArray[iRight], maxL, dataArray[iRight], this.getValue(maxWl), interpolate);
        }
        for (int i = iLeft; i < iRight; ++i) {
            area += this.calcArea(wlArray[i], wlArray[i + 1], dataArray[i], dataArray[i + 1], interpolate);
        }
        return area;
    }

    protected double calcArea(double xl, double xr, double yl, double yr, boolean interpolate) {
        if (interpolate) {
            return (xr - xl) * (yl + (yr - yl) / 2.0);
        }
        return (xr - xl) * yl;
    }

    protected int getIndexOf(Wavelength wl, double[] wlArray) {
        return this.getIndexOf(wl.getValue(), wlArray, false);
    }

    protected int getIndexOf(double wl, double[] wlArray) {
        return this.getIndexOf(wl, wlArray, false);
    }

    protected int getIndexOf(Wavelength wl, double[] wlArray, boolean exactOnly) {
        return this.getIndexOf(wl.getValue(), wlArray, exactOnly);
    }

    protected int getIndexOf(double targetWl, double[] wlArray, boolean exactOnly) {
        if (wlArray.length == 0) {
            return -1;
        }
        if (targetWl < wlArray[0] || wlArray[wlArray.length - 1] < targetWl) {
            return -1;
        }
        double w1 = wlArray[0];
        double w2 = wlArray[wlArray.length - 1];
        if (wlArray.length == 0 || Double.isNaN(targetWl)) {
            return -1;
        }
        if (targetWl < w1 || targetWl > w2) {
            return -1;
        }
        int leftI = 0;
        double leftWl = wlArray[leftI];
        if (targetWl == leftWl) {
            return leftI;
        }
        int rightI = wlArray.length - 1;
        double rightWl = wlArray[rightI];
        if (targetWl == rightWl) {
            return rightI;
        }
        while (rightI - leftI > 1) {
            if (targetWl == leftWl) {
                return leftI;
            }
            if (targetWl == rightWl) {
                return rightI;
            }
            int midI = leftI + (rightI - leftI) / 2;
            double midWl = wlArray[midI];
            if (targetWl >= midWl) {
                leftI = midI;
                leftWl = midWl;
                continue;
            }
            rightI = midI;
            rightWl = midWl;
        }
        if (targetWl == leftWl) {
            return leftI;
        }
        return exactOnly ? -1 : rightI;
    }

    public boolean isEditable() {
        return false;
    }

    public void setValue(Wavelength inWl, double newVal) {
    }

    public double[] toArrayWavelengths(Wavelength minWL, Wavelength maxWL, int nPts) {
        return this.toArrayWavelengths(minWL, maxWL, nPts, Wavelength.getDefaultUnits(class$jsky$science$Wavelength == null ? (class$jsky$science$Wavelength = AbstractWavelength1D.class$("jsky.science.Wavelength")) : class$jsky$science$Wavelength));
    }

    public double[] toArrayData(double[] wllist) {
        double[] ret = new double[wllist.length];
        for (int i = 0; i < wllist.length; ++i) {
            ret[i] = this.getValue(new Wavelength(wllist[i]));
        }
        return ret;
    }

    public void setFluxUnits(String units) throws UnitsNotSupportedException {
        this.fFluxUnits = units;
    }

    public String getFluxUnits() {
        return this.fFluxUnits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

