/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jsky.science.AbstractScienceObject;
import jsky.science.Wavelength;
import jsky.util.FormatUtilities;

public class Passband
extends AbstractScienceObject {
    private static final long serialVersionUID = 7848426480608091945L;
    private Wavelength pLow;
    private Wavelength pHigh;
    private Wavelength pMiddle;
    public static final String LOW_PROPERTY = "Low";
    public static final String MIDDLE_PROPERTY = "Middle";
    public static final String HIGH_PROPERTY = "High";
    private static Map sStandardPassbands = new HashMap();

    public Passband() {
        this("H-Alpha");
    }

    public Passband(Wavelength inLowWL, Wavelength inHighWL) {
        this(FormatUtilities.formatDouble(inLowWL.getValue(), 0) + "-" + FormatUtilities.formatDouble(inHighWL.getValue(), 0), inLowWL, inHighWL, new Wavelength(inLowWL.getValue() + (inHighWL.getValue() - inLowWL.getValue()) / 2.0));
    }

    public Passband(Wavelength inLowWL, Wavelength inHighWL, Wavelength inMiddleWL) {
        this(FormatUtilities.formatDouble(inLowWL.getValue(Wavelength.NANOMETER), 0) + "-" + FormatUtilities.formatDouble(inHighWL.getValue(Wavelength.NANOMETER), 0) + " (" + FormatUtilities.formatDouble(inMiddleWL.getValue(Wavelength.NANOMETER), 0) + ")", inLowWL, inHighWL, inMiddleWL);
    }

    public Passband(String inName, Wavelength inLowWL, Wavelength inHighWL, Wavelength inMiddleWL) {
        super(inName);
        this.pLow = inLowWL;
        this.pHigh = inHighWL;
        this.pMiddle = inMiddleWL;
    }

    public Passband(String val) throws NumberFormatException {
        super(val);
        Passband findBand = (Passband)sStandardPassbands.get(val);
        if (findBand != null) {
            this.pLow = findBand.getLowWavelength();
            this.pMiddle = findBand.getMiddleWavelength();
            this.pHigh = findBand.getHighWavelength();
        } else {
            double middle;
            double high;
            double low;
            String highStr;
            String lowStr;
            String band = val;
            int locDash = band.indexOf(45);
            if (locDash >= 0 && locDash > 0) {
                lowStr = band.substring(0, locDash).trim();
                highStr = band.substring(locDash + 1).trim();
                if (lowStr.endsWith("e") || lowStr.endsWith("E")) {
                    int nextDash = highStr.indexOf(45);
                    int n = locDash = nextDash >= 0 ? locDash + nextDash + 1 : -1;
                }
            }
            if (locDash >= 0) {
                lowStr = band.substring(0, locDash).trim();
                highStr = band.substring(locDash + 1).trim();
                if (lowStr.length() == 0) {
                    lowStr = "0";
                }
                if (highStr.length() == 0) {
                    highStr = "10000";
                }
                low = new Double(lowStr);
                high = new Double(highStr);
                middle = (high - low) / 2.0;
            } else {
                middle = low = new Double(band).doubleValue();
                high = low;
            }
            this.pLow = new Wavelength(low);
            this.pMiddle = new Wavelength(middle);
            this.pHigh = new Wavelength(high);
        }
    }

    public boolean equals(Object inO) {
        if (!super.equals(inO)) {
            return false;
        }
        Passband that = (Passband)inO;
        if (this.pLow == null ? that.pLow != null : !this.pLow.equals(that.pLow)) {
            return false;
        }
        if (this.pHigh == null ? that.pHigh != null : !this.pHigh.equals(that.pHigh)) {
            return false;
        }
        return !(this.pMiddle == null ? that.pMiddle != null : !this.pMiddle.equals(that.pMiddle));
    }

    public static String[] getStdBands() {
        Iterator iter = sStandardPassbands.keySet().iterator();
        String[] bandList = new String[sStandardPassbands.size()];
        for (int i = 0; i < sStandardPassbands.size(); ++i) {
            bandList[i] = (String)iter.next();
        }
        return bandList;
    }

    public static String[] getStandardBroadBands() {
        Iterator iter = sStandardPassbands.keySet().iterator();
        int len = 0;
        while (iter.hasNext()) {
            String b = (String)iter.next();
            if (b.length() != 1) continue;
            ++len;
        }
        String[] bandList = new String[len];
        iter = sStandardPassbands.keySet().iterator();
        len = 0;
        while (iter.hasNext()) {
            String b = (String)iter.next();
            if (b.length() != 1) continue;
            bandList[len++] = b;
        }
        return bandList;
    }

    public static void setStdBands(String[] bands) {
        sStandardPassbands.clear();
        for (int i = 0; i < bands.length; i += 2) {
            Passband newP = new Passband(bands[i + 1]);
            newP.setName(bands[i]);
            sStandardPassbands.put(bands[i], newP);
        }
    }

    public static Passband getStandardPassband(String pName) {
        return (Passband)sStandardPassbands.get(pName);
    }

    public static Passband findStandardContaining(Wavelength inWL) {
        Iterator iter = sStandardPassbands.values().iterator();
        while (iter.hasNext()) {
            Passband p = (Passband)iter.next();
            if (!p.contains(inWL)) continue;
            return p;
        }
        return null;
    }

    public boolean contains(Wavelength inWL) {
        double inNano = inWL.getValue(Wavelength.NANOMETER);
        return this.pLow.getValue(Wavelength.NANOMETER) <= inNano && this.pHigh.getValue(Wavelength.NANOMETER) >= inNano;
    }

    public Wavelength getHighWavelength() {
        return this.pHigh;
    }

    public void setHighWavelength(Wavelength inWL) {
        Wavelength oldVal = this.pHigh;
        this.pHigh = inWL;
        this.firePropertyChange(HIGH_PROPERTY, oldVal, this.pHigh);
    }

    public Wavelength getLowWavelength() {
        return this.pLow;
    }

    public void setLowWavelength(Wavelength inWL) {
        Wavelength oldVal = this.pLow;
        this.pLow = inWL;
        this.firePropertyChange(LOW_PROPERTY, oldVal, this.pLow);
    }

    public Wavelength getMiddleWavelength() {
        return this.pMiddle;
    }

    public void setMiddleWavelength(Wavelength inWL) {
        Wavelength oldval = this.pMiddle;
        this.pMiddle = inWL;
        this.firePropertyChange(MIDDLE_PROPERTY, oldval, this.pMiddle);
    }

    static {
        sStandardPassbands.put("H-Alpha", new Passband("H-Alpha", new Wavelength(645.0, Wavelength.NANOMETER), new Wavelength(670.0, Wavelength.NANOMETER), new Wavelength(658.1, Wavelength.NANOMETER)));
        sStandardPassbands.put("O III", new Passband("O III", new Wavelength(495.0, Wavelength.NANOMETER), new Wavelength(510.0, Wavelength.NANOMETER), new Wavelength(502.5, Wavelength.NANOMETER)));
        sStandardPassbands.put("Ne V", new Passband("Ne V", new Wavelength(338.0, Wavelength.NANOMETER), new Wavelength(350.0, Wavelength.NANOMETER), new Wavelength(343.4, Wavelength.NANOMETER)));
        sStandardPassbands.put("U", new Passband("U", new Wavelength(180.0, Wavelength.NANOMETER), new Wavelength(350.0, Wavelength.NANOMETER), new Wavelength(265.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("B", new Passband("B", new Wavelength(391.0, Wavelength.NANOMETER), new Wavelength(489.0, Wavelength.NANOMETER), new Wavelength(440.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("V", new Passband("V", new Wavelength(450.0, Wavelength.NANOMETER), new Wavelength(750.0, Wavelength.NANOMETER), new Wavelength(600.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("R", new Passband("R", new Wavelength(530.0, Wavelength.NANOMETER), new Wavelength(720.0, Wavelength.NANOMETER), new Wavelength(632.0, Wavelength.NANOMETER)));
        sStandardPassbands.put("I", new Passband("I", new Wavelength(680.0, Wavelength.NANOMETER), new Wavelength(980.0, Wavelength.NANOMETER), new Wavelength(833.0, Wavelength.NANOMETER)));
    }
}

