/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jsky.science.Quantity;
import jsky.science.UnitsNotSupportedException;

public class Time
extends Quantity {
    private static final long serialVersionUID = 3592097662233611662L;
    public static final String DEFAULTUNITS_PROPERTY = "defaultTimeUnit".intern();
    public static final String SECOND = "Seconds".intern();
    public static final String MINUTE = "Minutes".intern();
    public static final String HOUR = "Hours".intern();
    public static final String DAY = "Days".intern();
    public static final String SECONDABBREV = "sec".intern();
    public static final String MINUTEABBREV = "min".intern();
    public static final String HOURABBREV = "hr".intern();
    public static final String DAYABBREV = "day".intern();
    static /* synthetic */ Class class$jsky$science$Time;

    public Time() {
        this(0.0);
    }

    public Time(double inValue) {
        this(inValue, Quantity.getDefaultUnits(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time));
    }

    public Time(double inValue, String inUnits) {
        this.setValue(inValue, inUnits);
    }

    public Quantity newInstance(double inValue) {
        return new Time(inValue);
    }

    public double getValue(String unitsName) {
        try {
            return Time.convert(this.fValue, SECOND, unitsName);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            return Double.NaN;
        }
    }

    protected void setValue(double inValue, String unitsName) {
        try {
            this.fValue = Time.convert(inValue, unitsName, SECOND);
        }
        catch (UnitsNotSupportedException e) {
            this.writeError(this, e.toString());
            this.fValue = Double.NaN;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double convert(double inVal, String fromUnits, String toUnits) throws UnitsNotSupportedException {
        double outVal = Double.NaN;
        if (fromUnits.equalsIgnoreCase(SECOND)) {
            if (toUnits.equalsIgnoreCase(SECOND)) {
                return inVal;
            }
            if (toUnits.equalsIgnoreCase(MINUTE)) {
                return inVal / 60.0;
            }
            if (toUnits.equalsIgnoreCase(HOUR)) {
                return inVal / 3600.0;
            }
            if (!toUnits.equalsIgnoreCase(DAY)) throw new UnitsNotSupportedException(toUnits);
            return inVal / 86400.0;
        }
        if (toUnits.equalsIgnoreCase(SECOND)) {
            if (fromUnits.equalsIgnoreCase(SECOND)) {
                return inVal;
            }
            if (fromUnits.equalsIgnoreCase(MINUTE)) {
                return inVal * 60.0;
            }
            if (fromUnits.equalsIgnoreCase(HOUR)) {
                return inVal * 3600.0;
            }
            if (!fromUnits.equalsIgnoreCase(DAY)) throw new UnitsNotSupportedException(fromUnits);
            return inVal * 86400.0;
        }
        double tmpVal = Time.convert(inVal, fromUnits, SECOND);
        return Time.convert(tmpVal, SECOND, toUnits);
    }

    public static void addDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.addDefaultUnitsChangeListener(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time, listener);
    }

    public static void removeDefaultUnitsChangeListener(PropertyChangeListener listener) {
        Quantity.removeDefaultUnitsChangeListener(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time, listener);
    }

    public static String getDefaultUnitsAbbrev() {
        return Quantity.getDefaultUnitsAbbrev(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time);
    }

    public static String getUnitsAbbrev(String unitType) {
        return Quantity.getUnitsAbbrev(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time, unitType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList<String> unitNames = new ArrayList<String>();
        unitNames.add(SECOND);
        unitNames.add(MINUTE);
        unitNames.add(HOUR);
        unitNames.add(DAY);
        ArrayList<String> unitAbbrev = new ArrayList<String>();
        unitAbbrev.add(SECONDABBREV);
        unitAbbrev.add(MINUTEABBREV);
        unitAbbrev.add(HOURABBREV);
        unitAbbrev.add(DAYABBREV);
        Quantity.initializeSubClass(class$jsky$science$Time == null ? (class$jsky$science$Time = Time.class$("jsky.science.Time")) : class$jsky$science$Time, unitNames, unitAbbrev, SECOND, DEFAULTUNITS_PROPERTY);
    }
}

