/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.AbstractWavelength1D;
import jsky.science.Wavelength;

public abstract class Wavelength1DFormula
extends AbstractWavelength1D {
    protected Wavelength fMinWavelength;
    protected Wavelength fMaxWavelength;
    protected int fNumPoints;
    private static final long serialVersionUID = 1L;

    public Wavelength1DFormula() {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DFormula(int inPoints) {
        this(null, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), inPoints);
    }

    public Wavelength1DFormula(String inName) {
        this(inName, new Wavelength(100.0, Wavelength.NANOMETER), new Wavelength(1100.0, Wavelength.NANOMETER), 100);
    }

    public Wavelength1DFormula(Wavelength inMin, Wavelength inMax, int inPts) {
        this(null, inMin, inMax, inPts);
    }

    public Wavelength1DFormula(String inProp, Wavelength inMin, Wavelength inMax, int inPts) {
        super(inProp);
        this.fMinWavelength = inMin;
        this.fMaxWavelength = inMax;
        this.fNumPoints = inPts;
    }

    public Object clone() {
        Wavelength1DFormula newDS = (Wavelength1DFormula)super.clone();
        newDS.setMinWavelength((Wavelength)this.getMinWavelength().clone());
        newDS.setMaxWavelength((Wavelength)this.getMaxWavelength().clone());
        return newDS;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        try {
            Wavelength1DFormula that = (Wavelength1DFormula)obj;
            if (!this.getClass().equals(that.getClass())) {
                return false;
            }
            if (this.fNumPoints != that.fNumPoints) {
                return false;
            }
            if (this.fMinWavelength == null ? that.fMinWavelength != null : !this.fMinWavelength.equals(that.fMinWavelength)) {
                return false;
            }
            return !(this.fMaxWavelength == null ? that.fMaxWavelength != null : !this.fMaxWavelength.equals(that.fMaxWavelength));
        }
        catch (Exception e) {
            return false;
        }
    }

    public Wavelength getMinWavelength() {
        return this.fMinWavelength;
    }

    public Wavelength getMaxWavelength() {
        return this.fMaxWavelength;
    }

    public void setMinWavelength(Wavelength newWL) {
        if (this.fMinWavelength != null) {
            this.fMinWavelength.removePropertyChangeListener(this);
        }
        Wavelength oldWL = this.fMinWavelength;
        this.fMinWavelength = newWL;
        if (this.fMinWavelength != null) {
            this.fMinWavelength.addPropertyChangeListener(this);
        }
        this.firePropertyChange("MinWavelength", oldWL, newWL);
    }

    public void setMaxWavelength(Wavelength newWL) {
        if (this.fMaxWavelength != null) {
            this.fMaxWavelength.removePropertyChangeListener(this);
        }
        Wavelength oldWL = this.fMaxWavelength;
        this.fMaxWavelength = newWL;
        if (this.fMaxWavelength != null) {
            this.fMaxWavelength.addPropertyChangeListener(this);
        }
        this.firePropertyChange("MaxWavelength", oldWL, newWL);
    }

    public void setPending(boolean b) {
        super.setPending(b);
    }

    public double[] toArrayData() {
        double[] array = new double[this.fNumPoints];
        double wl = this.fMinWavelength.getValue();
        double inc = (this.fMaxWavelength.getValue() - wl) / (double)this.fNumPoints;
        for (int i = 0; i < this.fNumPoints; ++i) {
            array[i] = this.getValue(new Wavelength(wl));
            wl += inc;
        }
        return array;
    }

    public double[] toArrayWavelengths() {
        double[] array = new double[this.fNumPoints];
        double wl = this.fMinWavelength.getValue();
        double inc = (this.fMaxWavelength.getValue() - wl) / (double)this.fNumPoints;
        for (int i = 0; i < this.fNumPoints; ++i) {
            array[i] = wl;
            wl += inc;
        }
        return array;
    }

    public Wavelength getWavelengthAtIndex(int index) {
        return new Wavelength(this.getWavelengthAtIndexAsDouble(index));
    }

    public double getWavelengthAtIndexAsDouble(int index) {
        double inc = (this.fMaxWavelength.getValue() - this.fMinWavelength.getValue()) / (double)this.fNumPoints;
        return this.fMinWavelength.getValue() + (double)index * inc;
    }

    public double getValueAtIndex(int i) {
        return this.getValue(this.getWavelengthAtIndex(i));
    }

    public void setNumPoints(int newP) {
        int oldP = this.fNumPoints;
        this.fNumPoints = newP;
        this.firePropertyChange("NumPoints", new Integer(oldP), new Integer(newP));
    }

    public int getNumPoints() {
        return this.fNumPoints;
    }
}

