/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import jsky.science.Time;
import jsky.timeline.TimeLineModel;
import jsky.timeline.TimeLineNodeModel;

public class DefaultTimeLineNodeModel
implements TimeLineNodeModel {
    private boolean fIsConstant;
    private String fTimeLineNodeName = "unknown";
    private Time fStartTime = new Time(0.0);
    private Time fEndTime = new Time(0.0);
    private PropertyChangeSupport fChangeSupport = new PropertyChangeSupport(this);
    private TimeLineModel fParent;
    static /* synthetic */ Class class$jsky$timeline$DefaultTimeLineNode;

    public DefaultTimeLineNodeModel(Time start, Time end) {
        this(start, end, "unknown", false);
    }

    public DefaultTimeLineNodeModel(Time startTime, Time endTime, String name) {
        this(startTime, endTime, name, false);
    }

    public DefaultTimeLineNodeModel(Time startTime, Time endTime, String name, boolean isConstant) {
        this.fTimeLineNodeName = name;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fIsConstant = isConstant;
    }

    public Time getStartTime() {
        return this.fStartTime;
    }

    public void setStartTime(Time time) {
        if (time.getValue(Time.SECOND) != this.fStartTime.getValue(Time.SECOND)) {
            Time oldTime = this.fStartTime;
            if (time.getValue(Time.SECOND) < this.getEndTime().getValue(Time.SECOND)) {
                this.fStartTime = time;
                this.fChangeSupport.firePropertyChange("StartTime", oldTime, time);
            }
        }
    }

    public void moveTimeLineNodeBy(Time time) {
        if (time.getValue(Time.SECOND) != 0.0) {
            Time oldStartTime = this.fStartTime;
            Time oldEndTime = this.fEndTime;
            this.fStartTime = new Time(this.fStartTime.getValue(Time.SECOND) + time.getValue(Time.SECOND), Time.SECOND);
            this.fEndTime = new Time(this.fEndTime.getValue(Time.SECOND) + time.getValue(Time.SECOND), Time.SECOND);
            this.fChangeSupport.firePropertyChange("StartTime", oldStartTime, this.fStartTime);
            this.fChangeSupport.firePropertyChange("EndTime", oldEndTime, this.fEndTime);
        }
    }

    public Time getEndTime() {
        return this.fEndTime;
    }

    public void setEndTime(Time time) {
        if (time.getValue(Time.SECOND) != this.fEndTime.getValue(Time.SECOND)) {
            Time oldTime = this.fEndTime;
            if (time.getValue(Time.SECOND) > this.getStartTime().getValue(Time.SECOND)) {
                this.fEndTime = time;
                this.fChangeSupport.firePropertyChange("EndTime", oldTime, time);
            }
        }
    }

    public Time getDuration() {
        double value = this.fEndTime.getValue(Time.SECOND) - this.fStartTime.getValue(Time.SECOND);
        return new Time(value, Time.SECOND);
    }

    public void setDuration(Time durationLength) {
        if (durationLength != null) {
            Time val = this.getStartTime();
            this.setEndTime(new Time(this.fStartTime.getValue(Time.SECOND) + durationLength.getValue(Time.SECOND), Time.SECOND));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fChangeSupport.removePropertyChangeListener(listener);
    }

    public void setTimeLineNodeName(String name) {
        if (this.fTimeLineNodeName != name) {
            String oldName = this.fTimeLineNodeName;
            this.fTimeLineNodeName = name;
            this.fChangeSupport.firePropertyChange("Name", oldName, name);
        }
    }

    public String getTimeLineNodeName() {
        return this.fTimeLineNodeName;
    }

    public boolean intersects(TimeLineNodeModel node) {
        double nodeStart = node.getStartTime().getValue(Time.SECOND);
        double nodeEnd = node.getEndTime().getValue(Time.SECOND);
        double thisStart = this.fStartTime.getValue(Time.SECOND);
        double thisEnd = this.fEndTime.getValue(Time.SECOND);
        boolean result = false;
        if (nodeStart > thisStart && nodeStart < thisEnd || nodeEnd < thisEnd && nodeEnd > thisStart || nodeStart < thisStart && nodeEnd > thisStart) {
            result = true;
        }
        return result;
    }

    public TimeLineModel getParent() {
        return this.fParent;
    }

    public void setParent(TimeLineModel parent) {
        if (parent != this.fParent) {
            TimeLineModel oldParent = this.fParent;
            this.fParent = parent;
            this.fChangeSupport.firePropertyChange("Parent", oldParent, this.fParent);
        }
    }

    public synchronized void setTimeLineNode(Time start, Time end) {
        Time oldStartTime = this.fStartTime;
        Time oldEndTime = this.fEndTime;
        if (this.fStartTime.getValue() != start.getValue() || this.fEndTime.getValue() != end.getValue()) {
            this.fStartTime = start;
            this.fEndTime = end;
            this.fChangeSupport.firePropertyChange("StartTime", oldStartTime, this.fStartTime);
            this.fChangeSupport.firePropertyChange("EndTime", oldEndTime, this.fEndTime);
        }
    }

    public boolean isConstant() {
        return this.fIsConstant;
    }

    public void setConstant(boolean isConstant) {
        this.fIsConstant = isConstant;
    }

    public Class getGUIClass() {
        return class$jsky$timeline$DefaultTimeLineNode == null ? (class$jsky$timeline$DefaultTimeLineNode = DefaultTimeLineNodeModel.class$("jsky.timeline.DefaultTimeLineNode")) : class$jsky$timeline$DefaultTimeLineNode;
    }

    public String toString() {
        String str = this.getTimeLineNodeName() + ":\n";
        str = str + "\t start time:\t" + this.getStartTime().getValue(Time.MINUTE) + "\n";
        str = str + "\t end time:\t" + this.getEndTime().getValue(Time.MINUTE) + "\n";
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

