/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import jsky.science.Time;
import jsky.timeline.DefaultTimeLineNodeModel;
import jsky.timeline.DetailedPropertyVetoException;
import jsky.timeline.TimeLineNodeModel;
import jsky.timeline.VetoableTimeLineNodeModel;

public class DefaultVetoableTimeLineNodeModel
extends DefaultTimeLineNodeModel
implements VetoableTimeLineNodeModel {
    private Time fOldStartTime = new Time(0.0);
    private Time fOldEndTime = new Time(0.0);
    protected VetoableChangeSupport fChangeSupport = new VetoableChangeSupport(this);

    public DefaultVetoableTimeLineNodeModel(Time start, Time end) {
        this(start, end, "unknown", false);
    }

    public DefaultVetoableTimeLineNodeModel(Time startTime, Time endTime, String name) {
        this(startTime, endTime, name, false);
    }

    public DefaultVetoableTimeLineNodeModel(Time startTime, Time endTime, String name, boolean isConstant) {
        super(startTime, endTime, name, isConstant);
        this.fOldStartTime = startTime;
        this.fOldEndTime = endTime;
    }

    public void setValidStartTime(Time time) throws DetailedPropertyVetoException {
        if (time.getValue(Time.SECOND) != this.getStartTime().getValue(Time.SECOND)) {
            Time oldTime = this.getStartTime();
            try {
                if (!(time.getValue(Time.SECOND) < this.getEndTime().getValue(Time.SECOND))) {
                    throw new DetailedPropertyVetoException(this, "The Node minimum size has been exceeded", "invalid start time", null);
                }
                super.setStartTime(time);
                this.fChangeSupport.fireVetoableChange("StartTime", oldTime, time);
                this.fOldStartTime = oldTime;
            }
            catch (DetailedPropertyVetoException ex) {
                this.setStartTime(oldTime);
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void moveTimeLineNodeByValid(Time time) throws DetailedPropertyVetoException {
        if (time.getValue(Time.SECOND) != 0.0) {
            Time oldStartTime = this.getStartTime();
            Time oldEndTime = this.getEndTime();
            try {
                super.moveTimeLineNodeBy(time);
                this.fOldStartTime = oldStartTime;
                this.fOldEndTime = oldEndTime;
                this.fChangeSupport.fireVetoableChange("StartTime", oldStartTime, this.getStartTime());
                this.fChangeSupport.fireVetoableChange("EndTime", oldEndTime, this.getEndTime());
            }
            catch (DetailedPropertyVetoException ex) {
                super.moveTimeLineNodeBy(new Time(time.getValue() * -1.0));
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setValidEndTime(Time time) throws DetailedPropertyVetoException {
        if (time.getValue(Time.SECOND) != this.getEndTime().getValue(Time.SECOND)) {
            Time oldTime = this.getEndTime();
            try {
                if (!(time.getValue(Time.SECOND) > this.getStartTime().getValue(Time.SECOND))) {
                    throw new DetailedPropertyVetoException(this, "The Node minimum size has been exceeded", "invalid end time", null);
                }
                super.setEndTime(time);
                this.fChangeSupport.fireVetoableChange("EndTime", oldTime, time);
                this.fOldEndTime = oldTime;
            }
            catch (DetailedPropertyVetoException ex) {
                super.setEndTime(oldTime);
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setValidDuration(Time durationLength) throws DetailedPropertyVetoException {
        if (durationLength != null) {
            Time val = this.getStartTime();
            this.setValidEndTime(new Time(this.getStartTime().getValue(Time.SECOND) + durationLength.getValue(Time.SECOND), Time.SECOND));
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.removeVetoableChangeListener(listener);
    }

    public void revertToPrevious() {
        try {
            super.setStartTime(this.fOldStartTime);
            super.setEndTime(this.fOldEndTime);
            this.fChangeSupport.fireVetoableChange("Node", 0, 1);
        }
        catch (DetailedPropertyVetoException ex) {
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
        TimeLineNodeModel node;
        if (evt.getPropertyName() != "node removed" && evt.getSource() instanceof TimeLineNodeModel && (node = (TimeLineNodeModel)evt.getSource()) != this && (this.intersects(node) || node.intersects(this))) {
            throw new DetailedPropertyVetoException(this, "Node Overlap", "node " + this.getTimeLineNodeName() + " overlaps " + node.getTimeLineNodeName(), evt);
        }
    }

    public synchronized void setValidTimeLineNode(Time start, Time end) throws DetailedPropertyVetoException {
        Time oldStartTime = this.getStartTime();
        Time oldEndTime = this.getEndTime();
        try {
            this.setTimeLineNode(start, end);
            this.fChangeSupport.fireVetoableChange("StartTime", oldStartTime, this.getStartTime());
            this.fChangeSupport.fireVetoableChange("EndTime", oldEndTime, this.getEndTime());
        }
        catch (DetailedPropertyVetoException ex) {
            this.setTimeLineNode(start, end);
            throw ex;
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }
}

