/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import jsky.coords.HMS;
import jsky.science.Time;
import jsky.timeline.BlockTimeLineNode;
import jsky.timeline.DefaultTimeLineModel;
import jsky.timeline.DefaultTimeLineNode;
import jsky.timeline.DetailedPropertyVetoException;
import jsky.timeline.IllegalNodePositionException;
import jsky.timeline.TimeLineModel;
import jsky.timeline.TimeLineNode;
import jsky.timeline.TimeLineNodeModel;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DialogUtil;

public class TimeLine
extends JPanel {
    public static final String DATE_VIEW = "Date View";
    public static final String TIME_VIEW = "Time View";
    public static final String DISPLAY_WINDOW_CHANGE = "Display Window Change";
    public static final String NODE_ADDED = "node added";
    public static final String NODE_REMOVED = "node removed";
    public static final String SELECTION_MODE = "Selection";
    public static final String ZOOM_MODE = "Zoom";
    protected static final double MIN_DISPLAY_WINDOW = 10.0;
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    protected Comparator _comparator = new TimeLineNodeComparator();
    protected float _handleHeight = 6.0f;
    protected float _verticalSpacer = 18.0f;
    protected Line2D.Float _centerLine = new Line2D.Float();
    protected List _nodes;
    protected List _vetoableListeners;
    protected int _intervalCount;
    protected String _mode = "Selection";
    protected String _unitType = Time.MINUTE;
    protected Time _displayStart;
    protected Time _displayEnd;
    protected Time _intervalInTime;
    protected TimeLineModel _model;
    protected boolean _labelsAtTop = false;
    protected MouseAdapter _mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent evt) {
            TimeLine.this.handleMouseClicked(evt);
        }

        public void mousePressed(MouseEvent evt) {
            TimeLine.this.handleMousePressed(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            TimeLine.this.handleMousePressed(evt);
        }
    };
    protected MouseMotionAdapter _mouseDragListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent evt) {
            Iterator listIterator = TimeLine.this._nodes.iterator();
            while (listIterator.hasNext()) {
                TimeLineNode node = (TimeLineNode)listIterator.next();
                node.handleMouseDragEvent(evt);
            }
            TimeLine.this.repaint();
        }

        public void mouseMoved(MouseEvent evt) {
            Iterator listIterator = TimeLine.this._nodes.iterator();
            while (listIterator.hasNext()) {
                TimeLineNode node = (TimeLineNode)listIterator.next();
                node.handleMouseMoveEvent(evt);
            }
            TimeLine.this.repaint();
        }
    };
    protected KeyAdapter _keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent evt) {
            TimeLine.this.handleKeyEvent(evt);
        }
    };
    protected VetoableChangeListener _myChildListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
            TimeLine.this.validatePropertyChange(evt);
            TimeLine.this.repaint();
        }
    };
    protected PropertyChangeListener _myModelListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == TimeLine.NODE_ADDED) {
                TimeLineNode node;
                TimeLineNodeModel model = (TimeLineNodeModel)evt.getNewValue();
                boolean found = false;
                Iterator iter = TimeLine.this.getTimeLineNodesIterator();
                while (iter.hasNext()) {
                    node = (TimeLineNode)iter.next();
                    if (node.getModel() != model) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Class nodeClass = model.getGUIClass();
                    try {
                        node = (TimeLineNode)nodeClass.newInstance();
                        node.setModel(model);
                        TimeLine.this.addSilentTimeLineNode(node);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (evt.getPropertyName() == TimeLine.NODE_REMOVED) {
                TimeLineNodeModel model = (TimeLineNodeModel)evt.getOldValue();
                Iterator iter = TimeLine.this.getTimeLineNodesIterator();
                while (iter.hasNext()) {
                    TimeLineNode node = (TimeLineNode)iter.next();
                    if (node.getModel() != model) continue;
                    TimeLine.this.removeTimeLineNode(node);
                    break;
                }
            } else if (evt.getPropertyName() == "all nodes removed") {
                TimeLine.this.removeAllTimeLineNodes();
            }
        }
    };

    public TimeLine() {
        this(0, 50, 50);
    }

    public TimeLine(int interval) {
        this(0, 50, interval);
    }

    public TimeLine(int start, int end, int intervals) {
        this(new Time(start, Time.MINUTE), new Time(end, Time.MINUTE), intervals);
    }

    public TimeLine(Time start, Time end, int intervals) {
        this(new DefaultTimeLineModel(start, end, intervals));
    }

    public TimeLine(TimeLineModel model) {
        Time start = model.getStartTime();
        Time end = model.getEndTime();
        int intervals = model.getIntervalCount();
        MouseInputAdapter msListener = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                this.setCursor(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.setCursor(e);
            }

            public void mouseMoved(MouseEvent e) {
                this.setCursor(e);
            }

            private void setCursor(MouseEvent e) {
                Cursor cursor = DEFAULT_CURSOR;
                Iterator iter = TimeLine.this.getTimeLineNodes().iterator();
                while (iter.hasNext()) {
                    TimeLineNode node = (TimeLineNode)iter.next();
                    if (!node.containsPoint(e.getPoint())) continue;
                    cursor = node.getCursor(e);
                    break;
                }
                TimeLine.this.setCursor(cursor);
            }
        };
        this.addMouseListener(msListener);
        this.addMouseMotionListener(msListener);
        this.setToolTipText("TimeLine");
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this._displayStart = start;
        this._displayEnd = end;
        this._model = model;
        this._model.addPropertyChangeListener(this._myModelListener);
        this._intervalCount = intervals;
        double intervalsInTime = (end.getValue(Time.SECOND) - start.getValue(Time.SECOND)) / (double)this._intervalCount;
        this._intervalInTime = new Time(intervalsInTime, Time.SECOND);
        this.addMouseListener(this._mouseListener);
        this.addMouseMotionListener(this._mouseDragListener);
        this.addKeyListener(this._keyListener);
        this._nodes = Collections.synchronizedList(new ArrayList(5));
        this._vetoableListeners = Collections.synchronizedList(new ArrayList(5));
        this.setBorder(BorderFactory.createEmptyBorder(20, 0, 70, 0));
    }

    public void addTimeLineNode(TimeLineNode node) throws IllegalNodePositionException {
        if (!this._nodes.contains(node)) {
            TimeLine oldParent = node.getParent();
            try {
                node.setParent(this);
                this._nodes.add(node);
                Collections.sort(this._nodes, this._comparator);
                this.updateExternal();
                this.validatePropertyChange(new PropertyChangeEvent(node, NODE_ADDED, null, node));
                node.addVetoableChangeListener(this._myChildListener);
                this.addVetoableChangeListener(node);
                this._model.addTimeLineNode(node.getModel());
            }
            catch (DetailedPropertyVetoException ex) {
                if (oldParent != this) {
                    node.setParent(oldParent);
                    this._nodes.remove(node);
                    Collections.sort(this._nodes, this._comparator);
                    this._model.removeTimeLineNode(node.getModel());
                    this.updateExternal();
                } else {
                    node.setParent(this);
                    node.addVetoableChangeListener(this._myChildListener);
                    this.addVetoableChangeListener(node);
                    Collections.sort(this._nodes, this._comparator);
                    this.updateExternal();
                }
                throw new IllegalNodePositionException("could not add node: " + node.getTimeLineNodeName());
            }
        }
        this.repaint();
    }

    public TimeLineModel getModel() {
        return this._model;
    }

    public void setModel(TimeLineModel model) {
        Time start = model.getStartTime();
        Time end = model.getEndTime();
        int intervals = model.getIntervalCount();
        this._displayStart = start;
        this._displayEnd = end;
        this._model = model;
        this._model.addPropertyChangeListener(this._myModelListener);
        this._intervalCount = intervals;
        double intervalsInTime = (end.getValue(Time.SECOND) - start.getValue(Time.SECOND)) / (double)this._intervalCount;
        this._intervalInTime = new Time(intervalsInTime, Time.SECOND);
        this._nodes = Collections.synchronizedList(new ArrayList(5));
        this._vetoableListeners = Collections.synchronizedList(new ArrayList(5));
        this.repaint();
    }

    protected void addSilentTimeLineNode(TimeLineNode node) {
        if (!this._nodes.contains(node)) {
            node.setParent(this);
            this._nodes.add(node);
            Collections.sort(this._nodes, this._comparator);
            this.updateExternal();
            node.addVetoableChangeListener(this._myChildListener);
            this.addVetoableChangeListener(node);
            this._model.addTimeLineNode(node.getModel());
        }
    }

    public void setUnitsType(String unitType) {
        this._unitType = unitType;
    }

    public boolean isLabelsAtTop() {
        return this._labelsAtTop;
    }

    public void setLabelsAtTop(boolean b) {
        this._labelsAtTop = b;
    }

    public float getHandleHeight() {
        return this._handleHeight;
    }

    public void setHandleHeight(float f) {
        this._handleHeight = f;
    }

    public float getVerticalSpacer() {
        return this._verticalSpacer;
    }

    public void setVerticalSpacer(float f) {
        this._verticalSpacer = f;
    }

    public String getUnitsType() {
        return this._unitType;
    }

    public synchronized void setDisplayArea(Time start, Time end) {
        if (this._displayStart.getValue() != start.getValue() || this._displayEnd.getValue() != end.getValue()) {
            Time oldStart = this._displayStart;
            Time oldEnd = this._displayEnd;
            this._displayStart = start;
            this._displayEnd = end;
            double intervalsInTime = (this._displayEnd.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND)) / (double)this._intervalCount;
            this._intervalInTime = new Time(intervalsInTime, Time.SECOND);
            try {
                this.fireVetoableChange(new PropertyChangeEvent(this, DISPLAY_WINDOW_CHANGE, null, null));
            }
            catch (DetailedPropertyVetoException ex) {
                this.setDisplayArea(oldStart, oldEnd);
            }
            this.repaint();
        }
    }

    public void resetDisplayArea() {
        this.setDisplayArea(new Time(this.getStartTime().getValue()), new Time(this.getEndTime().getValue()));
    }

    public synchronized void moveDisplayAreaBy(Time time) {
        if (time.getValue() != 0.0) {
            Time startTime = new Time(this._displayStart.getValue(Time.SECOND) + time.getValue(Time.SECOND), Time.SECOND);
            Time endTime = new Time(this._displayEnd.getValue(Time.SECOND) + time.getValue(Time.SECOND), Time.SECOND);
            this.setDisplayArea(startTime, endTime);
        }
        this.repaint();
    }

    public synchronized void removeTimeLineNode(TimeLineNode node) {
        if (this._nodes.contains(node)) {
            try {
                node.removeVetoableChangeListener(this._myChildListener);
                node.setParent(null);
                this.removeVetoableChangeListener(node);
                this._nodes.remove(node);
                this.fireVetoableChange(new PropertyChangeEvent(node, NODE_REMOVED, node, null));
                this._model.removeTimeLineNode(node.getModel());
            }
            catch (DetailedPropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void removeAllTimeLineNodes() {
        if (this._nodes.size() > 0) {
            Iterator iter = this._nodes.iterator();
            while (iter.hasNext()) {
                TimeLineNode node = (TimeLineNode)iter.next();
                node.setParent(null);
                node.removeVetoableChangeListener(this._myChildListener);
                this.removeVetoableChangeListener(node);
                iter.remove();
            }
            this._model.removeAllTimeLineNodes();
        }
    }

    public Time getIntervalTime() {
        return this._intervalInTime;
    }

    public int getIntervalCount() {
        return this._model.getIntervalCount();
    }

    protected void paintComponent(Graphics grph) {
        super.paintComponent(grph);
        Graphics2D g2 = (Graphics2D)grph;
        this.paintCenterLine(g2);
        this.paintStartLabel(g2);
        this.paintEndLabel(g2);
        this.paintNodes(g2);
    }

    protected void paintCenterLine(Graphics2D g2) {
        Dimension dim = this.getSize();
        this._centerLine.x1 = this._verticalSpacer;
        this._centerLine.y1 = (float)dim.height / 2.0f;
        this._centerLine.x2 = (float)dim.width - this._verticalSpacer;
        this._centerLine.y2 = (float)dim.height / 2.0f;
        g2.setColor(this.getBackground());
        g2.fill3DRect((int)this._centerLine.x1, (int)this._centerLine.y1 - 1, (int)(this._centerLine.x2 - this._centerLine.x1), 3, false);
        Line2D.Float stopLine = new Line2D.Float();
        if (this._displayStart.getValue(Time.SECOND) <= this.getStartTime().getValue(Time.SECOND)) {
            stopLine.x1 = this._centerLine.x1 - 1.0f;
            stopLine.x2 = this._centerLine.x1 - 1.0f;
            stopLine.y1 = ((float)dim.height - this._handleHeight) / 2.0f;
            stopLine.y2 = ((float)dim.height + this._handleHeight) / 2.0f;
            g2.fill3DRect((int)stopLine.x1 - 1, (int)stopLine.y1, 3, (int)(stopLine.y2 - stopLine.y1), false);
        }
        if (this._displayEnd.getValue(Time.SECOND) >= this.getEndTime().getValue(Time.SECOND)) {
            stopLine.x1 = this._centerLine.x2 + 2.0f;
            stopLine.x2 = this._centerLine.x2 + 2.0f;
            stopLine.y1 = ((float)dim.height - this._handleHeight) / 2.0f;
            stopLine.y2 = ((float)dim.height + this._handleHeight) / 2.0f;
            g2.fill3DRect((int)stopLine.x1 - 1, (int)stopLine.y1, 3, (int)(stopLine.y2 - stopLine.y1), false);
        }
    }

    protected void paintStartLabel(Graphics2D g2) {
        float textY;
        Dimension dim = this.getSize();
        Rectangle clip = g2.getClipBounds();
        String startStr = "";
        if (this._unitType == DATE_VIEW) {
            DateFormat format = DateFormat.getDateInstance(3);
            startStr = format.format(this.getDateForTime(this._displayStart));
        } else if (this._unitType == TIME_VIEW) {
            HMS hms = new HMS(this._displayStart.getValue(Time.HOUR));
            startStr = hms.toString();
        } else {
            DecimalFormat form = new DecimalFormat();
            form.setMaximumFractionDigits(2);
            startStr = form.format(this._displayStart.getValue(this._unitType));
        }
        Rectangle2D nameBounds = g2.getFontMetrics().getStringBounds(startStr, g2);
        g2.setColor(Color.black);
        float textX = this._centerLine.x1 - (float)(1.0 + nameBounds.getWidth() / 2.0);
        if (this._labelsAtTop) {
            textY = (float)nameBounds.getHeight();
        } else {
            int yOff = 32;
            textY = ((float)dim.height + this._handleHeight) / 2.0f + (float)(nameBounds.getHeight() + (double)yOff);
        }
        g2.drawString(startStr, textX, textY);
    }

    protected void paintEndLabel(Graphics2D g2) {
        float textY;
        Dimension dim = this.getSize();
        Rectangle clip = g2.getClipBounds();
        String endStr = "";
        if (this._unitType == DATE_VIEW) {
            DateFormat format = DateFormat.getDateInstance(3);
            endStr = format.format(this.getDateForTime(this._displayEnd));
        } else if (this._unitType == TIME_VIEW) {
            HMS hms = new HMS(this._displayEnd.getValue(Time.HOUR));
            endStr = hms.toString();
        } else {
            DecimalFormat form = new DecimalFormat();
            form.setMaximumFractionDigits(2);
            endStr = form.format(this._displayEnd.getValue(this._unitType));
        }
        Rectangle2D nameBounds = g2.getFontMetrics().getStringBounds(endStr, g2);
        g2.setColor(Color.black);
        float textX = this._centerLine.x2 + (float)(1.0 - nameBounds.getWidth() / 2.0);
        if (this._labelsAtTop) {
            textY = (float)nameBounds.getHeight();
        } else {
            int yOff = 32;
            textY = ((float)dim.height + this._handleHeight) / 2.0f + (float)(nameBounds.getHeight() + (double)yOff);
        }
        g2.drawString(endStr, textX, textY);
        if (this._unitType != DATE_VIEW && this._unitType != TIME_VIEW) {
            String unitAbbrev = Time.getUnitsAbbrev(this._unitType);
            nameBounds = g2.getFontMetrics().getStringBounds(unitAbbrev, g2);
            textX = this._centerLine.x2 + (float)(1.0 - nameBounds.getWidth() / 2.0);
            textY = textY + (float)nameBounds.getHeight() - 2.0f;
            g2.drawString(unitAbbrev, textX, textY);
        }
    }

    protected void paintNodes(Graphics2D g2) {
        Iterator listIterator = this._nodes.iterator();
        while (listIterator.hasNext()) {
            TimeLineNode node = (TimeLineNode)listIterator.next();
            node.paintTimeLineNode(g2);
        }
    }

    public Time getDisplayStart() {
        return this._displayStart;
    }

    public Time getDisplayEnd() {
        return this._displayEnd;
    }

    public Iterator getTimeLineNodesIterator() {
        return this._nodes.iterator();
    }

    public List getTimeLineNodes() {
        Collections.sort(this._nodes, this._comparator);
        return Collections.unmodifiableList(this._nodes);
    }

    public void handleKeyEvent(KeyEvent evt) {
        List<TimeLineNode> procList = Collections.synchronizedList(new ArrayList(this._nodes.size()));
        try {
            Iterator listIterator = this._nodes.iterator();
            while (listIterator.hasNext()) {
                TimeLineNode node = (TimeLineNode)listIterator.next();
                node.handleKeyEvent(evt);
                procList.add(node);
            }
        }
        catch (DetailedPropertyVetoException ex) {
            Iterator listIterator = procList.iterator();
            while (listIterator.hasNext()) {
                TimeLineNode node = (TimeLineNode)listIterator.next();
                node.revertToPrevious();
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (!this._vetoableListeners.contains(listener)) {
            this._vetoableListeners.add(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this._vetoableListeners.remove(listener);
    }

    public void setMode(String mode) {
        this._mode = mode;
    }

    public Time getTimeForPoint(float xValue) {
        double currentWindowWidth = this._displayEnd.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND);
        double time = (double)(xValue -= this._verticalSpacer) * currentWindowWidth / ((double)this.getSize().width - 2.0 * (double)this._verticalSpacer);
        return new Time(time += this._displayStart.getValue(Time.SECOND), Time.SECOND);
    }

    public float getPointForTime(Time time) {
        double timeValue = time.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND);
        double currentWindowWidth = this._displayEnd.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND);
        double xValue = timeValue * ((double)this.getSize().width - 2.0 * (double)this._verticalSpacer) / currentWindowWidth;
        return Math.round(xValue += (double)this._verticalSpacer);
    }

    public Date getDateForTime(Time time) {
        return this._model.getDateForTime(time);
    }

    public Time getTimeForDate(Date date) {
        return this._model.getTimeForDate(date);
    }

    public void setStartDate(Date date) {
        this._model.setStartDate(date);
    }

    public Date getStartDate() {
        return this._model.getStartDate();
    }

    public Time getStartTime() {
        return this._model.getStartTime();
    }

    public Time getEndTime() {
        return this._model.getEndTime();
    }

    public List getSelectedNodes() {
        ArrayList<TimeLineNode> list = new ArrayList<TimeLineNode>();
        Iterator listIterator = this._nodes.iterator();
        while (listIterator.hasNext()) {
            TimeLineNode node = (TimeLineNode)listIterator.next();
            if (!node.isSelected()) continue;
            list.add(node);
        }
        return list;
    }

    public String getMode() {
        return this._mode;
    }

    protected void validatePropertyChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
        TimeLineNode node = (TimeLineNode)evt.getSource();
        if (node.getStartTime().getValue(Time.SECOND) < this.getStartTime().getValue(Time.SECOND)) {
            throw new DetailedPropertyVetoException(this, "HitLeftEdge", "out of bounds", evt);
        }
        if (node.getEndTime().getValue(Time.SECOND) > this.getEndTime().getValue(Time.SECOND)) {
            throw new DetailedPropertyVetoException(this, "HitRightEdge", "out of bounds", evt);
        }
        if (evt.getPropertyName().equals("HitLeftEdge")) {
            Time startTime = node.getStartTime();
            Time moveBy = new Time(startTime.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND), Time.SECOND);
            this.moveDisplayAreaBy(moveBy);
        } else if (evt.getPropertyName().equals("HitRightEdge")) {
            Time endTime = node.getEndTime();
            Time moveBy = new Time(endTime.getValue(Time.SECOND) - this._displayEnd.getValue(Time.SECOND), Time.SECOND);
            this.moveDisplayAreaBy(moveBy);
        } else {
            this.fireVetoableChange(evt);
            Collections.sort(this._nodes, this._comparator);
        }
    }

    protected void fireVetoableChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
        Iterator listIterator = this._vetoableListeners.iterator();
        while (listIterator.hasNext()) {
            VetoableChangeListener listener = (VetoableChangeListener)listIterator.next();
            if (listener == evt.getSource()) continue;
            try {
                listener.vetoableChange(evt);
            }
            catch (DetailedPropertyVetoException ex) {
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void handleMouseClicked(MouseEvent evt) {
        if (this._mode.equals(SELECTION_MODE)) {
            this.handleSelectionEvent(evt);
        } else if (this._mode.equals(ZOOM_MODE)) {
            this.handleZoomEvent(evt);
        }
    }

    protected void handleMousePressed(MouseEvent evt) {
        if (this._mode.equals(SELECTION_MODE)) {
            this.handleSelectionEvent(evt);
        } else if (this._mode.equals(ZOOM_MODE)) {
            // empty if block
        }
    }

    private void handleZoomEvent(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.zoomOut(evt.getPoint());
        } else {
            this.zoomIn(evt.getPoint());
        }
    }

    public void zoomIn() {
        int x = (int)Math.round((double)(this._centerLine.x1 + this._centerLine.x2) / 2.0);
        int y = Math.round(this._centerLine.y1);
        this.zoomIn(new Point(x, y));
    }

    public void zoomOut() {
        int x = (int)Math.round((double)(this._centerLine.x1 + this._centerLine.x2) / 2.0);
        int y = Math.round(this._centerLine.y1);
        this.zoomOut(new Point(x, y));
    }

    public void zoomIn(Point centerPt) {
        double adjust;
        Time center = this.getTimeForPoint(centerPt.x);
        double currentWindowWidth = this._displayEnd.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND);
        if ((currentWindowWidth /= 2.0) < 10.0) {
            currentWindowWidth = 10.0;
        }
        double startX = Math.floor(center.getValue(Time.SECOND) - currentWindowWidth / 2.0);
        double endX = Math.floor(center.getValue(Time.SECOND) + currentWindowWidth / 2.0);
        if (startX < this.getStartTime().getValue(Time.SECOND)) {
            adjust = this.getStartTime().getValue(Time.SECOND) - startX;
            startX += adjust;
            endX += adjust;
        }
        if (endX > this.getEndTime().getValue(Time.SECOND)) {
            adjust = endX - this.getEndTime().getValue(Time.SECOND);
            startX -= adjust;
            endX -= adjust;
        }
        Time startTime = new Time(startX, Time.SECOND);
        Time endTime = new Time(endX, Time.SECOND);
        this.setDisplayArea(startTime, endTime);
    }

    public void zoomOut(Point centerPt) {
        double adjust;
        Time center = this.getTimeForPoint(centerPt.x);
        double currentWindowWidth = this._displayEnd.getValue(Time.SECOND) - this._displayStart.getValue(Time.SECOND);
        double maxWidth = this.getEndTime().getValue(Time.SECOND) - this.getStartTime().getValue(Time.SECOND);
        if ((currentWindowWidth *= 2.0) > maxWidth) {
            currentWindowWidth = maxWidth;
        }
        double startX = Math.floor(center.getValue(Time.SECOND) - currentWindowWidth / 2.0);
        double endX = Math.floor(center.getValue(Time.SECOND) + currentWindowWidth / 2.0);
        if (startX < this.getStartTime().getValue(Time.SECOND)) {
            adjust = this.getStartTime().getValue(Time.SECOND) - startX;
            startX += adjust;
            endX += adjust;
        }
        if (endX > this.getEndTime().getValue(Time.SECOND)) {
            adjust = endX - this.getEndTime().getValue(Time.SECOND);
            startX -= adjust;
            endX -= adjust;
        }
        Time startTime = new Time(startX, Time.SECOND);
        Time endTime = new Time(endX, Time.SECOND);
        this.setDisplayArea(startTime, endTime);
    }

    private void handleSelectionEvent(MouseEvent evt) {
        Iterator listIterator = this._nodes.iterator();
        while (listIterator.hasNext()) {
            TimeLineNode node = (TimeLineNode)listIterator.next();
            node.handleMouseEvent(evt);
        }
    }

    public String getToolTipText(MouseEvent event) {
        String result = null;
        Point pt = event.getPoint();
        Iterator iter = this._nodes.iterator();
        while (iter.hasNext()) {
            TimeLineNode node = (TimeLineNode)iter.next();
            if (!node.containsPoint(pt)) continue;
            result = node.getDescription(pt);
            break;
        }
        return result;
    }

    protected void updateExternal() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TimeLine");
        TimeLine timeLine = new TimeLine();
        DefaultTimeLineModel model = new DefaultTimeLineModel(0, 40, 10);
        timeLine.setModel(model);
        try {
            timeLine.addTimeLineNode(new BlockTimeLineNode(new Time(0.0), new Time(300.0), "Block 1"));
            String label1 = "Label 1";
            DefaultTimeLineNode node1 = new DefaultTimeLineNode(new Time(480.0), new Time(720.0), label1){

                public String getDescription(Point pt) {
                    String details = "<html><font size='-2'>";
                    details = details + "<table width=\"100%\" border=0 cellpadding=0 cellspacing=0 >";
                    details = details + "<caption align='TOP'><font siz='-1'><div align=center><b>Node Info</b></div></font></caption>";
                    details = details + "Test info";
                    details = details + "</table>";
                    details = details + "</font></html>";
                    return details;
                }
            };
            timeLine.addTimeLineNode(node1);
            node1.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    System.out.println("XXX node 1 changed: " + evt);
                }
            });
            String label2 = "Label 2";
            DefaultTimeLineNode node2 = new DefaultTimeLineNode(new Time(1440.0), new Time(1800.0), label2){

                public String getDescription(Point pt) {
                    return "Node Description";
                }
            };
            timeLine.addTimeLineNode(node2);
            node2.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    System.out.println("XXX node 2 changed: " + evt);
                }
            });
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        timeLine.setPreferredSize(new Dimension(400, 100));
        frame.getContentPane().add((Component)new JScrollPane(timeLine), "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    private static class TimeLineNodeComparator
    implements Comparator {
        private TimeLineNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            double start1 = ((TimeLineNode)o1).getStartTime().getValue(Time.SECOND);
            double start2 = ((TimeLineNode)o2).getStartTime().getValue(Time.SECOND);
            return (int)Math.round(start1 - start2);
        }
    }
}

