/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import jsky.util.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxParserUtil
extends DefaultHandler {
    private String _cdata = null;
    private Class[] _parameterTypes = new Class[]{class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = SaxParserUtil.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes};
    private Stack _stack = new Stack();
    private URL _url;
    static /* synthetic */ Class class$org$xml$sax$Attributes;

    public void parse(URL url) {
        this._url = url;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(url.toString());
        }
        catch (SAXException e) {
            e.printStackTrace();
            Exception ee = e.getException();
            while (ee != null) {
                ee.printStackTrace();
                if (ee instanceof SAXException) {
                    ee = ((SAXException)ee).getException();
                    continue;
                }
                ee = null;
            }
            throw new RuntimeException("SAX Error parsing XML document: " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void parse(String urlStr) throws MalformedURLException {
        URL url = new URL(urlStr);
        this.parse(url);
    }

    public void parse(URL url, InputStream in) {
        this._url = url;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(new InputSource(in));
        }
        catch (SAXException e) {
            e.printStackTrace();
            Exception ee = e.getException();
            while (ee != null) {
                ee.printStackTrace();
                if (ee instanceof SAXException) {
                    ee = ((SAXException)ee).getException();
                    continue;
                }
                ee = null;
            }
            throw new RuntimeException("SAX Error parsing XML document: " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public URL getURL() {
        return this._url;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            String fileName = new File(new URL(systemId).getFile()).getName();
            URL url = Resources.getResource(fileName);
            return new InputSource(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Error resolving entity: " + systemId + ": " + e.toString());
        }
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Fatal error: " + e.getMessage());
        throw e;
    }

    public void error(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Error: " + e.getMessage());
        throw e;
    }

    public void warning(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Warning: " + e.getMessage());
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        Object[] args = new Object[]{attrs};
        String methodName = "_" + qName + "Start";
        try {
            this.getClass().getMethod(methodName, this._parameterTypes).invoke((Object)this, args);
        }
        catch (InvocationTargetException e1) {
            Throwable t = e1.getTargetException();
            System.out.println("SaxParserUtil.startElement: error calling " + methodName + ": " + t);
        }
        catch (Exception e2) {
            System.out.println("SaxParserUtil.startElement: error calling " + methodName + ": " + e2);
        }
        this._stack.push(qName);
        this._cdata = null;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this._stack.pop();
        String methodName = "_" + qName + "End";
        try {
            this.getClass().getMethod(methodName, null).invoke((Object)this, null);
        }
        catch (Exception e) {
            System.out.println("SaxParserUtil.endElement: error calling " + methodName + ": " + e + ": " + e.getMessage());
            e.printStackTrace();
        }
        this._cdata = null;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        this._cdata = this._cdata == null ? s : this._cdata + s;
    }

    protected String getCData() {
        return this._cdata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

