/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

public class StringUtil {
    public static String replace(String source, String target, String replacement) {
        StringBuffer sbuf = new StringBuffer(source);
        int n = source.length();
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            if (!source.startsWith(target, i)) continue;
            int tl = target.length();
            int rl = replacement.length();
            sbuf.replace(i + offset, i + offset + tl, replacement);
            offset += rl - tl;
            i += tl - 1;
        }
        return sbuf.toString();
    }

    public static String[] split(String s, int sep) {
        int i = s.indexOf(sep);
        if (i > 0) {
            String[] ar = new String[]{s.substring(0, i), s.substring(i + 1)};
            return ar;
        }
        return null;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean match(String pattern, String string) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*' || pattern.charAt(p) == '%') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!StringUtil.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println("test StringUtil.replace");
        String source = "replace $this with $that and $this with $that";
        String s = StringUtil.replace(source, "$this", "X");
        System.out.println("s (1) = " + s);
        s = StringUtil.replace(s, "$that", "Y");
        System.out.println("s (2) = " + s);
        System.out.println("");
        System.out.println("test StringUtil.split");
        String[] ar = StringUtil.split("test|passed", 124);
        if (ar == null) {
            System.out.println("test failed");
        } else {
            System.out.println(ar[0] + " " + ar[1]);
        }
    }
}

