/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class TransferableList
extends ArrayList
implements Transferable {
    public TransferableList() {
    }

    public TransferableList(Collection c) {
        super(c);
    }

    public TransferableList(int initialCapacity) {
        super(initialCapacity);
    }

    public DataFlavor[] getTransferDataFlavors() {
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        for (int i = 0; i < this.size(); ++i) {
            Transferable obj = (Transferable)this.get(i);
            DataFlavor[] objFlavs = obj.getTransferDataFlavors();
            for (int j = 0; j < objFlavs.length; ++j) {
                flavors.add(objFlavs[j]);
            }
        }
        DataFlavor[] flavArray = new DataFlavor[flavors.size()];
        int i = 0;
        Iterator iter = flavors.iterator();
        while (iter.hasNext()) {
            flavArray[i++] = (DataFlavor)iter.next();
        }
        return flavArray;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean supported = false;
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Transferable obj = (Transferable)this.get(i);
            if (!obj.isDataFlavorSupported(flavor)) continue;
            data.add(obj.getTransferData(flavor));
        }
        if (data.size() == 0) {
            throw new UnsupportedFlavorException(flavor);
        }
        return data.toArray();
    }
}

