/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelMenu
extends JMenu {
    private String currentUI = "Metal";
    private JRadioButtonMenuItem macMenuItem;
    private JRadioButtonMenuItem metalMenuItem;
    private JRadioButtonMenuItem motifMenuItem;
    private JRadioButtonMenuItem windowsMenuItem;
    private static final String macClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static LinkedList windows = new LinkedList();

    public LookAndFeelMenu(String title) {
        super(title);
        ButtonGroup group = new ButtonGroup();
        ToggleUIListener toggleUIListener = new ToggleUIListener();
        this.metalMenuItem = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Java Look and Feel"));
        this.metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        this.metalMenuItem.setEnabled(LookAndFeelMenu.isAvailableLookAndFeel(metalClassName));
        group.add(this.metalMenuItem);
        this.metalMenuItem.addItemListener(toggleUIListener);
        this.metalMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.motifMenuItem = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Motif Look and Feel"));
        this.motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        this.motifMenuItem.setEnabled(LookAndFeelMenu.isAvailableLookAndFeel(motifClassName));
        group.add(this.motifMenuItem);
        this.motifMenuItem.addItemListener(toggleUIListener);
        this.motifMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.windowsMenuItem = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
        this.windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        this.windowsMenuItem.setEnabled(LookAndFeelMenu.isAvailableLookAndFeel(windowsClassName));
        group.add(this.windowsMenuItem);
        this.windowsMenuItem.addItemListener(toggleUIListener);
        this.windowsMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.macMenuItem = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem("Macintosh Look and Feel"));
        this.macMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Macintosh"));
        this.macMenuItem.setEnabled(LookAndFeelMenu.isAvailableLookAndFeel(macClassName));
        group.add(this.macMenuItem);
        this.macMenuItem.addItemListener(toggleUIListener);
        this.macMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, 8));
    }

    public LookAndFeelMenu() {
        this("Look and Feel");
    }

    public LookAndFeelMenu(Component frame) {
        this("Look and Feel");
        LookAndFeelMenu.addWindow(frame);
    }

    public LookAndFeelMenu(String title, Component frame) {
        this(title);
        LookAndFeelMenu.addWindow(frame);
    }

    public static void addWindow(Component c) {
        windows.add(c);
    }

    public static LinkedList getWindows() {
        return windows;
    }

    protected static boolean isAvailableLookAndFeel(String classname) {
        try {
            Class<?> lnfClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    class ToggleUIListener
    implements ItemListener {
        ToggleUIListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ListIterator it = windows.listIterator(0);
            while (it.hasNext()) {
                Component root = (Component)it.next();
                root.setCursor(Cursor.getPredefinedCursor(3));
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                try {
                    if (rb.isSelected()) {
                        if (rb.getText().equals("Windows Style Look and Feel")) {
                            LookAndFeelMenu.this.currentUI = "Windows";
                            UIManager.setLookAndFeel(LookAndFeelMenu.windowsClassName);
                            SwingUtilities.updateComponentTreeUI(root);
                        } else if (rb.getText().equals("Macintosh Look and Feel")) {
                            LookAndFeelMenu.this.currentUI = "Macintosh";
                            UIManager.setLookAndFeel(LookAndFeelMenu.macClassName);
                            SwingUtilities.updateComponentTreeUI(root);
                        } else if (rb.getText().equals("Motif Look and Feel")) {
                            LookAndFeelMenu.this.currentUI = "Motif";
                            UIManager.setLookAndFeel(LookAndFeelMenu.motifClassName);
                            SwingUtilities.updateComponentTreeUI(root);
                        } else if (rb.getText().equals("Java Look and Feel")) {
                            LookAndFeelMenu.this.currentUI = "Metal";
                            UIManager.setLookAndFeel(LookAndFeelMenu.metalClassName);
                            SwingUtilities.updateComponentTreeUI(root);
                        }
                    }
                }
                catch (UnsupportedLookAndFeelException exc) {
                    rb.setEnabled(false);
                    System.err.println("Unsupported LookAndFeel: " + rb.getText());
                    try {
                        LookAndFeelMenu.this.currentUI = "Metal";
                        LookAndFeelMenu.this.metalMenuItem.setSelected(true);
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        SwingUtilities.updateComponentTreeUI(root);
                    }
                    catch (Exception exc2) {
                        exc2.printStackTrace();
                        System.err.println("Could not load LookAndFeel: " + exc2);
                        exc2.printStackTrace();
                    }
                }
                catch (Exception exc) {
                    rb.setEnabled(false);
                    exc.printStackTrace();
                    System.err.println("Could not load LookAndFeel: " + rb.getText());
                    exc.printStackTrace();
                }
                root.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

