/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsky.science.Passband;
import jsky.science.Quantity;
import jsky.science.Wavelength;
import jsky.util.FormatUtilities;
import jsky.util.ReplacementEvent;

public class PassbandPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
FocusListener {
    Passband fBand = null;
    int fDecs = 2;
    JTextField fTextRange;
    JLabel fLabelUnits;
    public static final String PASSBAND = "Passband";
    private boolean isListening = false;
    static /* synthetic */ Class class$jsky$science$Wavelength;

    public PassbandPanel() {
        this(null, 12, 3);
    }

    public PassbandPanel(Passband inP) {
        this(inP, 12, 3);
    }

    public PassbandPanel(int width) {
        this(null, width, 3);
    }

    public PassbandPanel(Passband inP, int width, int labelLocation) {
        if (labelLocation == 3) {
            this.setLayout(new GridLayout(1, 2));
        } else {
            this.setLayout(new GridLayout(2, 1));
        }
        this.fTextRange = new JTextField(width);
        this.fTextRange.setActionCommand(PASSBAND);
        this.add(this.fTextRange);
        this.fLabelUnits = new JLabel(Quantity.getDefaultUnits(class$jsky$science$Wavelength == null ? (class$jsky$science$Wavelength = PassbandPanel.class$("jsky.science.Wavelength")) : class$jsky$science$Wavelength));
        List allUnits = Quantity.getAllUnits(class$jsky$science$Wavelength == null ? (class$jsky$science$Wavelength = PassbandPanel.class$("jsky.science.Wavelength")) : class$jsky$science$Wavelength);
        int maxWidth = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int i = 0; i < allUnits.size(); ++i) {
            maxWidth = Math.max(maxWidth, fm.stringWidth((String)allUnits.get(i)));
        }
        Dimension dim = this.getPreferredSize();
        dim.width = maxWidth + 10;
        this.fLabelUnits.setPreferredSize(dim);
        this.add(this.fLabelUnits);
        this.setPassband(inP);
        Quantity.addDefaultUnitsChangeListener(class$jsky$science$Wavelength == null ? (class$jsky$science$Wavelength = PassbandPanel.class$("jsky.science.Wavelength")) : class$jsky$science$Wavelength, this);
        this.addListeners();
    }

    private void addListeners() {
        if (!this.isListening) {
            this.isListening = true;
            this.fTextRange.addActionListener(this);
            this.fTextRange.addFocusListener(this);
        }
    }

    private void removeListeners() {
        if (this.isListening) {
            this.isListening = false;
            this.fTextRange.removeActionListener(this);
            this.fTextRange.removeFocusListener(this);
        }
    }

    private void updateText() {
        if (this.fBand == null) {
            this.fTextRange.setText("");
        } else if (this.fBand.getLowWavelength().equals(this.fBand.getHighWavelength())) {
            this.fTextRange.setText(FormatUtilities.formatDouble(this.fBand.getLowWavelength().getValue(), this.fDecs, this.fTextRange.getColumns()));
        } else {
            this.fTextRange.setText(FormatUtilities.formatDouble(this.fBand.getLowWavelength().getValue(), this.fDecs, this.fTextRange.getColumns()) + "-" + FormatUtilities.formatDouble(this.fBand.getHighWavelength().getValue(), this.fDecs, this.fTextRange.getColumns()));
        }
    }

    public void setPassband(Passband newP) {
        Passband oldP = this.fBand;
        if (this.fBand != null) {
            this.removePropertyChangeListener(this);
        }
        this.fBand = newP;
        this.updateText();
        if (this.fBand != null) {
            this.addPropertyChangeListener(this);
        }
    }

    public Passband getPassband() {
        return this.fBand;
    }

    public void setDecs(int inDecs) {
        this.fDecs = inDecs;
        this.updateText();
    }

    public int getDecs() {
        return this.fDecs;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals(Wavelength.DEFAULTUNITS_PROPERTY)) {
            this.fLabelUnits.setText((String)event.getNewValue());
            this.updateText();
        } else if (event.getSource() == this.fBand) {
            this.updateText();
        }
    }

    public void replaceObject(ReplacementEvent event) {
        if (event.getOldValue() == this.fBand) {
            this.setPassband((Passband)event.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event != null && event.getActionCommand().equals(PASSBAND)) {
            Passband tempP = new Passband(this.fTextRange.getText());
            this.fBand.setLowWavelength(tempP.getLowWavelength());
            this.fBand.setHighWavelength(tempP.getHighWavelength());
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        this.actionPerformed(null);
    }

    public void setUnitsVisible(boolean onOff) {
        this.fLabelUnits.setVisible(onOff);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

