/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import jsky.util.gui.DialogUtil;

public class PrintPreview
extends JFrame {
    protected int fPageWidth;
    protected int fPageHeight;
    protected Printable fTarget;
    protected JComboBox fComboBoxScale;
    protected PreviewContainer fPanelPreview;
    protected ActionListener fPrintListener;

    public PrintPreview(Printable target) {
        this(null, target, "Print Preview");
    }

    public PrintPreview(ActionListener printListener, Printable target, String title) {
        super(title);
        this.setSize(370, 510);
        this.fTarget = target;
        JToolBar toolbar = new JToolBar();
        JButton buttonPrint = new JButton("Print");
        buttonPrint.setMnemonic('p');
        buttonPrint.setToolTipText("Print the preview contents");
        this.fPrintListener = printListener == null ? new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    prnJob.setPrintable(PrintPreview.this.fTarget);
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                    prnJob.print();
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                    PrintPreview.this.dispose();
                }
                catch (PrinterException ex) {
                    ex.printStackTrace();
                    System.err.println("Printing error: " + ex.toString());
                }
            }
        } : printListener;
        buttonPrint.addActionListener(this.fPrintListener);
        toolbar.add(buttonPrint);
        JButton buttonClose = new JButton("Close");
        buttonClose.setMnemonic('c');
        buttonClose.setToolTipText("Close Preview");
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        buttonClose.addActionListener(lst);
        toolbar.add(buttonClose);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.fComboBoxScale = new JComboBox<String>(scales);
        this.fComboBoxScale.setToolTipText("Zoom");
        int scale = 50;
        this.fComboBoxScale.setSelectedItem("50 %");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        String str = 3.access$000(this.this$1).fComboBoxScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int sc = 0;
                        try {
                            sc = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = 3.access$000(this.this$1).fPageWidth * sc / 100;
                        int h = 3.access$000(this.this$1).fPageHeight * sc / 100;
                        Component[] comps = 3.access$000(this.this$1).fPanelPreview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        3.access$000(this.this$1).fPanelPreview.doLayout();
                        3.access$000(this.this$1).fPanelPreview.getParent().getParent().validate();
                    }
                };
                runner.start();
            }

            static /* synthetic */ PrintPreview access$000(3 x0) {
                return x0.PrintPreview.this;
            }
        };
        this.fComboBoxScale.addActionListener(lst);
        Dimension dim = new Dimension(80, 35);
        buttonPrint.setMaximumSize(dim);
        buttonClose.setMaximumSize(dim);
        this.fComboBoxScale.setMaximumSize(dim);
        this.fComboBoxScale.setEditable(true);
        toolbar.addSeparator();
        toolbar.add(this.fComboBoxScale);
        this.getContentPane().add((Component)toolbar, "North");
        this.fPanelPreview = new PreviewContainer();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.fPageWidth = (int)pageFormat.getWidth();
        this.fPageHeight = (int)pageFormat.getHeight();
        int pageIndex = 0;
        int w = this.fPageWidth * scale / 100;
        int h = this.fPageHeight * scale / 100;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.fPageWidth, this.fPageHeight, 1);
                Graphics2D g = img.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.fPageWidth, this.fPageHeight);
                if (this.fTarget.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.fPanelPreview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            DialogUtil.error(e);
        }
        JScrollPane ps = new JScrollPane(this.fPanelPreview);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

