/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jsky.util.Resources;
import jsky.util.StatusLogger;
import jsky.util.gui.BusyWin;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanelDialog;
import jsky.util.gui.StatusPanel;
import jsky.util.gui.SwingUtil;

public class ProgressPanel
extends JPanel
implements ActionListener,
StatusLogger {
    protected Component parent;
    protected String title;
    protected JLabel titleLabel;
    protected JLabel iconLabel;
    protected JButton stopButton;
    protected StatusPanel statusPanel;
    protected ProgressBarFilterInputStream loggedInputStream;
    protected boolean interrupted = false;
    protected static ProgressPanel newPanel;

    public ProgressPanel(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.init();
    }

    public ProgressPanel() {
        this(null, "Download in Progress...");
    }

    protected void init() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ProgressPanel.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressPanel.this.init();
                }
            });
            return;
        }
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JPanel top = new JPanel();
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        top.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(this.title, 0);
        this.titleLabel.setForeground(Color.black);
        top.add((Component)this.titleLabel, "West");
        this.iconLabel = new JLabel(Resources.getIcon("TaskStatusOn.gif"));
        top.add((Component)this.iconLabel, "East");
        JPanel center = new JPanel();
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        center.add(this.stopButton);
        top.add((Component)center, "South");
        this.statusPanel = new StatusPanel();
        this.statusPanel.getTextField().setColumns(25);
        this.add((Component)top, "North");
        this.add((Component)this.statusPanel, "South");
    }

    protected static void invokeAndWait(Runnable r) {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void setTitle(final String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.setTitle(title);
                }
            });
            return;
        }
        this.title = title;
        this.titleLabel.setText(title);
    }

    public void logMessage(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.statusPanel.setText(msg);
                }
            });
            return;
        }
        this.statusPanel.setText(msg);
    }

    public void setText(final String s) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.statusPanel.setText(s);
                }
            });
            return;
        }
        this.statusPanel.setText(s);
    }

    public void addActionListener(ActionListener l) {
        this.stopButton.addActionListener(l);
    }

    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void actionPerformed(ActionEvent e) {
        this.interrupted = true;
        this.stop();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public URLConnection openConnection(URL url) throws IOException {
        this.start();
        URLConnection connection = this.statusPanel.openConnection(url);
        if (this.interrupted) {
            throw new ProgressException("Interrupted");
        }
        return connection;
    }

    public void start() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.start();
                }
            });
            return;
        }
        this.interrupted = false;
        if (this.parent instanceof JFrame) {
            ((JFrame)this.parent).setState(0);
        }
        this.parent.setVisible(true);
        this.statusPanel.getProgressBar().startAnimation();
        BusyWin.setBusy(true, this.parent);
    }

    public void stop() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.stop();
                }
            });
            return;
        }
        BusyWin.setBusy(false, this.parent);
        if (this.loggedInputStream != null) {
            this.loggedInputStream.interrupt();
            this.loggedInputStream = null;
        }
        this.parent.setVisible(false);
        this.statusPanel.interrupt();
        this.statusPanel.getProgressBar().stopAnimation();
        this.statusPanel.setText("");
        this.statusPanel.getProgressBar().setStringPainted(false);
        this.statusPanel.getProgressBar().setValue(0);
    }

    public static ProgressPanel makeProgressPanel(final String title, final Component window) {
        if (!SwingUtilities.isEventDispatchThread()) {
            ProgressPanel.invokeAndWait(new Runnable(){

                public void run() {
                    newPanel = ProgressPanel.makeProgressPanel(title, window);
                }
            });
            return newPanel;
        }
        Frame parent = null;
        JDesktopPane desktop = DialogUtil.getDesktop();
        parent = desktop != null ? SwingUtil.getFrame(desktop) : SwingUtil.getFrame(window);
        ProgressPanelDialog f = new ProgressPanelDialog(title, parent);
        f.show();
        return f.getProgressPanel();
    }

    public static ProgressPanel makeProgressPanel(String title) {
        return ProgressPanel.makeProgressPanel(title, null);
    }

    public static ProgressPanel makeProgressPanel() {
        return ProgressPanel.makeProgressPanel("Downloading data...");
    }

    public void setProgress(final int percent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressPanel.this.statusPanel.setProgress(percent);
                }
            });
            return;
        }
        this.statusPanel.setProgress(percent);
    }

    public ProgressBarFilterInputStream getLoggedInputStream(InputStream in, int size) throws IOException {
        if (this.interrupted) {
            throw new ProgressException("Interrupted");
        }
        this.loggedInputStream = this.statusPanel.getLoggedInputStream(in, size);
        return this.loggedInputStream;
    }

    public ProgressBarFilterInputStream getLoggedInputStream(URL url) throws IOException {
        if (this.interrupted) {
            throw new ProgressException("Interrupted");
        }
        this.loggedInputStream = this.statusPanel.getLoggedInputStream(url);
        return this.loggedInputStream;
    }

    public void stopLoggingInputStream(ProgressBarFilterInputStream in) throws IOException {
        this.loggedInputStream = null;
        this.statusPanel.stopLoggingInputStream(in);
    }
}

