/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jsky.science.Coordinates;
import jsky.science.CoordinatesOffset;
import jsky.science.ProperMotion;
import jsky.util.FormatUtilities;
import jsky.util.ReplaceablePropertyChangeListener;
import jsky.util.ReplacementEvent;
import jsky.util.gui.CoordinatesOffsetPanel;

public class ProperMotionPanel
extends JComponent
implements ReplaceablePropertyChangeListener {
    private CoordinatesOffsetPanel fPanelOffset;
    private JLabel fRaPmLabel;
    private JLabel fDecPmLabel;
    private JLabel fRaPmUnits;
    private JLabel fDecPmUnits;
    private JTextField fRaPmField;
    private JTextField fDecPmField;
    protected int fOrientation;
    protected static final String RAPROPERMOTION_PROPERTY = "RAProperMotion".intern();
    protected static final String DECPROPERMOTION_PROPERTY = "DECProperMotion".intern();
    public static final String PROPERMOTION_PROPERTY = "ProperMotion".intern();
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    public static final String ORIENTATION_PROPERTY = "Orientation".intern();
    private ProperMotion fMotion;
    GridBagConstraints constraint = new GridBagConstraints();

    public ProperMotionPanel() {
        this.setLayout(new GridBagLayout());
        this.fMotion = new ProperMotion();
        this.fPanelOffset = new CoordinatesOffsetPanel();
        this.fRaPmLabel = new JLabel("+/-");
        this.fRaPmField = new JTextField(5);
        this.fRaPmUnits = new JLabel("/yr");
        this.fDecPmLabel = new JLabel("+/-");
        this.fDecPmField = new JTextField(5);
        this.fDecPmUnits = new JLabel("/yr");
        this.add(this.fPanelOffset);
        this.add(this.fRaPmLabel);
        this.add(this.fRaPmField);
        this.add(this.fRaPmUnits);
        this.add(this.fDecPmLabel);
        this.add(this.fDecPmField);
        this.add(this.fDecPmUnits);
        String tooltip = "Errors should formatted, +/-##.##, units are arcsec/yr";
        this.fRaPmField.setToolTipText(tooltip);
        this.fDecPmField.setToolTipText(tooltip);
        this.setProperMotion(new ProperMotion());
        this.setOrientation(0);
        this.fPanelOffset.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ProperMotionPanel.this.fMotion != null && event.getPropertyName().equals(CoordinatesOffsetPanel.COORDINATES_OFFSET_PROPERTY)) {
                    ProperMotionPanel.this.fMotion.setOffset((CoordinatesOffset)event.getNewValue());
                }
            }
        });
        this.fRaPmField.setActionCommand(RAPROPERMOTION_PROPERTY);
        this.fRaPmField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ProperMotionPanel.this.fMotion != null) {
                    double rapm = 0.0;
                    try {
                        rapm = Coordinates.convert(new Double(ProperMotionPanel.this.fRaPmField.getText()), Coordinates.ARCSEC, Coordinates.DEGREE);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ProperMotionPanel.this.fMotion.setRaError(rapm);
                }
            }
        });
        this.fDecPmField.setActionCommand(DECPROPERMOTION_PROPERTY);
        this.fDecPmField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ProperMotionPanel.this.fMotion != null) {
                    double Decpm = 0.0;
                    try {
                        Decpm = Coordinates.convert(new Double(ProperMotionPanel.this.fDecPmField.getText()), Coordinates.ARCSEC, Coordinates.DEGREE);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ProperMotionPanel.this.fMotion.setDecError(Decpm);
                }
            }
        });
    }

    public ProperMotion getProperMotion() {
        return this.fMotion;
    }

    public void setProperMotion(ProperMotion pm) {
        if (this.fMotion != null) {
            this.fMotion.removePropertyChangeListener(this);
        }
        this.fMotion = pm;
        if (this.fMotion != null) {
            this.fMotion.addPropertyChangeListener(this);
        }
        this.updateFields();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFields();
    }

    public void replaceObject(ReplacementEvent event) {
        this.setProperMotion((ProperMotion)event.getNewValue());
    }

    private void updateFields() {
        if (this.fMotion != null) {
            this.fPanelOffset.setCoordinatesOffset(this.fMotion.getOffset());
            this.fRaPmField.setText(FormatUtilities.formatDouble(Coordinates.convert(this.fMotion.getRaError(), Coordinates.DEGREE, Coordinates.ARCSEC), 2));
            this.fDecPmField.setText(FormatUtilities.formatDouble(Coordinates.convert(this.fMotion.getDecError(), Coordinates.DEGREE, Coordinates.ARCSEC), 2));
        } else {
            this.fPanelOffset.setCoordinatesOffset(null);
            this.fRaPmField.setText("");
            this.fDecPmField.setText("");
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.fPanelOffset.setReadOnly(readOnly);
        this.fRaPmField.setEnabled(!readOnly);
        this.fDecPmField.setEnabled(!readOnly);
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    private void setConstraints(JComponent comp, int x, int y, int w, int h, int a) {
        this.constraint.weightx = 1.0;
        this.constraint.insets = new Insets(2, 2, 2, 2);
        this.constraint.gridx = x;
        this.constraint.gridy = y;
        this.constraint.gridheight = h;
        this.constraint.gridwidth = w;
        this.constraint.anchor = a;
        ((GridBagLayout)this.getLayout()).setConstraints(comp, this.constraint);
    }

    public void setOrientation(int orient) {
        if (this.fRaPmUnits == null) {
            return;
        }
        this.firePropertyChange(ORIENTATION_PROPERTY, this.fOrientation, orient);
        this.fOrientation = orient;
        this.fPanelOffset.setOrientation(this.fOrientation);
        if (this.fOrientation == 1) {
            this.setConstraints(this.fPanelOffset, 0, 0, 1, 2, 17);
            this.setConstraints(this.fRaPmLabel, 1, 0, 1, 1, 13);
            this.setConstraints(this.fRaPmField, 2, 0, 1, 1, 17);
            this.setConstraints(this.fRaPmUnits, 3, 0, 1, 1, 17);
            this.fDecPmLabel.setText(this.fRaPmLabel.getText());
            this.fRaPmUnits.setVisible(true);
            this.setConstraints(this.fDecPmLabel, 1, 1, 1, 1, 13);
            this.setConstraints(this.fDecPmField, 2, 1, 1, 1, 17);
            this.setConstraints(this.fDecPmUnits, 3, 1, 1, 1, 17);
        } else {
            this.setConstraints(this.fPanelOffset, 0, 0, 1, 1, 17);
            this.setConstraints(this.fRaPmLabel, 1, 0, 1, 1, 17);
            this.setConstraints(this.fRaPmField, 2, 0, 1, 1, 17);
            this.setConstraints(this.fRaPmUnits, 3, 0, 1, 1, 17);
            this.fRaPmUnits.setVisible(false);
            this.fDecPmLabel.setText(", ");
            this.setConstraints(this.fDecPmLabel, 4, 0, 1, 1, 17);
            this.setConstraints(this.fDecPmField, 5, 0, 1, 1, 17);
            this.setConstraints(this.fDecPmUnits, 6, 0, 1, 1, 17);
        }
    }

    public static void main(String[] args) {
        ProperMotion offset = new ProperMotion(5.0, 5.0, Coordinates.ARCSEC);
        ProperMotionPanel panel = new ProperMotionPanel();
        panel.setProperMotion(offset);
        panel.setOrientation(0);
        JOptionPane.showConfirmDialog(null, panel);
    }
}

