/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableUtil {
    public static TableCellRenderer getDefaultRenderer(JTable table, TableColumn column) {
        try {
            return table.getTableHeader().getDefaultRenderer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int initColumnSizes(JTable table, boolean[] show) {
        TableColumn column = null;
        Component comp = null;
        int cellWidth = 0;
        TableModel model = table.getModel();
        int numCols = model.getColumnCount();
        int numRows = model.getRowCount();
        if (show != null && show.length != numCols) {
            show = null;
        }
        int sumColWidths = 0;
        for (int col = 0; col < numCols; ++col) {
            column = table.getColumnModel().getColumn(col);
            if (show == null || show[col]) {
                TableCellRenderer headerRenderer;
                TableCellRenderer defaultRenderer = TableUtil.getDefaultRenderer(table, column);
                TableCellRenderer cellRenderer = column.getCellRenderer();
                if (cellRenderer == null) {
                    cellRenderer = defaultRenderer;
                }
                if ((headerRenderer = column.getHeaderRenderer()) == null) {
                    headerRenderer = defaultRenderer;
                }
                comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, col);
                cellWidth = comp.getPreferredSize().width;
                for (int row = 0; row < numRows; ++row) {
                    Object o = model.getValueAt(row, col);
                    comp = cellRenderer.getTableCellRendererComponent(table, o, false, false, row, col);
                    cellWidth = Math.max(cellWidth, comp.getPreferredSize().width);
                }
                sumColWidths += (cellWidth += 10);
                column.setPreferredWidth(cellWidth);
                column.setMinWidth(5);
                column.setMaxWidth(1000);
                continue;
            }
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setPreferredWidth(0);
        }
        return sumColWidths;
    }

    public static int getWidestRow(TableModel model, int col) {
        int widestRow = 0;
        int maxLength = 0;
        int numRows = model.getRowCount();
        for (int row = 0; row < numRows; ++row) {
            String s;
            int length;
            Object o = model.getValueAt(row, col);
            if (o == null || (length = (s = o.toString()).length()) <= maxLength) continue;
            maxLength = length;
            widestRow = row;
        }
        return widestRow;
    }
}

