/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.symmlet8;

import JSci.maths.wavelet.FWT;

public final class FastSymmlet8
extends FWT {
    static final float[] scale = new float[]{0.0322231f, -0.012603967f, -0.099219546f, 0.2978578f, 0.8037388f, 0.49761868f, -0.029635528f, -0.075765714f};
    static final float[] wavelet = new float[]{-scale[7], scale[6], -scale[5], scale[4], -scale[3], scale[2], -scale[1], scale[0]};

    public static void transform(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int n2 = n / 2;
        try {
            int n3 = 0;
            while (true) {
                fArray2[n3 + n2] = fArray[2 * n3 + 0] * wavelet[0] + fArray[2 * n3 + 1] * wavelet[1] + fArray[2 * n3 + 2] * wavelet[2] + fArray[2 * n3 + 3] * wavelet[3] + fArray[2 * n3 + 4] * wavelet[4] + fArray[2 * n3 + 5] * wavelet[5] + fArray[2 * n3 + 6] * wavelet[6] + fArray[2 * n3 + 7] * wavelet[7];
                fArray2[n3] = fArray[2 * n3 + 0] * scale[0] + fArray[2 * n3 + 1] * scale[1] + fArray[2 * n3 + 2] * scale[2] + fArray[2 * n3 + 3] * scale[3] + fArray[2 * n3 + 4] * scale[4] + fArray[2 * n3 + 5] * scale[5] + fArray[2 * n3 + 6] * scale[6] + fArray[2 * n3 + 7] * scale[7];
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            fArray2[n - 3] = fArray[n - 6] * wavelet[0] + fArray[n - 5] * wavelet[1] + fArray[n - 4] * wavelet[2] + fArray[n - 3] * wavelet[3] + fArray[n - 2] * wavelet[4] + fArray[n - 1] * wavelet[5] + fArray[0] * wavelet[6] + fArray[1] * wavelet[7];
            fArray2[n2 - 3] = fArray[n - 6] * scale[0] + fArray[n - 5] * scale[1] + fArray[n - 4] * scale[2] + fArray[n - 3] * scale[3] + fArray[n - 2] * scale[4] + fArray[n - 1] * scale[5] + fArray[0] * scale[6] + fArray[1] * scale[7];
            fArray2[n - 2] = fArray[n - 4] * wavelet[0] + fArray[n - 3] * wavelet[1] + fArray[n - 2] * wavelet[2] + fArray[n - 1] * wavelet[3] + fArray[0] * wavelet[4] + fArray[1] * wavelet[5] + fArray[2] * wavelet[6] + fArray[3] * wavelet[7];
            fArray2[n2 - 2] = fArray[n - 4] * scale[0] + fArray[n - 3] * scale[1] + fArray[n - 2] * scale[2] + fArray[n - 1] * scale[3] + fArray[0] * scale[4] + fArray[1] * scale[5] + fArray[2] * scale[6] + fArray[3] * scale[7];
            fArray2[n - 1] = fArray[n - 2] * wavelet[0] + fArray[n - 1] * wavelet[1] + fArray[0] * wavelet[2] + fArray[1] * wavelet[3] + fArray[2] * wavelet[4] + fArray[3] * wavelet[5] + fArray[4] * wavelet[6] + fArray[5] * wavelet[7];
            fArray2[n2 - 1] = fArray[n - 2] * scale[0] + fArray[n - 1] * scale[1] + fArray[0] * scale[2] + fArray[1] * scale[3] + fArray[2] * scale[4] + fArray[3] * scale[5] + fArray[4] * scale[6] + fArray[5] * scale[7];
            System.arraycopy(fArray2, 0, fArray, 0, n);
            return;
        }
    }

    public void transform(float[] fArray) {
        int n = fArray.length;
        while (n > 8) {
            FastSymmlet8.transform(fArray, n);
            n /= 2;
        }
        if (n != 8) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    public void invTransform(float[] fArray) {
        int n = 8;
        while (2 * n <= fArray.length) {
            FastSymmlet8.invTransform(fArray, n);
            n *= 2;
        }
        if (n != fArray.length) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    public static void invTransform(float[] fArray, int n) {
        int n2 = 2 * n;
        float[] fArray2 = new float[n2];
        try {
            int n3 = 0;
            while (true) {
                int n4 = 2 * n3 + 7;
                fArray2[n4] = fArray2[n4] + (scale[7] * fArray[n3] + wavelet[7] * fArray[n3 + n]);
                int n5 = 2 * n3 + 6;
                fArray2[n5] = fArray2[n5] + (scale[6] * fArray[n3] + wavelet[6] * fArray[n3 + n]);
                int n6 = 2 * n3 + 5;
                fArray2[n6] = fArray2[n6] + (scale[5] * fArray[n3] + wavelet[5] * fArray[n3 + n]);
                int n7 = 2 * n3 + 4;
                fArray2[n7] = fArray2[n7] + (scale[4] * fArray[n3] + wavelet[4] * fArray[n3 + n]);
                int n8 = 2 * n3 + 3;
                fArray2[n8] = fArray2[n8] + (scale[3] * fArray[n3] + wavelet[3] * fArray[n3 + n]);
                int n9 = 2 * n3 + 2;
                fArray2[n9] = fArray2[n9] + (scale[2] * fArray[n3] + wavelet[2] * fArray[n3 + n]);
                int n10 = 2 * n3 + 1;
                fArray2[n10] = fArray2[n10] + (scale[1] * fArray[n3] + wavelet[1] * fArray[n3 + n]);
                int n11 = 2 * n3 + 0;
                fArray2[n11] = fArray2[n11] + (scale[0] * fArray[n3] + wavelet[0] * fArray[n3 + n]);
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n12 = n2 - 6;
            fArray2[n12] = fArray2[n12] + (scale[0] * fArray[n - 3] + wavelet[0] * fArray[n2 - 3]);
            int n13 = n2 - 5;
            fArray2[n13] = fArray2[n13] + (scale[1] * fArray[n - 3] + wavelet[1] * fArray[n2 - 3]);
            int n14 = n2 - 4;
            fArray2[n14] = fArray2[n14] + (scale[2] * fArray[n - 3] + wavelet[2] * fArray[n2 - 3]);
            int n15 = n2 - 3;
            fArray2[n15] = fArray2[n15] + (scale[3] * fArray[n - 3] + wavelet[3] * fArray[n2 - 3]);
            int n16 = n2 - 2;
            fArray2[n16] = fArray2[n16] + (scale[4] * fArray[n - 3] + wavelet[4] * fArray[n2 - 3]);
            int n17 = n2 - 1;
            fArray2[n17] = fArray2[n17] + (scale[5] * fArray[n - 3] + wavelet[5] * fArray[n2 - 3]);
            fArray2[0] = fArray2[0] + (scale[6] * fArray[n - 3] + wavelet[6] * fArray[n2 - 3]);
            fArray2[1] = fArray2[1] + (scale[7] * fArray[n - 3] + wavelet[7] * fArray[n2 - 3]);
            int n18 = n2 - 4;
            fArray2[n18] = fArray2[n18] + (scale[0] * fArray[n - 2] + wavelet[0] * fArray[n2 - 2]);
            int n19 = n2 - 3;
            fArray2[n19] = fArray2[n19] + (scale[1] * fArray[n - 2] + wavelet[1] * fArray[n2 - 2]);
            int n20 = n2 - 2;
            fArray2[n20] = fArray2[n20] + (scale[2] * fArray[n - 2] + wavelet[2] * fArray[n2 - 2]);
            int n21 = n2 - 1;
            fArray2[n21] = fArray2[n21] + (scale[3] * fArray[n - 2] + wavelet[3] * fArray[n2 - 2]);
            fArray2[0] = fArray2[0] + (scale[4] * fArray[n - 2] + wavelet[4] * fArray[n2 - 2]);
            fArray2[1] = fArray2[1] + (scale[5] * fArray[n - 2] + wavelet[5] * fArray[n2 - 2]);
            fArray2[2] = fArray2[2] + (scale[6] * fArray[n - 2] + wavelet[6] * fArray[n2 - 2]);
            fArray2[3] = fArray2[3] + (scale[7] * fArray[n - 2] + wavelet[7] * fArray[n2 - 2]);
            int n22 = n2 - 2;
            fArray2[n22] = fArray2[n22] + (scale[0] * fArray[n - 1] + wavelet[0] * fArray[n2 - 1]);
            int n23 = n2 - 1;
            fArray2[n23] = fArray2[n23] + (scale[1] * fArray[n - 1] + wavelet[1] * fArray[n2 - 1]);
            fArray2[0] = fArray2[0] + (scale[2] * fArray[n - 1] + wavelet[2] * fArray[n2 - 1]);
            fArray2[1] = fArray2[1] + (scale[3] * fArray[n - 1] + wavelet[3] * fArray[n2 - 1]);
            fArray2[2] = fArray2[2] + (scale[4] * fArray[n - 1] + wavelet[4] * fArray[n2 - 1]);
            fArray2[3] = fArray2[3] + (scale[5] * fArray[n - 1] + wavelet[5] * fArray[n2 - 1]);
            fArray2[4] = fArray2[4] + (scale[6] * fArray[n - 1] + wavelet[6] * fArray[n2 - 1]);
            fArray2[5] = fArray2[5] + (scale[7] * fArray[n - 1] + wavelet[7] * fArray[n2 - 1]);
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            return;
        }
    }
}

