/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class PreferencesTask
extends Task {
    String type = null;
    String path = null;
    Preferences rootPrefs = null;
    ArrayList actions = new ArrayList();

    public Int createInt() {
        Int r = new Int();
        this.actions.add(r);
        return r;
    }

    public _String createString() {
        _String r = new _String();
        this.actions.add(r);
        return r;
    }

    public Test createTest() {
        Test r = new Test();
        this.actions.add(r);
        return r;
    }

    public Import createImport() {
        Import r = new Import();
        this.actions.add(r);
        return r;
    }

    public Export createExport() {
        Export r = new Export();
        this.actions.add(r);
        return r;
    }

    public Get createGet() {
        Get r = new Get();
        this.actions.add(r);
        return r;
    }

    public Remove createRemove() {
        Remove r = new Remove();
        this.actions.add(r);
        return r;
    }

    public Long createLong() {
        Long r = new Long();
        this.actions.add(r);
        return r;
    }

    public Bool createBoolean() {
        Bool r = new Bool();
        this.actions.add(r);
        return r;
    }

    public Float createFloat() {
        Float r = new Float();
        this.actions.add(r);
        return r;
    }

    public Double createDouble() {
        Double r = new Double();
        this.actions.add(r);
        return r;
    }

    public ByteArray createByteArray() {
        ByteArray r = new ByteArray();
        this.actions.add(r);
        return r;
    }

    public void execute() throws BuildException {
        if ("system".equals(this.type)) {
            this.rootPrefs = Preferences.systemRoot();
        } else if ("user".equals(this.type)) {
            this.rootPrefs = Preferences.userRoot();
        } else {
            throw new BuildException("Attribute type is required (must be \"user\" oder \"system\")");
        }
        if (this.path != null) {
            this.rootPrefs = this.rootPrefs.node(this.path);
        }
        if (this.actions.size() == 0) {
            this.log("No action(s) applied to task preferences.", 1);
        }
        Iterator iter = this.actions.iterator();
        while (iter.hasNext()) {
            Runnable r = (Runnable)iter.next();
            r.run();
        }
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public class Test
    implements Runnable {
        String node = null;
        String name = null;
        String path = null;
        String value = null;
        String property = null;

        public void setName(String string) {
            this.name = string;
        }

        public void setNode(String string) {
            this.node = string;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public void run() {
            if (this.name != null && this.node != null || this.name == null && this.node == null) {
                throw new BuildException("Attribute name OR node is required in element test");
            }
            if (this.property == null) {
                throw new BuildException("Attribute property is required in element test");
            }
            if (this.node != null && this.value != null) {
                throw new BuildException("Using attribute value in conjunction  with attribute node doesnt make sense.");
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            try {
                if (this.path != null && p.nodeExists(this.path)) {
                    p = p.node(this.path);
                }
                if (this.name != null) {
                    List<String> list = Arrays.asList(p.keys());
                    if (list.contains(this.name) && (this.value == null || p.get(this.name, "").equals(this.value))) {
                        PreferencesTask.this.getProject().setProperty(this.property, "true");
                    }
                } else if (p.nodeExists(this.node)) {
                    PreferencesTask.this.getProject().setProperty(this.property, "true");
                }
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element get", ex);
            }
        }
    }

    public class Remove
    implements Runnable {
        String node = null;
        String name = null;
        String path = null;

        public void setName(String string) {
            this.name = string;
        }

        public void setNode(String string) {
            this.node = string;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public void run() {
            if (this.name != null && this.node != null || this.name == null && this.node == null) {
                throw new BuildException("Attribute name OR node is required in element test");
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            try {
                if (this.path != null && p.nodeExists(this.path)) {
                    p = p.node(this.path);
                }
                if (this.name != null) {
                    List<String> list = Arrays.asList(p.keys());
                    if (list.contains(this.name)) {
                        p.remove(this.name);
                    } else {
                        PreferencesTask.this.log("remove : a key " + this.name + " doesnt exist within preference " + p, 2);
                    }
                } else if (p.nodeExists(this.node)) {
                    p.node(this.node).removeNode();
                } else {
                    PreferencesTask.this.log("remove : a node " + this.node + " doesnt exist within preference " + p, 2);
                }
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Cannot access preferences from element remove", ex);
            }
        }
    }

    public class Get
    implements Runnable {
        String name = null;
        String path = null;
        String defaultValue = null;
        String property = null;

        public void run() {
            if (this.name == null) {
                throw new BuildException("Attribute name is required in element get");
            }
            if (this.property == null) {
                throw new BuildException("Attribute property is required in element get");
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            try {
                List<String> list;
                if (this.path != null) {
                    if (p.nodeExists(this.path)) {
                        p = p.node(this.path);
                    } else {
                        throw new BuildException("subtree " + this.path + " does not exist within preferences " + p);
                    }
                }
                if ((list = Arrays.asList(p.keys())).contains(this.name)) {
                    PreferencesTask.this.getProject().setProperty(this.property, p.get(this.name, this.defaultValue));
                } else if (this.defaultValue != null) {
                    PreferencesTask.this.getProject().setProperty(this.property, this.defaultValue);
                }
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element get", ex);
            }
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getProperty() {
            return this.property;
        }

        public void setDefaultValue(String string) {
            this.defaultValue = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public void setProperty(String string) {
            this.property = string;
        }
    }

    public class ByteArray
    extends Action {
        String separator = ", ";
        int radix = 10;

        public void execute(Preferences p) {
            StringTokenizer st = new StringTokenizer(this.value, this.separator);
            byte[] array = new byte[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    array[i++] = Byte.parseByte(token, this.radix);
                }
                catch (NumberFormatException e) {
                    throw new BuildException(this.getSubTaskName() + " : Cannot parse byte element " + token + " at positition " + i + " as byte.");
                }
            }
            try {
                p.putByteArray(this.name, array);
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String string) {
            this.separator = string;
        }

        public int getRadix() {
            return this.radix;
        }

        public void setRadix(int i) {
            this.radix = i;
        }
    }

    public class Double
    extends Action {
        public void execute(Preferences p) {
            try {
                double i = java.lang.Double.valueOf(this.value);
                p.putDouble(this.name, i);
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (NumberFormatException e) {
                throw new BuildException(this.getSubTaskName() + " : " + this.value + "Value is not parsable as double");
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public class Float
    extends Action {
        public void execute(Preferences p) {
            try {
                float i = java.lang.Float.valueOf(this.value).floatValue();
                p.putDouble(this.name, i);
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (NumberFormatException e) {
                throw new BuildException(this.getSubTaskName() + " : " + this.value + "Value is not parsable as float");
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public class Bool
    extends Action {
        public void execute(Preferences p) {
            this.value = this.value.toLowerCase().trim();
            if (!this.value.equals("true") && !this.value.equals("false")) {
                throw new BuildException("Attribute value must be either true or false for " + this.getSubTaskName());
            }
            try {
                p.putBoolean(this.name, this.value.equals("true"));
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public class Long
    extends Action {
        public void execute(Preferences p) {
            try {
                long i = java.lang.Long.valueOf(this.value);
                p.putLong(this.name, i);
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (NumberFormatException e) {
                throw new BuildException(this.getSubTaskName() + " : " + this.value + "Value is not parsable as long");
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public class Export
    implements Runnable {
        File file = null;
        boolean noSubElements = false;
        String path = null;

        public void run() {
            if (this.file == null) {
                throw new BuildException("Attribute file ist required in element export");
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            try {
                if (this.path != null) {
                    if (p.nodeExists(this.path)) {
                        p = p.node(this.path);
                    } else {
                        throw new BuildException("Export failed : node " + this.path + " doesnt exist within " + p);
                    }
                }
                PreferencesTask.this.log("export preferences tree " + p + " to " + this.file.getAbsolutePath(), 2);
                if (this.noSubElements) {
                    p.exportNode(new FileOutputStream(this.file));
                } else {
                    p.exportSubtree(new FileOutputStream(this.file));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Error executing element export", ex);
            }
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public void setNoSubElements(boolean b) {
            this.noSubElements = b;
        }
    }

    public class Import
    implements Runnable {
        File file = null;
        ArrayList fileSets = new ArrayList();

        public void addFileSet(FileSet fileSet) {
            this.fileSets.add(fileSet);
        }

        public void run() {
            if (this.file == null && this.fileSets.size() == 0 || this.file != null && this.fileSets.size() > 0) {
                throw new BuildException("Either attribute file or child fileset(s) are required in element import");
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            try {
                if (this.file != null) {
                    PreferencesTask.this.log("import preferences from " + this.file.getAbsolutePath(), 2);
                    Preferences.importPreferences(new FileInputStream(this.file));
                } else {
                    for (int i = 0; i < this.fileSets.size(); ++i) {
                        FileSet fileSet = (FileSet)this.fileSets.get(i);
                        DirectoryScanner directoryscanner = fileSet.getDirectoryScanner(PreferencesTask.this.getProject());
                        String[] files = directoryscanner.getIncludedFiles();
                        for (int j = 0; j < files.length; ++j) {
                            String string = files[j];
                            PreferencesTask.this.log("import preferences from " + string, 2);
                            Preferences.importPreferences(new FileInputStream(new File(directoryscanner.getBasedir(), string)));
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Cannot access preferences from element remove", ex);
            }
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    public class _String
    extends Action {
        public void execute(Preferences p) {
            p.put(this.name, this.value);
            try {
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public class Int
    extends Action {
        public void execute(Preferences p) {
            try {
                int i = Integer.parseInt(this.value);
                p.putInt(this.name, i);
                PreferencesTask.this.rootPrefs.sync();
            }
            catch (NumberFormatException e) {
                throw new BuildException(this.getSubTaskName() + " : " + this.value + "Value is not parable as integer");
            }
            catch (BackingStoreException ex) {
                throw new BuildException("Cannot access preferences from element " + this.getSubTaskName(), ex);
            }
        }
    }

    public abstract class Action
    implements Runnable {
        String name = null;
        String value = null;
        String path = null;

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public void addText(String s) {
            if (this.value == null && s.trim().length() > 0) {
                this.value = s.trim();
            }
        }

        public void run() {
            if (this.name == null) {
                throw new BuildException("Attribute name is required in element " + this.getSubTaskName());
            }
            if (this.value == null) {
                throw new BuildException("Attribute value is required in element " + this.getSubTaskName());
            }
            Preferences p = PreferencesTask.this.rootPrefs;
            if (this.path != null) {
                p = p.node(this.path);
            }
            this.execute(p);
        }

        String getSubTaskName() {
            String s = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(36) + 1).toLowerCase();
            return s.startsWith("_") ? s.substring(1) : s;
        }

        public abstract void execute(Preferences var1);
    }
}

