/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private InputStream is;
    private OutputStream os;
    private volatile boolean finish;
    private volatile boolean finished;
    private boolean closeWhenExhausted;
    private boolean autoflush = false;
    private Exception exception = null;
    private int bufferSize = 128;
    private boolean started = false;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this.is = is;
        this.os = os;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block24: {
            int length;
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.started = true;
            }
            this.finished = false;
            this.finish = false;
            byte[] buf = new byte[this.bufferSize];
            while ((length = this.is.read(buf)) > 0 && !this.finish) {
                this.os.write(buf, 0, length);
                if (!this.autoflush) continue;
                this.os.flush();
            }
            this.os.flush();
            Object var7_4 = null;
            if (!this.closeWhenExhausted) break block24;
            try {
                this.os.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        this.finished = true;
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.notifyAll();
        }
        {
            catch (Exception e) {
                StreamPumper streamPumper2 = this;
                synchronized (streamPumper2) {
                    this.exception = e;
                }
                Object var7_5 = null;
                if (this.closeWhenExhausted) {
                    try {
                        this.os.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                this.finished = true;
                StreamPumper streamPumper3 = this;
                synchronized (streamPumper3) {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            this.finished = true;
            StreamPumper streamPumper4 = this;
            synchronized (streamPumper4) {
                this.notifyAll();
            }
            throw throwable;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    synchronized void stop() {
        this.finish = true;
        this.notifyAll();
    }
}

