/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileList;

public class ListDelete
extends Delete {
    protected FileList filelist = null;

    public void addFilelist(FileList filelist) {
        this.filelist = filelist;
    }

    public void execute() throws BuildException {
        if (this.filelist != null) {
            String[] files = this.filelist.getFiles(this.project);
            for (int i = 0; i < files.length; ++i) {
                File file = new File(files[i]);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        this.removeDir(file);
                        continue;
                    }
                    this.log("Deleting: " + file.getAbsolutePath(), 3);
                    if (file.delete()) continue;
                    String message = "Unable to delete file " + file.getAbsolutePath();
                    if (this.isFailOnError()) {
                        throw new BuildException(message);
                    }
                    this.log(message, this.isQuiet() ? 3 : 1);
                    continue;
                }
                this.log("Could not find file " + file.getAbsolutePath() + " to delete.", 3);
            }
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0 && this.filelist != null) {
            return;
        }
        super.execute();
    }
}

