/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ant.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class LoggedCopy
extends Copy {
    protected File logfile = null;
    protected boolean logfileAppend = false;
    protected BufferedWriter logfileWriter = null;

    public void setLogfile(File logfile) {
        if (!logfile.isDirectory()) {
            this.logfile = logfile;
        } else {
            logfile = null;
        }
    }

    public void setLogfileAppend(boolean logfileAppend) {
        this.logfileAppend = logfileAppend;
    }

    protected void addToLogfile(String filename) {
        if (this.logfile != null) {
            if (this.logfileWriter == null) {
                try {
                    FileOutputStream f = new FileOutputStream(this.logfile, this.logfileAppend);
                    this.logfileWriter = new BufferedWriter(new OutputStreamWriter(f));
                }
                catch (FileNotFoundException e) {
                    this.logfile = null;
                    this.log(e.getMessage());
                }
            }
            try {
                this.logfileWriter.write(filename + "\n");
            }
            catch (IOException e) {
                this.log(e.getMessage());
            }
        }
    }

    protected void doFileOperations() {
        int i;
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-copy of " + fromFile, this.verbosity);
                        this.addToLogfile(toFile);
                        continue;
                    }
                    try {
                        this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.getFilterSets().elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.preserveLastModified, this.getEncoding(), this.getOutputEncoding(), this.getProject());
                        this.addToLogfile(toFile);
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new BuildException(msg, ioe, this.getLocation());
                    }
                }
            }
            if (this.logfileWriter != null) {
                try {
                    this.logfileWriter.close();
                    this.logfileWriter = null;
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs = (String[])e.nextElement();
                for (i = 0; i < dirs.length; ++i) {
                    File d = new File(dirs[i]);
                    if (d.exists()) continue;
                    if (!d.mkdirs()) {
                        this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
            }
            if (createCount > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }
}

