/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.util.IOUtils;

public abstract class AbstractFitsTableWriter
extends StreamStarTableWriter {
    private String formatName_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    protected AbstractFitsTableWriter(String formatName) {
        this.setFormatName(formatName);
    }

    public String getFormatName() {
        return this.formatName_;
    }

    public void setFormatName(String formatName) {
        this.formatName_ = formatName;
    }

    public String getMimeType() {
        return "application/fits";
    }

    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        DataOutputStream ostrm = new DataOutputStream(out);
        FitsTableSerializer serializer = this.createSerializer(table);
        this.writePrimaryHDU(table, serializer, ostrm);
        this.writeTableHDU(table, serializer, ostrm);
        ostrm.flush();
    }

    public abstract void writePrimaryHDU(StarTable var1, FitsTableSerializer var2, DataOutput var3) throws IOException;

    public void writeTableHDU(StarTable table, FitsTableSerializer fitser, DataOutput out) throws IOException {
        try {
            Header hdr = fitser.getHeader();
            this.addMetadata(hdr);
            FitsConstants.writeHeader(out, hdr);
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        fitser.writeData(out);
    }

    protected abstract FitsTableSerializer createSerializer(StarTable var1) throws IOException;

    protected void addMetadata(Header hdr) {
        try {
            hdr.addValue("DATE-HDU", AbstractFitsTableWriter.getCurrentDate(), "Date of HDU creation (UTC)");
            hdr.addValue("STILVERS", IOUtils.getResourceContents((Class)StarTable.class, (String)"stil.version"), "Version of STIL software");
            hdr.addValue("STILCLAS", ((Object)((Object)this)).getClass().getName(), "Author class in STIL software");
        }
        catch (HeaderCardException e) {
            logger_.warning("Trouble adding metadata header cards " + e);
        }
    }

    public static String getCurrentDate() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        fmt.setTimeZone(utc);
        fmt.setCalendar(new GregorianCalendar(utc, Locale.UK));
        return fmt.format(new Date());
    }
}

