/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Logger;
import nom.tam.fits.Header;
import uk.ac.starlink.fits.HeaderCards;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.Loader;

public class ColFitsStarTable
extends ColumnStarTable {
    private final long nrow_;
    private static long mappedBytes_;
    private static boolean mapWarned_;
    private static final Logger logger_;
    private static final int MAX_SECTION_BYTES = Integer.MAX_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColFitsStarTable(File file, Header hdr, long dataPos) throws IOException {
        HeaderCards cards = new HeaderCards(hdr);
        if (!cards.getStringValue("XTENSION").equals("BINTABLE")) {
            throw new TableFormatException("HDU 1 not BINTABLE");
        }
        if (cards.getIntValue("NAXIS2") != 1) {
            throw new TableFormatException("Doesn't have exactly one row");
        }
        int ncol = cards.getIntValue("TFIELDS");
        long nrow = 0L;
        ColumnInfo[] infos = new ColumnInfo[ncol];
        char[] formatChars = new char[ncol];
        int[][] itemShapes = new int[ncol][];
        Long[] blanks = new Long[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            String tutype;
            String tucd;
            String tcomm;
            String tunit;
            Long blank;
            long nitem;
            int jcol = icol + 1;
            ColumnInfo cinfo = new ColumnInfo("col" + jcol);
            String tform = cards.getStringValue("TFORM" + jcol).trim();
            int formatChar = tform.charAt(tform.length() - 1);
            if (formatChar == 66 && cards.containsKey("TZERO" + jcol) && cards.getDoubleValue("TZERO" + jcol) == -128.0 && (!cards.containsKey("TSCALE" + jcol) || cards.getDoubleValue("TSCALE" + jcol) == 1.0)) {
                formatChar = 98;
            }
            try {
                nitem = Long.parseLong(tform.substring(0, tform.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new TableFormatException("Bad TFORM " + tform);
            }
            formatChars[icol] = formatChar;
            String tdims = cards.getStringValue("TDIM" + jcol);
            long[] dims = ColFitsStarTable.parseTdim(tdims);
            if (dims == null) {
                throw new TableFormatException("Bad TDIM value " + tdims);
            }
            if (ColFitsStarTable.multiply(dims) != nitem) {
                throw new TableFormatException("TDIM doesn't match TFORM");
            }
            int[] itemShape = new int[dims.length - 1];
            for (int i = 0; i < dims.length - 1; ++i) {
                itemShape[i] = Tables.checkedLongToInt((long)dims[i]);
            }
            long nr = dims[dims.length - 1];
            if (icol == 0) {
                nrow = nr;
            } else if (nr != nrow) {
                throw new TableFormatException("Row count mismatch");
            }
            itemShapes[icol] = itemShape;
            String blankKey = "TNULL" + jcol;
            blanks[icol] = blank = cards.containsKey(blankKey) ? cards.getLongValue(blankKey) : null;
            String ttype = cards.getStringValue("TTYPE" + jcol);
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = cards.getStringValue("TUNIT" + jcol)) != null) {
                cinfo.setUnitString(tunit);
            }
            if ((tcomm = cards.getStringValue("TCOMM" + jcol)) != null) {
                cinfo.setDescription(tcomm);
            }
            if ((tucd = cards.getStringValue("TUCD" + jcol)) != null) {
                cinfo.setUCD(tucd);
            }
            if ((tutype = cards.getStringValue("TUTYP" + jcol)) != null) {
                Tables.setUtype((ValueInfo)cinfo, (String)tutype);
            }
            infos[icol] = cinfo;
        }
        this.nrow_ = nrow;
        FileChannel chan = new RandomAccessFile(file, "r").getChannel();
        long pos = dataPos;
        for (int icol = 0; icol < ncol; ++icol) {
            MappedColumnData colData = ColFitsStarTable.createColumn(formatChars[icol], infos[icol], itemShapes[icol], this.nrow_, blanks[icol], chan, pos);
            this.addColumn(colData);
            pos += (long)colData.getItemBytes() * this.nrow_;
        }
        this.getParameters().addAll(Arrays.asList(cards.getUnusedParams()));
    }

    public long getRowCount() {
        return this.nrow_;
    }

    static long[] parseTdim(String tdim) {
        if (tdim == null) {
            return null;
        }
        if ((tdim = tdim.trim()).charAt(0) != '(' || tdim.charAt(tdim.length() - 1) != ')') {
            return null;
        }
        String[] sdims = tdim.substring(1, tdim.length() - 1).split(",");
        long[] dims = new long[sdims.length];
        for (int i = 0; i < sdims.length; ++i) {
            try {
                dims[i] = Long.parseLong(sdims[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return dims;
    }

    private static long multiply(long[] dims) {
        long product = 1L;
        for (int i = 0; i < dims.length; ++i) {
            product *= dims[i];
        }
        return product;
    }

    private static long multiply(int[] dims) {
        long product = 1L;
        for (int i = 0; i < dims.length; ++i) {
            product *= (long)dims[i];
        }
        return product;
    }

    private static MappedColumnData createColumn(char formatChar, ColumnInfo info, int[] itemShape, long nrow, Number blank, FileChannel chan, long pos) throws IOException {
        final int itemSize = Tables.checkedLongToInt((long)ColFitsStarTable.multiply(itemShape));
        int[] SCALAR = new int[]{};
        if (itemSize == 1) {
            if (formatChar == 'L') {
                info.setContentClass(Boolean.class);
                return ColFitsStarTable.createColumnData(info, 1, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        switch (buf.get(offset)) {
                            case 84: {
                                return Boolean.TRUE;
                            }
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return null;
                    }
                });
            }
            if (formatChar == 'A') {
                info.setContentClass(Character.class);
                info.setNullable(false);
                return ColFitsStarTable.createColumnData(info, 1, SCALAR, nrow, chan, pos, new ValueReader(){

                    protected Object readValue(ByteBuffer buf, int offset) {
                        return new Character((char)(buf.get(offset) & 0xFF));
                    }
                });
            }
            if (formatChar == 'B') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final byte badval = hasBad ? blank.byteValue() : (byte)0;
                info.setNullable(hasBad);
                return ColFitsStarTable.createColumnData(info, 1, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        byte val = buf.get(offset);
                        return hasBad && val == badval ? null : new Short((short)(val & 0xFF));
                    }
                });
            }
            if (formatChar == 'b') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final byte badval = hasBad ? blank.byteValue() : (byte)0;
                info.setNullable(hasBad);
                return ColFitsStarTable.createColumnData(info, 1, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        byte val = buf.get(offset);
                        return hasBad && val == badval ? null : new Short(val);
                    }
                });
            }
            if (formatChar == 'I') {
                info.setContentClass(Short.class);
                final boolean hasBad = blank != null;
                final short badval = hasBad ? blank.shortValue() : (short)0;
                info.setNullable(hasBad);
                return ColFitsStarTable.createColumnData(info, 2, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        short val = buf.getShort(offset);
                        return hasBad && val == badval ? null : new Short(val);
                    }
                });
            }
            if (formatChar == 'J') {
                info.setContentClass(Integer.class);
                final boolean hasBad = blank != null;
                final int badval = hasBad ? blank.intValue() : 0;
                info.setNullable(hasBad);
                return ColFitsStarTable.createColumnData(info, 4, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        int val = buf.getInt(offset);
                        return hasBad && val == badval ? null : new Integer(val);
                    }
                });
            }
            if (formatChar == 'K') {
                info.setContentClass(Long.class);
                final boolean hasBad = blank != null;
                final long badval = hasBad ? blank.longValue() : 0L;
                info.setNullable(hasBad);
                return ColFitsStarTable.createColumnData(info, 8, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        long val = buf.getLong(offset);
                        return hasBad && val == badval ? null : new Long(val);
                    }
                });
            }
            if (formatChar == 'E') {
                info.setContentClass(Float.class);
                return ColFitsStarTable.createColumnData(info, 4, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        return new Float(buf.getFloat(offset));
                    }
                });
            }
            if (formatChar == 'D') {
                info.setContentClass(Double.class);
                return ColFitsStarTable.createColumnData(info, 8, SCALAR, nrow, chan, pos, new ValueReader(){

                    Object readValue(ByteBuffer buf, int offset) {
                        return new Double(buf.getDouble(offset));
                    }
                });
            }
        } else {
            info.setShape(itemShape);
            info.setNullable(false);
            if (formatChar == 'L') {
                info.setContentClass([Z.class);
                return ColFitsStarTable.createColumnData(info, 1, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        boolean[] val = new boolean[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.get() == 84;
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'B') {
                info.setContentClass([S.class);
                return ColFitsStarTable.createColumnData(info, 1, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = (short)(buf.get() & 0xFF);
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'b') {
                info.setContentClass([S.class);
                return ColFitsStarTable.createColumnData(info, 1, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.get();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'I') {
                info.setContentClass([S.class);
                return ColFitsStarTable.createColumnData(info, 2, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        short[] val = new short[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.getShort();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'J') {
                info.setContentClass([I.class);
                return ColFitsStarTable.createColumnData(info, 4, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        int[] val = new int[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.getInt();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'K') {
                info.setContentClass([J.class);
                return ColFitsStarTable.createColumnData(info, 8, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        long[] val = new long[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.getLong();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'E') {
                info.setContentClass([F.class);
                return ColFitsStarTable.createColumnData(info, 4, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        float[] val = new float[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.getFloat();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'D') {
                info.setContentClass([D.class);
                return ColFitsStarTable.createColumnData(info, 8, itemShape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        double[] val = new double[itemSize];
                        for (int i = 0; i < itemSize; ++i) {
                            val[i] = buf.getDouble();
                        }
                        return val;
                    }
                });
            }
            if (formatChar == 'A') {
                final int sleng = itemShape[0];
                final char[] charBuf = new char[sleng];
                info.setElementSize(sleng);
                info.setNullable(true);
                if (itemShape.length == 1) {
                    info.setContentClass(String.class);
                    return ColFitsStarTable.createColumnData(info, sleng, SCALAR, nrow, chan, pos, new ValueReader(){

                        protected synchronized Object readValue(ByteBuffer buf, int offset) {
                            buf.position(offset);
                            int iend = 0;
                            boolean end = false;
                            for (int i = 0; i < sleng; ++i) {
                                byte b = buf.get();
                                if (b == 0) {
                                    end = true;
                                }
                                if (end) continue;
                                charBuf[i] = (char)(b & 0xFF);
                                if (b == 32) continue;
                                iend = i + 1;
                            }
                            return iend > 0 ? new String(charBuf, 0, iend) : null;
                        }
                    });
                }
                info.setContentClass(String;.class);
                int[] sshape = new int[itemShape.length - 1];
                System.arraycopy(itemShape, 1, sshape, 0, sshape.length);
                info.setShape(sshape);
                final int nstring = itemSize / sleng;
                if (!$assertionsDisabled && nstring * sleng != itemSize) {
                    throw new AssertionError();
                }
                return ColFitsStarTable.createColumnData(info, sleng, sshape, nrow, chan, pos, new ValueReader(){

                    protected synchronized Object readValue(ByteBuffer buf, int offset) {
                        buf.position(offset);
                        String[] val = new String[nstring];
                        for (int is = 0; is < nstring; ++is) {
                            int iend = 0;
                            boolean end = false;
                            for (int ic = 0; ic < sleng; ++ic) {
                                byte b = buf.get();
                                if (b == 0) {
                                    end = true;
                                }
                                if (end) continue;
                                charBuf[ic] = (char)(b & 0xFF);
                                if (b == 32) continue;
                                iend = ic + 1;
                            }
                            val[is] = iend > 0 ? new String(charBuf, 0, iend) : null;
                        }
                        return val;
                    }
                });
            }
        }
        throw new IOException("Unknown TFORM character '" + formatChar + "'");
    }

    private static MappedColumnData createColumnData(ColumnInfo info, int typeBytes, int[] itemShape, long nrow, FileChannel chan, long pos, ValueReader reader) throws IOException {
        MappedColumnData cdata;
        long itemBytes = Tables.checkedLongToInt((long)ColFitsStarTable.multiply(itemShape)) * typeBytes;
        long colBytes = itemBytes * nrow;
        if (mappedBytes_ + colBytes > 0x40000000L && !Loader.is64Bit() && !mapWarned_) {
            logger_.warning("Doing a lot of mapping - may run out of address space on 32-bit JVM");
            mapWarned_ = true;
        }
        if (colBytes <= Integer.MAX_VALUE) {
            cdata = new SingleMappedColumnData(info, typeBytes, itemShape, nrow, chan, pos, reader);
        } else {
            int nsec = (int)(colBytes / Integer.MAX_VALUE) + 1;
            cdata = new SectionsMappedColumnData(info, typeBytes, itemShape, nrow, chan, pos, nsec, reader);
        }
        mappedBytes_ += colBytes;
        return cdata;
    }

    private static int toInt(long lval) {
        int ival = (int)lval;
        if (!$assertionsDisabled && (long)ival != lval) {
            throw new AssertionError();
        }
        return ival;
    }

    static {
        $assertionsDisabled = !ColFitsStarTable.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.fits");
    }

    private static class SectionsMappedColumnData
    extends MappedColumnData {
        private final int nsec_;
        private final int secRows_;
        private final int secBytes_;
        private final ByteBuffer[] bufs_;

        SectionsMappedColumnData(ColumnInfo info, int typeBytes, int[] itemShape, long nrow, FileChannel chan, long pos, int nsec, ValueReader reader) {
            super(info, typeBytes, itemShape, nrow, chan, pos, reader);
            this.nsec_ = nsec;
            this.secRows_ = ColFitsStarTable.toInt((this.nrow_ + (long)(this.nsec_ - 1)) / (long)this.nsec_);
            this.secBytes_ = ColFitsStarTable.toInt((long)this.secRows_ * (long)this.itemBytes_);
            this.bufs_ = new ByteBuffer[this.nsec_];
        }

        private ByteBuffer getBuffer(int isec) throws IOException {
            if (this.bufs_[isec] == null) {
                long offset = (long)isec * (long)this.secBytes_;
                int leng = ColFitsStarTable.toInt(Math.min(this.nrow_ * (long)this.itemBytes_ - offset, (long)this.secBytes_));
                this.bufs_[isec] = this.mapBuffer(offset, leng);
                logger_.config("Mapping column region " + (isec + 1) + "/" + this.nsec_ + " of " + this.getColumnInfo());
            }
            return this.bufs_[isec];
        }

        public synchronized Object readValue(long lrow) throws IOException {
            if (lrow < this.nrow_) {
                int isec = (int)(lrow / (long)this.secRows_);
                int ioff = (int)(lrow % (long)this.secRows_ * (long)this.itemBytes_);
                return this.readValue(this.getBuffer(isec), ioff);
            }
            throw new IOException("Row " + lrow + " out of range");
        }
    }

    private static class SingleMappedColumnData
    extends MappedColumnData {
        private ByteBuffer buf_;
        static final /* synthetic */ boolean $assertionsDisabled;

        SingleMappedColumnData(ColumnInfo info, int typeBytes, int[] itemShape, long nrow, FileChannel chan, long pos, ValueReader reader) throws IOException {
            super(info, typeBytes, itemShape, nrow, chan, pos, reader);
            if (!$assertionsDisabled && (long)this.itemBytes_ * this.nrow_ > Integer.MAX_VALUE) {
                throw new AssertionError();
            }
        }

        private ByteBuffer getBuffer() throws IOException {
            if (this.buf_ == null) {
                this.buf_ = this.mapBuffer(0L, (int)(this.nrow_ * (long)this.itemBytes_));
                logger_.config("Mapping column " + this.getColumnInfo());
            }
            return this.buf_;
        }

        public synchronized Object readValue(long irow) throws IOException {
            return this.readValue(this.getBuffer(), Tables.checkedLongToInt((long)irow) * this.itemBytes_);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$fits$ColFitsStarTable == null ? (class$uk$ac$starlink$fits$ColFitsStarTable = ColFitsStarTable.class$("uk.ac.starlink.fits.ColFitsStarTable")) : class$uk$ac$starlink$fits$ColFitsStarTable).desiredAssertionStatus();
        }
    }

    private static abstract class MappedColumnData
    extends ColumnData {
        protected final int itemBytes_;
        protected final long nrow_;
        private final long pos_;
        private final FileChannel chan_;
        private final ValueReader reader_;

        MappedColumnData(ColumnInfo info, int typeBytes, int[] itemShape, long nrow, FileChannel chan, long pos, ValueReader reader) {
            super(info);
            this.itemBytes_ = Tables.checkedLongToInt((long)ColFitsStarTable.multiply(itemShape)) * typeBytes;
            this.chan_ = chan;
            this.nrow_ = nrow;
            this.pos_ = pos;
            this.reader_ = reader;
        }

        protected Object readValue(ByteBuffer buf, int offset) throws IOException {
            try {
                return this.reader_.readValue(buf, offset);
            }
            catch (RuntimeException e) {
                throw (IOException)new IOException("Failed buffer read attempt").initCause(e);
            }
        }

        protected ByteBuffer mapBuffer(long offset, int size) throws IOException {
            return this.chan_.map(FileChannel.MapMode.READ_ONLY, this.pos_ + offset, size);
        }

        public int getItemBytes() {
            return this.itemBytes_;
        }
    }

    private static abstract class ValueReader {
        private ValueReader() {
        }

        abstract Object readValue(ByteBuffer var1, int var2);
    }
}

