/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.BufferedFile;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class ColFitsTableBuilder
implements TableBuilder {
    public String getFormatName() {
        return "colfits-basic";
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream from colFITS format");
    }

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (!FitsConstants.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        if (!(datsrc instanceof FileDataSource) || datsrc.getCompression() != Compression.NONE) {
            throw new TableFormatException("Not uncompressed file on disk");
        }
        File file = ((FileDataSource)datsrc).getFile();
        long pos = 0L;
        Header hdr = new Header();
        BufferedFile in = new BufferedFile(file.toString());
        try {
            pos += FitsConstants.skipHDUs(in, 1);
        }
        catch (FitsException e) {
            throw (IOException)new IOException("FITS read error").initCause(e);
        }
        finally {
            in.close();
        }
        return new ColFitsStarTable(file, hdr, pos += (long)FitsConstants.readHeader(hdr, in));
    }
}

