/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import [Ljava.lang.String;;
import java.io.DataInput;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.table.Tables;

abstract class ColumnReader {
    private final Class clazz_;
    private final int[] shape_;
    private final int length_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");
    static /* synthetic */ Class class$uk$ac$starlink$fits$ColumnReader;

    ColumnReader(Class clazz, int[] shape, int length) {
        this.clazz_ = clazz;
        this.shape_ = shape;
        this.length_ = length;
    }

    ColumnReader(Class clazz, int length) {
        this(clazz, null, length);
    }

    abstract Object readValue(DataInput var1) throws IOException;

    Class getContentClass() {
        return this.clazz_;
    }

    int[] getShape() {
        return this.shape_;
    }

    int getElementSize() {
        return -1;
    }

    int getLength() {
        return this.length_;
    }

    public static ColumnReader createColumnReader(String tform, double scale, double zero, boolean hasBlank, long blank, int[] tdims, String ttype, final long heapStart) throws FitsException {
        char vtype;
        int[] dims;
        Matcher fmatch = Pattern.compile("([0-9]*)([LXBIJKAEDCMPQ])(.*)").matcher(tform);
        if (!fmatch.lookingAt()) {
            throw new FitsException("Error parsing TFORM value " + tform);
        }
        String scount = fmatch.group(1);
        final int count = scount.length() == 0 ? 1 : Integer.parseInt(scount);
        char type = fmatch.group(2).charAt(0);
        String matchA = fmatch.group(3).trim();
        if (type == 'P' || type == 'Q') {
            dims = tdims == null ? new int[]{-1} : tdims;
        } else if (count == 1) {
            dims = null;
        } else if (tdims == null) {
            dims = new int[]{count};
        } else {
            int[] nArray;
            int nel = 1;
            for (int i = 0; i < tdims.length; ++i) {
                nel *= tdims[i];
            }
            if (nel == count) {
                nArray = tdims;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = count;
            }
            dims = nArray;
        }
        if (type == 'P') {
            if (heapStart > 0L) {
                vtype = matchA.charAt(0);
                final ArrayReader aReader = ColumnReader.createArrayReader(vtype, scale, zero, hasBlank, blank, dims);
                return new ColumnReader(aReader.getContentClass(), aReader.getShape(), 8){

                    Object readValue(DataInput stream) throws IOException {
                        int nel = stream.readInt();
                        int offset = stream.readInt();
                        if (stream instanceof RandomAccess) {
                            if (nel > 0) {
                                RandomAccess rStream = (RandomAccess)stream;
                                long point = rStream.getFilePointer();
                                rStream.seek(heapStart + (long)offset);
                                Object array = aReader.readArray(stream, nel);
                                rStream.seek(point);
                                return array;
                            }
                            return aReader.readArray(stream, 0);
                        }
                        return null;
                    }

                    int getElementSize() {
                        return aReader.getElementSize();
                    }
                };
            }
            logger_.warning("Column " + ttype + "(TFORM=" + tform + ") - " + "variable length arrays not supported " + "in sequential mode");
            String value = "?";
            return new ColumnReader(String.class, 8){

                Object readValue(DataInput stream) throws IOException {
                    int nel = stream.readInt();
                    int offset = stream.readInt();
                    return nel > 0 ? "?" : "";
                }

                int getElementSize() {
                    return "?".length();
                }
            };
        }
        if (type == 'Q') {
            if (heapStart > 0L) {
                vtype = matchA.charAt(0);
                final ArrayReader aReader = ColumnReader.createArrayReader(vtype, scale, zero, hasBlank, blank, dims);
                return new ColumnReader(aReader.getContentClass(), aReader.getShape(), 16){

                    Object readValue(DataInput stream) throws IOException {
                        long lnel = stream.readLong();
                        long offset = stream.readLong();
                        if (stream instanceof RandomAccess) {
                            int nel = Tables.checkedLongToInt((long)lnel);
                            if (nel > 0) {
                                RandomAccess rStream = (RandomAccess)stream;
                                long point = rStream.getFilePointer();
                                rStream.seek(heapStart + offset);
                                Object array = aReader.readArray(stream, nel);
                                rStream.seek(point);
                                return array;
                            }
                            return aReader.readArray(stream, 0);
                        }
                        return null;
                    }

                    int getElementSize() {
                        return aReader.getElementSize();
                    }
                };
            }
            logger_.warning("Column " + ttype + "(TFORM=" + tform + ") - " + "variable length arrays not supported " + "in sequential mode");
            String value = "?";
            return new ColumnReader(String.class, 16){

                Object readValue(DataInput stream) throws IOException {
                    long nel = stream.readLong();
                    long offset = stream.readLong();
                    return nel > 0L ? "?" : "";
                }

                int getElementSize() {
                    return "?".length();
                }
            };
        }
        if (count == 1) {
            return ColumnReader.createScalarColumnReader(type, scale, zero, hasBlank, blank);
        }
        final ArrayReader aReader = ColumnReader.createArrayReader(type, scale, zero, hasBlank, blank, dims);
        return new ColumnReader(aReader.getContentClass(), aReader.getShape(), aReader.getByteCount(count)){

            Object readValue(DataInput stream) throws IOException {
                return aReader.readArray(stream, count);
            }

            int getElementSize() {
                return aReader.getElementSize();
            }
        };
    }

    private static ColumnReader createScalarColumnReader(char type, final double scale, final double zero, final boolean hasBlank, final long blank) {
        boolean isScaled = scale != 1.0 || zero != 0.0;
        boolean isOffset = scale == 1.0 && zero != 0.0;
        boolean intOffset = isOffset && (double)Math.round(zero) == zero;
        switch (type) {
            case 'L': {
                ColumnReader reader = new ColumnReader(Boolean.class, 1){

                    Object readValue(DataInput stream) throws IOException {
                        switch (stream.readByte()) {
                            case 84: {
                                return Boolean.TRUE;
                            }
                            case 70: {
                                return Boolean.FALSE;
                            }
                        }
                        return null;
                    }
                };
                return reader;
            }
            case 'B': {
                int mask = 255;
                boolean shortable = intOffset && zero >= -32768.0 && zero < 32511.0;
                final short sZero = (short)zero;
                ColumnReader reader = shortable ? new ColumnReader(Short.class, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Short((short)((val & 0xFF) + sZero));
                    }
                } : (isScaled ? new ColumnReader(Float.class, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Float((double)(val & 0xFF) * scale + zero);
                    }
                } : new ColumnReader(Short.class, 1){

                    Object readValue(DataInput stream) throws IOException {
                        byte val = stream.readByte();
                        return hasBlank && val == (byte)blank ? null : new Short((short)(val & 0xFF));
                    }
                });
                return reader;
            }
            case 'I': {
                ColumnReader reader = isScaled ? new ColumnReader(Float.class, 2){

                    Object readValue(DataInput stream) throws IOException {
                        short val = stream.readShort();
                        return hasBlank && val == (short)blank ? null : new Float((float)((double)val * scale + zero));
                    }
                } : new ColumnReader(Short.class, 2){

                    Object readValue(DataInput stream) throws IOException {
                        short val = stream.readShort();
                        return hasBlank && val == (short)blank ? null : new Short(val);
                    }
                };
                return reader;
            }
            case 'J': {
                ColumnReader reader = isScaled ? new ColumnReader(Double.class, 4){

                    Object readValue(DataInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Double((double)val * scale + zero);
                    }
                } : new ColumnReader(Integer.class, 4){

                    Object readValue(DataInput stream) throws IOException {
                        int val = stream.readInt();
                        return hasBlank && val == (int)blank ? null : new Integer(val);
                    }
                };
                return reader;
            }
            case 'K': {
                ColumnReader reader = isScaled ? new ColumnReader(Double.class, 8){

                    Object readValue(DataInput stream) throws IOException {
                        long val = stream.readLong();
                        return hasBlank && val == blank ? null : new Double((double)val * scale + zero);
                    }
                } : new ColumnReader(Long.class, 8){

                    Object readValue(DataInput stream) throws IOException {
                        long val = stream.readLong();
                        return hasBlank && val == blank ? null : new Long(val);
                    }
                };
                return reader;
            }
            case 'A': {
                ColumnReader reader = new ColumnReader(Character.class, 1){

                    Object readValue(DataInput stream) throws IOException {
                        char c = (char)(stream.readByte() & 0xFF);
                        return new Character(c);
                    }
                };
                return reader;
            }
            case 'E': {
                ColumnReader reader = isScaled ? new ColumnReader(Float.class, 4){

                    Object readValue(DataInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float((double)val * scale + zero);
                    }
                } : new ColumnReader(Float.class, 4){

                    Object readValue(DataInput stream) throws IOException {
                        float val = stream.readFloat();
                        return new Float(val);
                    }
                };
                return reader;
            }
            case 'D': {
                ColumnReader reader = isScaled ? new ColumnReader(Double.class, 8){

                    Object readValue(DataInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val);
                    }
                } : new ColumnReader(Double.class, 8){

                    Object readValue(DataInput stream) throws IOException {
                        double val = stream.readDouble();
                        return new Double(val * scale + zero);
                    }
                };
                return reader;
            }
            case 'C': 
            case 'M': {
                int[] complexDims = new int[]{2};
                final ArrayReader complexReader = type == 'C' ? ColumnReader.createFloatsArrayReader(complexDims, scale, zero) : ColumnReader.createDoublesArrayReader(complexDims, scale, zero);
                return new ColumnReader(complexReader.getContentClass(), complexDims, complexReader.getByteCount(2)){

                    Object readValue(DataInput stream) throws IOException {
                        return complexReader.readArray(stream, 2);
                    }

                    int getElementSize() {
                        return complexReader.getElementSize();
                    }
                };
            }
        }
        throw new AssertionError((Object)("Unknown TFORM type " + type));
    }

    private static ArrayReader createArrayReader(char type, final double scale, final double zero, final boolean hasBlank, final long blank, final int[] dims) {
        boolean isScaled = scale != 1.0 || zero != 0.0;
        boolean isOffset = scale == 1.0 && zero != 0.0;
        boolean intOffset = isOffset && (double)Math.round(zero) == zero;
        switch (type) {
            case 'L': {
                ArrayReader reader = new ArrayReader([Z.class, dims, 1){

                    Object readArray(DataInput stream, int count) throws IOException {
                        boolean[] value = new boolean[count];
                        for (int i = 0; i < count; ++i) {
                            value[i] = stream.readByte() == 84;
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'X': {
                ArrayReader reader = new ArrayReader([Z.class, dims, -1){

                    Object readArray(DataInput stream, int count) throws IOException {
                        boolean[] value = new boolean[count];
                        int ibit = 0;
                        int b = 0;
                        for (int i = 0; i < count; ++i) {
                            if (ibit == 0) {
                                ibit = 8;
                                b = stream.readByte();
                            }
                            value[i] = (b & 1) != 0;
                            b >>>= 1;
                            --ibit;
                        }
                        return value;
                    }

                    int getByteCount(int nel) {
                        return (nel + 7) / 8;
                    }
                };
                return reader;
            }
            case 'B': {
                int mask = 255;
                boolean shortable = intOffset && zero >= -32768.0 && zero < 32511.0;
                final short sZero = (short)zero;
                ArrayReader reader = shortable ? new ArrayReader([S.class, dims, 1){

                    Object readArray(DataInput stream, int count) throws IOException {
                        short[] value = new short[count];
                        for (int i = 0; i < count; ++i) {
                            byte val = stream.readByte();
                            value[i] = (short)((val & 0xFF) + sZero);
                        }
                        return value;
                    }
                } : (isScaled ? new ArrayReader([F.class, dims, 1){

                    Object readArray(DataInput stream, int count) throws IOException {
                        double[] value = new double[count];
                        for (int i = 0; i < count; ++i) {
                            byte val = stream.readByte();
                            value[i] = hasBlank && val == (byte)blank ? Double.NaN : (double)((float)((double)(val & 0xFF) * scale + zero));
                        }
                        return value;
                    }
                } : new ArrayReader([S.class, dims, 1){

                    Object readArray(DataInput stream, int count) throws IOException {
                        short[] value = new short[count];
                        for (int i = 0; i < count; ++i) {
                            byte val = stream.readByte();
                            value[i] = (short)(val & 0xFF);
                        }
                        return value;
                    }
                });
                return reader;
            }
            case 'I': {
                ArrayReader reader = isScaled ? new ArrayReader([F.class, dims, 2){

                    Object readArray(DataInput stream, int count) throws IOException {
                        double[] value = new double[count];
                        for (int i = 0; i < count; ++i) {
                            short val = stream.readShort();
                            value[i] = hasBlank && val == (short)blank ? Double.NaN : (double)((float)((double)val * scale + zero));
                        }
                        return value;
                    }
                } : new ArrayReader([S.class, dims, 2){

                    Object readArray(DataInput stream, int count) throws IOException {
                        short[] value = new short[count];
                        for (int i = 0; i < count; ++i) {
                            short val;
                            value[i] = val = stream.readShort();
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'J': {
                ArrayReader reader = isScaled ? new ArrayReader([D.class, dims, 4){

                    Object readArray(DataInput stream, int count) throws IOException {
                        double[] value = new double[count];
                        for (int i = 0; i < count; ++i) {
                            int val = stream.readInt();
                            value[i] = hasBlank && val == (int)blank ? Double.NaN : (double)val * scale + zero;
                        }
                        return value;
                    }
                } : new ArrayReader([I.class, dims, 4){

                    Object readArray(DataInput stream, int count) throws IOException {
                        int[] value = new int[count];
                        for (int i = 0; i < count; ++i) {
                            int val;
                            value[i] = val = stream.readInt();
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'K': {
                ArrayReader reader = isScaled ? new ArrayReader([D.class, dims, 8){

                    Object readArray(DataInput stream, int count) throws IOException {
                        double[] value = new double[count];
                        for (int i = 0; i < count; ++i) {
                            long val = stream.readLong();
                            value[i] = hasBlank && val == blank ? Double.NaN : (double)val * scale + zero;
                        }
                        return value;
                    }
                } : new ArrayReader([J.class, dims, 8){

                    Object readArray(DataInput stream, int count) throws IOException {
                        long[] value = new long[count];
                        for (int i = 0; i < count; ++i) {
                            long val;
                            value[i] = val = stream.readLong();
                        }
                        return value;
                    }
                };
                return reader;
            }
            case 'A': {
                ArrayReader reader;
                if (dims.length == 1) {
                    reader = new ArrayReader(String.class, null, 1){

                        Object readArray(DataInput stream, int count) throws IOException {
                            return ColumnReader.readString(stream, count);
                        }

                        int getElementSize() {
                            return dims[0];
                        }
                    };
                } else {
                    int nel = 1;
                    for (int i = 1; i < dims.length; ++i) {
                        nel *= dims[i];
                    }
                    final int stringLength = dims[0];
                    int nString = nel;
                    int[] shape = new int[dims.length - 1];
                    System.arraycopy(dims, 1, shape, 0, dims.length - 1);
                    reader = new ArrayReader(String;.class, shape, 1){
                        static final /* synthetic */ boolean $assertionsDisabled;

                        Object readArray(DataInput stream, int count) throws IOException {
                            int nString = (count + stringLength - 1) / stringLength;
                            String[] value = new String[nString];
                            for (int i = 0; i < nString; ++i) {
                                int nchar = Math.min(count, stringLength);
                                value[i] = ColumnReader.readString(stream, nchar);
                                count -= nchar;
                            }
                            if (!$assertionsDisabled && count != 0) {
                                throw new AssertionError();
                            }
                            return value;
                        }

                        int getElementSize() {
                            return stringLength;
                        }

                        static {
                            $assertionsDisabled = !(class$uk$ac$starlink$fits$ColumnReader == null ? (class$uk$ac$starlink$fits$ColumnReader = ColumnReader.class$("uk.ac.starlink.fits.ColumnReader")) : class$uk$ac$starlink$fits$ColumnReader).desiredAssertionStatus();
                        }
                    };
                }
                return reader;
            }
            case 'E': {
                return ColumnReader.createFloatsArrayReader(dims, scale, zero);
            }
            case 'D': {
                return ColumnReader.createDoublesArrayReader(dims, scale, zero);
            }
            case 'C': {
                return ColumnReader.createFloatsArrayReader(ColumnReader.complexShape(dims), scale, zero);
            }
            case 'M': {
                return ColumnReader.createDoublesArrayReader(ColumnReader.complexShape(dims), scale, zero);
            }
        }
        throw new AssertionError((Object)("Unknown TFORM type " + type));
    }

    private static ArrayReader createFloatsArrayReader(int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ArrayReader([F.class, shape, 4){

                Object readArray(DataInput stream, int count) throws IOException {
                    float[] value = new float[count];
                    for (int i = 0; i < count; ++i) {
                        float val = stream.readFloat();
                        value[i] = (float)((double)val * scale + zero);
                    }
                    return value;
                }
            };
        }
        return new ArrayReader([F.class, shape, 4){

            Object readArray(DataInput stream, int count) throws IOException {
                float[] value = new float[count];
                for (int i = 0; i < count; ++i) {
                    value[i] = stream.readFloat();
                }
                return value;
            }
        };
    }

    private static ArrayReader createDoublesArrayReader(int[] shape, final double scale, final double zero) {
        boolean isScaled;
        boolean bl = isScaled = scale != 1.0 || zero != 0.0;
        if (isScaled) {
            return new ArrayReader([D.class, shape, 8){

                Object readArray(DataInput stream, int count) throws IOException {
                    double[] value = new double[count];
                    for (int i = 0; i < count; ++i) {
                        double val = stream.readDouble();
                        value[i] = val * scale + zero;
                    }
                    return value;
                }
            };
        }
        return new ArrayReader([D.class, shape, 8){

            Object readArray(DataInput stream, int count) throws IOException {
                double[] value = new double[count];
                for (int i = 0; i < count; ++i) {
                    value[i] = stream.readDouble();
                }
                return value;
            }
        };
    }

    private static String readString(DataInput stream, int count) throws IOException {
        char[] letters = new char[count];
        int last = -1;
        boolean end = false;
        for (int i = 0; i < count; ++i) {
            char letter = (char)(stream.readByte() & 0xFF);
            if (letter == '\u0000') {
                end = true;
            }
            if (end) continue;
            letters[i] = letter;
            if (letter == ' ') continue;
            last = i;
        }
        int leng = last + 1;
        return leng == 0 ? null : new String(letters, 0, leng);
    }

    private static int[] complexShape(int[] dims) {
        if (dims == null) {
            return new int[]{2};
        }
        int[] shape = new int[dims.length + 1];
        shape[0] = 2;
        System.arraycopy(dims, 0, shape, 1, dims.length);
        return shape;
    }

    private static abstract class ArrayReader {
        private final Class clazz_;
        private final int[] shape_;
        private final int elBytes_;

        ArrayReader(Class clazz, int[] shape, int elBytes) {
            this.clazz_ = clazz;
            this.shape_ = shape;
            this.elBytes_ = elBytes;
        }

        abstract Object readArray(DataInput var1, int var2) throws IOException;

        Class getContentClass() {
            return this.clazz_;
        }

        int[] getShape() {
            return this.shape_;
        }

        int getElementSize() {
            return -1;
        }

        int getByteCount(int count) {
            return this.elBytes_ * count;
        }
    }
}

