/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.DummyNDArray;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.ast.FitsChan;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.fits.AddableHeader;
import uk.ac.starlink.fits.FitsArrayBuilder;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsURL;
import uk.ac.starlink.fits.WritableFitsArrayImpl;
import uk.ac.starlink.hdx.HdxContainer;
import uk.ac.starlink.hdx.HdxDOMImplementation;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxDocumentFactory;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxHandler;
import uk.ac.starlink.ndx.XMLNdxHandler;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.URLUtils;

public class FitsNdxHandler
implements NdxHandler,
HdxDocumentFactory {
    private static FitsNdxHandler instance = new FitsNdxHandler();
    private List extensions = new ArrayList(FitsConstants.defaultFitsExtensions());
    private static Logger logger;

    private FitsNdxHandler() {
    }

    public static FitsNdxHandler getInstance() {
        return instance;
    }

    public Ndx makeNdx(URL url, AccessMode mode) throws IOException {
        FrameSet wcs;
        String units;
        Header hdr;
        FitsURL furl = FitsURL.parseURL(url, this.extensions);
        if (furl == null) {
            return null;
        }
        FitsArrayBuilder fab = FitsArrayBuilder.getInstance();
        ArrayDataInput strm = fab.getReadableStream(url, AccessMode.READ);
        try {
            hdr = Header.readHeader(strm);
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        strm.close();
        if (hdr.containsKey("NDX_XML")) {
            String loc = hdr.getStringValue("NDX_XML");
            URL xurl = new URL(url, loc);
            ArrayDataInput xstrm = fab.getReadableStream(xurl, AccessMode.READ);
            try {
                Header xhdr = new Header(xstrm);
                AsciiTable tab = new AsciiTable(xhdr);
                tab.read(xstrm);
                String[] cellval = (String[])tab.getElement(0, 0);
                String xdat = cellval[0];
                StreamSource xsrc = new StreamSource(new StringReader(xdat), xurl.toString());
                Ndx ndx = XMLNdxHandler.getInstance().makeNdx((Source)xsrc, mode);
                return ndx;
            }
            catch (FitsException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        NDArray image = fab.makeNDArray(url, mode);
        String string = units = hdr.containsKey("BUNIT") ? hdr.getStringValue("BUNIT") : null;
        if (AstPackage.isAvailable()) {
            AstObject aobj;
            final Cursor cardIt = hdr.iterator();
            Iterator lineIt = new Iterator(){

                public boolean hasNext() {
                    return cardIt.hasNext();
                }

                public Object next() {
                    return cardIt.next().toString();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            FitsChan fchan = new FitsChan(lineIt);
            try {
                aobj = fchan.read();
            }
            catch (AstException e) {
                aobj = null;
            }
            wcs = aobj instanceof FrameSet ? (FrameSet)aobj : null;
        } else {
            wcs = null;
        }
        DefaultMutableNdx ndx = new DefaultMutableNdx(image);
        if (wcs != null) {
            ndx.setWCS(wcs);
        }
        if (units != null) {
            ndx.setUnits(units);
        }
        return ndx;
    }

    public boolean makeBlankNdx(URL url, Ndx template) throws IOException {
        DefaultMutableNdx ndx = new DefaultMutableNdx(template);
        ndx.setImage(FitsNdxHandler.makeFitsDummyArray(template.getImage()));
        if (template.hasVariance()) {
            ndx.setVariance(FitsNdxHandler.makeFitsDummyArray(template.getVariance()));
        }
        if (template.hasQuality()) {
            ndx.setQuality(FitsNdxHandler.makeFitsDummyArray(template.getQuality()));
        }
        return this.outputNdx(url, (Ndx)ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputNdx(URL url, Ndx ndx) throws IOException {
        ArrayDataOutput strm;
        FitsURL furl = FitsURL.parseURL(url, this.extensions);
        if (furl == null) {
            return false;
        }
        if (furl.getHDU() != 0) {
            throw new IOException("Cannot write an NDX at HDU > 0 in FITS file (" + url + ")");
        }
        URL container = furl.getContainer();
        if (container.getProtocol().equals("file")) {
            String filename = container.getPath();
            if (new File(filename).delete()) {
                logger.info("Deleted existing file " + filename + " prior to rewriting");
            }
            strm = new BufferedFile(filename, "rw");
        } else {
            URLConnection conn = container.openConnection();
            conn.setDoInput(false);
            conn.setDoOutput(true);
            conn.connect();
            OutputStream stream = conn.getOutputStream();
            strm = new BufferedDataOutputStream(stream);
        }
        try {
            this.outputNdx(strm, url, ndx);
        }
        finally {
            strm.close();
        }
        return true;
    }

    public void outputNdx(ArrayDataOutput strm, URL url, Ndx ndx) throws IOException {
        URL iurl;
        HeaderCard[] cards;
        int ihdu;
        int nhdu = 0;
        int vhdu = 0;
        int qhdu = 0;
        try {
            ArrayList<HeaderCard> cardlist = new ArrayList<HeaderCard>();
            cardlist.add(FitsNdxHandler.commentCard("DATA component of NDX structure"));
            ihdu = nhdu++;
            if (ndx.hasVariance()) {
                vhdu = nhdu++;
            }
            if (ndx.hasQuality()) {
                qhdu = nhdu++;
            }
            int xhdu = nhdu++;
            if (ndx.hasUnits()) {
                cardlist.add(new HeaderCard("BUNIT", ndx.getUnits(), "Image array units"));
            }
            cardlist.add(new HeaderCard("NDX_XML", "#" + xhdu, "Location of NDX XML representation"));
            if (ndx.hasWCS()) {
                FitsChan fchan = new FitsChan();
                fchan.setEncoding("FITS-WCS");
                fchan.write((AstObject)ndx.getAst());
                Iterator it = fchan.iterator();
                while (it.hasNext()) {
                    cardlist.add(new HeaderCard((String)it.next()));
                }
            }
            cards = cardlist.toArray(new HeaderCard[0]);
        }
        catch (HeaderCardException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        NDArray im = ndx.getImage();
        Type itype = im.getType();
        Number ibadval = itype.isFloating() ? (Number)itype.defaultBadValue() : (Number)im.getBadHandler().getBadValue();
        WritableFitsArrayImpl iimpl = new WritableFitsArrayImpl(im.getShape(), itype, ibadval, strm, true, cards);
        if (url != null) {
            try {
                iurl = new URL(url, "#" + ihdu);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            iurl = null;
        }
        BridgeNDArray inda = new BridgeNDArray(iimpl, iurl);
        NDArrays.copy(im, inda);
        BridgeNDArray vnda = null;
        if (ndx.hasVariance()) {
            URL vurl;
            NDArray var = ndx.getVariance();
            Type vtype = var.getType();
            Number vbadval = vtype.isFloating() ? (Number)vtype.defaultBadValue() : (Number)var.getBadHandler().getBadValue();
            ArrayList<HeaderCard> vcardlist = new ArrayList<HeaderCard>();
            vcardlist.add(FitsNdxHandler.commentCard("VARIANCE component of NDX structure"));
            if (ndx.hasUnits()) {
                String vunits = "(" + ndx.getUnits() + ")**2";
                try {
                    vcardlist.add(new HeaderCard("BUNIT", vunits, "Variance array units"));
                }
                catch (HeaderCardException e) {
                    logger.warning("Failed to write variance unit string " + vunits);
                }
            }
            HeaderCard[] vcards = vcardlist.toArray(new HeaderCard[0]);
            WritableFitsArrayImpl vimpl = new WritableFitsArrayImpl(var.getShape(), vtype, vbadval, strm, false, vcards);
            if (url != null) {
                try {
                    vurl = new URL(url, "#" + vhdu);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                vurl = null;
            }
            vnda = new BridgeNDArray(vimpl, vurl);
            NDArrays.copy(var, vnda);
        }
        BridgeNDArray qnda = null;
        if (ndx.hasQuality()) {
            URL qurl;
            NDArray qual = ndx.getQuality();
            HeaderCard[] qcards = new HeaderCard[]{FitsNdxHandler.commentCard("QUALITY component of NDX structure")};
            Type qtype = qual.getType();
            WritableFitsArrayImpl qimpl = new WritableFitsArrayImpl(qual.getShape(), qtype, null, strm, false, qcards);
            if (url != null) {
                try {
                    qurl = new URL(url, "#" + qhdu);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                qurl = null;
            }
            qnda = new BridgeNDArray(qimpl, qurl);
            NDArrays.copy(qual, qnda);
        }
        DefaultMutableNdx ondx = new DefaultMutableNdx(ndx);
        ondx.setImage((NDArray)inda);
        ondx.setVariance(vnda);
        ondx.setQuality(qnda);
        try {
            HdxContainer hdx = HdxFactory.getInstance().newHdxContainer(ondx.getHdxFacade());
            ByteArrayOutputStream bufos = new ByteArrayOutputStream();
            URI uri = url == null ? null : URLUtils.urlToUri((URL)url);
            new SourceReader().writeSource(hdx.getSource(uri), (OutputStream)bufos);
            byte[] bytes = bufos.toByteArray();
            int nchar = bytes.length;
            AddableHeader hdr = new AddableHeader();
            hdr.addValue("XTENSION", "TABLE", "ASCII table extension");
            hdr.addValue("BITPIX", 8L, "Character values");
            hdr.addValue("NAXIS", 2L, "Two-dimensional table");
            hdr.addValue("NAXIS1", nchar, "Number of characters in sole row");
            hdr.addValue("NAXIS2", 1L, "Single row");
            hdr.addValue("PCOUNT", 0L, "No additional parameters");
            hdr.addValue("GCOUNT", 1L, "Single table");
            hdr.addValue("TFIELDS", 1L, "Single field");
            hdr.addValue("TBCOL1", 1L, "Sole field starts at first column");
            hdr.addValue("TFORM1", "A" + nchar, "Text field");
            hdr.addValue("TTYPE1", "XML representation of NDX extensions", "Field header");
            hdr.insertComment("XML text encoded as table entry");
            hdr.addLine(FitsConstants.END_CARD);
            hdr.write(strm);
            strm.write(bytes);
            int over = nchar % 2880;
            if (over > 0) {
                strm.write(new byte[2880 - over]);
            }
            strm.flush();
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (HdxException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static NDArray makeFitsDummyArray(NDArray nda) {
        OrderedNDShape oshape = new OrderedNDShape(nda.getShape(), Order.COLUMN_MAJOR);
        Type type = nda.getType();
        BadHandler bh = BadHandler.getHandler(type, null);
        return new DummyNDArray(oshape, type, bh);
    }

    private static HeaderCard commentCard(String text) {
        String image = "COMMENT " + text;
        if (image.length() > 80) {
            image = image.substring(0, 80);
        }
        return new HeaderCard(image);
    }

    public Document makeHdxDocument(URL url) throws HdxException {
        try {
            Ndx fitsNdx = this.makeNdx(url, AccessMode.READ);
            if (fitsNdx == null) {
                return null;
            }
            HdxDocument doc = (HdxDocument)HdxDOMImplementation.getInstance().createDocument(null, "hdx", null);
            Element el = doc.createElement("hdx");
            doc.appendChild(el);
            Element ndxEl = doc.createElement(fitsNdx.getHdxFacade());
            el.appendChild(ndxEl);
            return doc;
        }
        catch (IOException ex) {
            throw new HdxException("Failed to handle URL " + url + " (" + ex + ")");
        }
    }

    public Source makeHdxSource(URL url) throws HdxException {
        return new DOMSource(this.makeHdxDocument(url));
    }

    static {
        HdxFactory.registerHdxDocumentFactory(FitsNdxHandler.getInstance());
        logger = Logger.getLogger("uk.ac.starlink.fits");
    }
}

