/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.fits.AbstractArrayDataIO;

public class MultiMappedFile
extends AbstractArrayDataIO
implements RandomAccess {
    private final FileChannel channel_;
    private final FileChannel.MapMode mode_;
    private final long length_;
    private final MappedByteBuffer[] niobufs_;
    private final int blockBytes_;
    private final int nblock_;
    private int iblock_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiMappedFile(FileChannel chan, FileChannel.MapMode mode, int blockBytes) throws IOException {
        this.channel_ = chan;
        this.mode_ = mode;
        this.blockBytes_ = blockBytes;
        this.length_ = this.channel_.size();
        long nb = (this.length_ - 1L) / (long)blockBytes + 1L;
        if (nb > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Block count " + nb + " too high");
        }
        this.nblock_ = MultiMappedFile.toInt(nb);
        this.niobufs_ = new MappedByteBuffer[this.nblock_];
    }

    public MultiMappedFile(File file, FileChannel.MapMode mode, int blockBytes) throws IOException {
        this(MultiMappedFile.openChannel(file, mode), mode, blockBytes);
    }

    public void seek(long offsetFromStart) throws IOException {
        if (offsetFromStart < 0L || offsetFromStart >= this.length_) {
            throw new IllegalArgumentException("Seek out of range: " + offsetFromStart);
        }
        int ib = MultiMappedFile.toInt(offsetFromStart / (long)this.blockBytes_);
        int ioff = MultiMappedFile.toInt(offsetFromStart % (long)this.blockBytes_);
        this.getBuffer(ib).position(ioff);
        this.iblock_ = ib;
    }

    public long skip(long nskip) throws IOException {
        long ns = Math.min(nskip, this.remaining());
        this.seek(this.getFilePointer() + ns);
        return ns;
    }

    public long getFilePointer() {
        try {
            return this.iblock_ * this.blockBytes_ + this.getBuffer(this.iblock_).position();
        }
        catch (IOException e) {
            throw new RuntimeException("Lost file pointer", e);
        }
    }

    public int skipBytes(int toSkip) throws IOException {
        return MultiMappedFile.toInt(this.skip(toSkip));
    }

    protected byte get() throws IOException {
        try {
            return this.getBuffer(this.iblock_).get();
        }
        catch (BufferUnderflowException e) {
            if (this.iblock_ >= this.nblock_ - 1) {
                throw (IOException)new EOFException().initCause(e);
            }
            return this.getBuffer(++this.iblock_).get();
        }
    }

    protected void get(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            MappedByteBuffer niobuf = this.getBuffer(this.iblock_);
            int nr = Math.min(length, niobuf.remaining());
            niobuf.get(buf, offset, nr);
            offset += nr;
            if ((length -= nr) <= 0) continue;
            ++this.iblock_;
        }
    }

    protected void put(byte b) throws IOException {
        try {
            this.getBuffer(this.iblock_).put(b);
        }
        catch (BufferOverflowException e) {
            if (this.iblock_ >= this.nblock_ - 1) {
                throw (IOException)new EOFException().initCause(e);
            }
            this.getBuffer(++this.iblock_).put(b);
        }
    }

    protected void put(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            MappedByteBuffer niobuf = this.getBuffer(this.iblock_);
            int nw = Math.min(length, niobuf.remaining());
            niobuf.put(buf, offset, nw);
            offset += nw;
            if ((length -= nw) <= 0) continue;
            ++this.iblock_;
        }
    }

    public long length() {
        return this.length_;
    }

    protected long remaining() {
        try {
            return (long)(this.nblock_ - this.iblock_ - 1) * (long)this.blockBytes_ + (long)this.getBuffer(this.iblock_).remaining();
        }
        catch (IOException e) {
            throw new RuntimeException("Error examining mapped file", e);
        }
    }

    public void close() throws IOException {
        this.channel_.close();
    }

    public void flush() {
        for (int ib = 0; ib < this.nblock_; ++ib) {
            if (this.niobufs_[ib] == null) continue;
            this.niobufs_[ib].force();
        }
    }

    private MappedByteBuffer getBuffer(int iblock) throws IOException {
        if (this.niobufs_[iblock] == null) {
            long offset = (long)iblock * (long)this.blockBytes_;
            int leng = MultiMappedFile.toInt(Math.min(this.length_ - offset, (long)this.blockBytes_));
            this.niobufs_[iblock] = this.channel_.map(this.mode_, offset, leng);
            logger_.config("Mapping file region " + (iblock + 1) + "/" + this.nblock_);
        }
        return this.niobufs_[iblock];
    }

    /*
     * WARNING - void declaration
     */
    private static FileChannel openChannel(File file, FileChannel.MapMode mode) throws IOException {
        void var2_2;
        String rmode;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            rmode = "r";
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            rmode = "rw";
        } else {
            throw new IllegalArgumentException("Unsupported mode " + mode);
        }
        return new RandomAccessFile(file, (String)var2_2).getChannel();
    }

    private static int toInt(long lval) {
        int ival = (int)lval;
        if (!$assertionsDisabled && (long)ival != lval) {
            throw new AssertionError();
        }
        return ival;
    }

    static {
        $assertionsDisabled = !MultiMappedFile.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.fits");
    }
}

