/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import [Ljava.lang.String;;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.Cursor;
import uk.ac.starlink.fits.ArrayWriter;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;

public class VariableFitsTableSerializer
extends StandardFitsTableSerializer {
    private final StoragePolicy storagePolicy_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VariableFitsTableSerializer(StarTable table, StoragePolicy storagePolicy) throws IOException {
        this.storagePolicy_ = storagePolicy;
        this.init(table);
        this.set64BitMode(this.getPCount() > Integer.MAX_VALUE);
    }

    public void set64BitMode(boolean useQ) {
        PQMode pqMode = useQ ? PQMode.Q : PQMode.P;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setPQMode(pqMode);
        }
    }

    public Header getHeader() throws HeaderCardException {
        Header hdr = super.getHeader();
        long pcount = this.getPCount();
        long theap = hdr.getIntValue("NAXIS1") * hdr.getIntValue("NAXIS2");
        theap = (theap + 2880L - 1L) / 2880L * 2880L;
        final ArrayList<HeaderCard> cardList = new ArrayList<HeaderCard>();
        if (!$assertionsDisabled && !hdr.containsKey("PCOUNT")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !hdr.containsKey("GCOUNT")) {
            throw new AssertionError();
        }
        hdr.removeCard("THEAP");
        if (!$assertionsDisabled && !hdr.containsKey("NAXIS2")) {
            throw new AssertionError();
        }
        Cursor it = hdr.iterator();
        while (it.hasNext()) {
            HeaderCard card = (HeaderCard)it.next();
            String key = card.getKey();
            if ("PCOUNT".equals(key)) {
                cardList.add(new HeaderCard("PCOUNT", pcount, "heap size"));
                continue;
            }
            if ("TFIELDS".equals(key)) {
                cardList.add(card);
                cardList.add(new HeaderCard("THEAP", theap, "heap start (block aligned)"));
                continue;
            }
            cardList.add(card);
        }
        return new Header(){
            {
                Iterator it = cardList.iterator();
                while (it.hasNext()) {
                    this.addLine((HeaderCard)it.next());
                }
            }
        };
    }

    private VariableArrayColumnWriter[] getVariableArrayColumnWriters() {
        ColumnWriter[] colWriters = this.getColumnWriters();
        ArrayList<ColumnWriter> vcwList = new ArrayList<ColumnWriter>();
        for (int icol = 0; icol < colWriters.length; ++icol) {
            if (!(colWriters[icol] instanceof VariableArrayColumnWriter)) continue;
            vcwList.add(colWriters[icol]);
        }
        return vcwList.toArray(new VariableArrayColumnWriter[0]);
    }

    private long getPCount() {
        long pcount = 0L;
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        for (int iv = 0; iv < vcws.length; ++iv) {
            VariableArrayColumnWriter vcw = vcws[iv];
            pcount += vcw.totalElements_ * (long)vcw.arrayWriter_.getByteCount();
        }
        return pcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(DataOutput out) throws IOException {
        VariableArrayColumnWriter[] vcws = this.getVariableArrayColumnWriters();
        ByteStore byteStore = this.storagePolicy_.makeByteStore();
        int bufsiz = 65536;
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(byteStore.getOutputStream(), bufsiz));
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput(dataOut);
        }
        try {
            super.writeData(out);
            dataOut.flush();
            byteStore.copy(VariableFitsTableSerializer.toStream(out));
        }
        finally {
            byteStore.close();
        }
        int over = (int)(this.getPCount() % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
        for (int iv = 0; iv < vcws.length; ++iv) {
            vcws[iv].setDataOutput(null);
        }
    }

    ColumnWriter createColumnWriter(ColumnInfo cinfo, int[] shape, boolean varShape, int eSize, int maxEls, long totalEls, boolean nullableInt) {
        Class clazz = cinfo.getContentClass();
        if (!varShape || clazz == String.class || clazz == String;.class) {
            return super.createColumnWriter(cinfo, shape, varShape, eSize, maxEls, totalEls, nullableInt);
        }
        if (!$assertionsDisabled && !clazz.isArray()) {
            throw new AssertionError();
        }
        ArrayWriter aw = ArrayWriter.createArrayWriter(cinfo.getContentClass());
        return new VariableArrayColumnWriter(aw, maxEls, totalEls);
    }

    private static OutputStream toStream(final DataOutput dataOut) {
        if (dataOut instanceof OutputStream) {
            return (OutputStream)((Object)dataOut);
        }
        return new OutputStream(){

            public void write(int b) throws IOException {
                dataOut.write(b);
            }

            public void write(byte[] buf) throws IOException {
                dataOut.write(buf);
            }

            public void write(byte[] buf, int off, int leng) throws IOException {
                dataOut.write(buf, off, leng);
            }
        };
    }

    static {
        $assertionsDisabled = !VariableFitsTableSerializer.class.desiredAssertionStatus();
    }

    private static abstract class PQMode {
        private final char formatChar_;
        private final int intLength_;
        public static final PQMode P = new PQMode('P', 4){

            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeInt(Tables.checkedLongToInt((long)value));
            }
        };
        public static final PQMode Q = new PQMode('Q', 8){

            public void writeInteger(DataOutput out, long value) throws IOException {
                out.writeLong(value);
            }
        };

        private PQMode(char formatChar, int intLength) {
            this.formatChar_ = formatChar;
            this.intLength_ = intLength;
        }

        public abstract void writeInteger(DataOutput var1, long var2) throws IOException;

        public char getFormatChar() {
            return this.formatChar_;
        }

        public int getIntegerLength() {
            return this.intLength_;
        }
    }

    private static class VariableArrayColumnWriter
    implements ColumnWriter {
        private final ArrayWriter arrayWriter_;
        private final int maxElements_;
        private final long totalElements_;
        private PQMode pqMode_;
        private DataOutputStream dataOut_;

        VariableArrayColumnWriter(ArrayWriter arrayWriter, int maxElements, long totalElements) {
            this.arrayWriter_ = arrayWriter;
            this.maxElements_ = maxElements;
            this.totalElements_ = totalElements;
        }

        public void setPQMode(PQMode pqMode) {
            this.pqMode_ = pqMode;
        }

        public void setDataOutput(DataOutputStream dataOut) {
            this.dataOut_ = dataOut;
        }

        public void writeValue(DataOutput out, Object value) throws IOException {
            int leng = value == null ? 0 : Array.getLength(value);
            this.pqMode_.writeInteger(out, leng);
            this.pqMode_.writeInteger(out, leng == 0 ? 0L : (long)this.dataOut_.size());
            for (int i = 0; i < leng; ++i) {
                this.arrayWriter_.writeElement(this.dataOut_, value, i);
            }
        }

        public char getFormatChar() {
            return this.arrayWriter_.getFormatChar();
        }

        public String getFormat() {
            return "" + this.pqMode_.getFormatChar() + this.arrayWriter_.getFormatChar() + '(' + this.maxElements_ + ')';
        }

        public int getLength() {
            return 2 * this.pqMode_.getIntegerLength();
        }

        public int[] getDims() {
            return new int[]{-1};
        }

        public double getZero() {
            return this.arrayWriter_.getZero();
        }

        public double getScale() {
            return 1.0;
        }

        public Number getBadNumber() {
            return null;
        }
    }
}

