/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.fits.AddableHeader;
import uk.ac.starlink.fits.FitsConstants;

class WritableFitsArrayImpl
implements ArrayImpl {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.array");
    private final ArrayDataOutput stream;
    private final OrderedNDShape oshape;
    private final Type type;
    private final Number badValue;
    private final long npix;
    private final int nByte;
    private final boolean isRandom;
    private final TypedWriter writer;
    private final Header header;
    private long strmBase;

    public WritableFitsArrayImpl(NDShape shape, Type type, Number badValue, ArrayDataOutput ostream, boolean primary, HeaderCard[] cards) throws IOException {
        this.stream = ostream;
        this.oshape = new OrderedNDShape(shape, Order.COLUMN_MAJOR);
        this.type = type;
        this.badValue = badValue;
        this.npix = this.oshape.getNumPixels();
        this.nByte = type.getNumBytes();
        this.isRandom = false;
        int ndim = this.oshape.getNumDims();
        if (ndim > 99) {
            throw new IllegalArgumentException("Too many dimensions " + ndim + " > " + 99);
        }
        ArrayList<HeaderCard> cardlist = new ArrayList<HeaderCard>();
        try {
            int i;
            long[] origin = this.oshape.getOrigin();
            long[] dims = this.oshape.getDims();
            if (primary) {
                cardlist.add(new HeaderCard("SIMPLE", true, "Primary FITS HDU"));
            } else {
                cardlist.add(new HeaderCard("XTENSION", "IMAGE", "Image extension"));
            }
            cardlist.add(new HeaderCard("BITPIX", FitsConstants.typeToBitpix(type), "Number of bits per data pixel"));
            cardlist.add(new HeaderCard("NAXIS", ndim, "Number of data axes"));
            for (int i2 = 0; i2 < ndim; ++i2) {
                cardlist.add(new HeaderCard("NAXIS" + (i2 + 1), dims[i2], "length of data axis " + (i2 + 1)));
            }
            if (primary) {
                cardlist.add(new HeaderCard("EXTEND", true, "Extensions permitted"));
            } else {
                cardlist.add(new HeaderCard("PCOUNT", 0, "No extra parameters"));
                cardlist.add(new HeaderCard("GCOUNT", 1, "Only one group"));
            }
            cardlist.add(new HeaderCard("BZERO", 0.0, "Offset applied to value"));
            cardlist.add(new HeaderCard("BSCALE", 1.0, "Scaling applied to value"));
            if (badValue != null) {
                if (type.isFloating()) {
                    if (!(type == Type.FLOAT && ((Float)badValue).isNaN() || type == Type.DOUBLE && ((Double)badValue).isNaN())) {
                        logger.info("FITS does not support non-NaN bad values for floating point types - using NaN");
                    }
                } else {
                    cardlist.add(new HeaderCard("BLANK", badValue.longValue(), "Bad pixel value"));
                }
            }
            boolean defaultOrigin = true;
            for (i = 0; i < ndim; ++i) {
                if (origin[i] == 1L) continue;
                defaultOrigin = false;
            }
            if (!defaultOrigin) {
                for (i = 0; i < ndim; ++i) {
                    cardlist.add(new HeaderCard(FitsConstants.originCardName(i), origin[i], "First pixel index along axis " + (i + 1)));
                }
            }
            if (cards != null) {
                for (i = 0; i < cards.length; ++i) {
                    cardlist.add(cards[i]);
                }
            }
            cardlist.add(new HeaderCard("END"));
        }
        catch (HeaderCardException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        this.header = new AddableHeader();
        Iterator it = cardlist.iterator();
        while (it.hasNext()) {
            ((AddableHeader)this.header).addLine((HeaderCard)it.next());
        }
        if (type == Type.BYTE) {
            this.writer = new TypedWriter(){

                public void write(Object data, int start, int size) throws IOException {
                    WritableFitsArrayImpl.this.stream.write((byte[])data, start, size);
                }
            };
        } else if (type == Type.SHORT) {
            this.writer = new TypedWriter(){

                public void write(Object data, int start, int size) throws IOException {
                    WritableFitsArrayImpl.this.stream.write((short[])data, start, size);
                }
            };
        } else if (type == Type.INT) {
            this.writer = new TypedWriter(){

                public void write(Object data, int start, int size) throws IOException {
                    WritableFitsArrayImpl.this.stream.write((int[])data, start, size);
                }
            };
        } else if (type == Type.FLOAT) {
            this.writer = new TypedWriter(){

                public void write(Object data, int start, int size) throws IOException {
                    WritableFitsArrayImpl.this.stream.write((float[])data, start, size);
                }
            };
        } else if (type == Type.DOUBLE) {
            this.writer = new TypedWriter(){

                public void write(Object data, int start, int size) throws IOException {
                    WritableFitsArrayImpl.this.stream.write((double[])data, start, size);
                }
            };
        } else {
            throw new AssertionError();
        }
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean canMap() {
        return false;
    }

    public Object getMapped() {
        return null;
    }

    public boolean multipleAccess() {
        return false;
    }

    public void open() throws IOException {
        try {
            this.header.write(this.stream);
        }
        catch (FitsException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        this.strmBase = this.isRandom ? ((RandomAccess)((Object)this.stream)).getFilePointer() : 0L;
    }

    public AccessImpl getAccess() {
        return new AccessImpl(){
            private long offset = 0L;
            private BadHandler handler = BadHandler.getHandler(WritableFitsArrayImpl.access$100(WritableFitsArrayImpl.this), WritableFitsArrayImpl.access$200(WritableFitsArrayImpl.this));

            public void setOffset(long off) throws IOException {
                if (WritableFitsArrayImpl.this.isRandom) {
                    ((RandomAccess)((Object)WritableFitsArrayImpl.this.stream)).seek(WritableFitsArrayImpl.this.strmBase + off * (long)WritableFitsArrayImpl.this.nByte);
                } else if (off != this.offset) {
                    this.writeBlank(off - this.offset);
                }
                this.offset = off;
            }

            public void write(Object buffer, int start, int size) throws IOException {
                WritableFitsArrayImpl.this.writer.write(buffer, start, size);
                this.offset += (long)size;
            }

            public void read(Object buffer, int start, int size) throws IOException {
                throw new AssertionError();
            }

            public void close() throws IOException {
                this.setOffset(WritableFitsArrayImpl.this.npix);
                long writtenBytes = this.offset * (long)WritableFitsArrayImpl.this.nByte;
                int partial = (int)(writtenBytes % 2880L);
                if (partial > 0) {
                    int pad = 2880 - partial;
                    WritableFitsArrayImpl.this.stream.write(new byte[pad]);
                }
                WritableFitsArrayImpl.this.stream.flush();
            }

            private void writeBlank(long num) throws IOException {
                if (num < 0L) {
                    throw new AssertionError();
                }
                logger.info("Writing " + num + " times " + " BLANK " + "value to skipped pixels in FITS output");
                ChunkStepper cIt = new ChunkStepper(num);
                Object buffer = WritableFitsArrayImpl.this.type.newArray(cIt.getSize());
                this.handler.putBad(buffer, 0, cIt.getSize());
                while (cIt.hasNext()) {
                    this.write(buffer, 0, cIt.getSize());
                    cIt.next();
                }
            }
        };
    }

    public void close() throws IOException {
        this.stream.close();
    }

    static /* synthetic */ Number access$200(WritableFitsArrayImpl x0) {
        return x0.badValue;
    }

    private static interface TypedWriter {
        public void write(Object var1, int var2, int var3) throws IOException;
    }
}

