/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.astrogrid.samp.SampUtils;

public class JSamp {
    static final String[] COMMAND_CLASSES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JSamp() {
    }

    public static int runMain(String[] args) {
        StringBuffer ubuf = new StringBuffer().append("\n   Usage:").append("\n      ").append(JSamp.class.getName()).append(" [-help]").append(" [-version]").append(" <command>").append(" [-help]").append(" <cmd-args>").append("\n      ").append("<command-class>").append(" [-help]").append(" <cmd-args>").append("\n").append("\n   Commands (command-classes) are:");
        for (int ic = 0; ic < COMMAND_CLASSES.length; ++ic) {
            String className = COMMAND_CLASSES[ic];
            ubuf.append("\n      ").append(JSamp.abbrev(className));
            int pad = 14 - JSamp.abbrev(className).length();
            for (int i = 0; i < pad; ++i) {
                ubuf.append(' ');
            }
            ubuf.append("  (").append(className).append(")");
        }
        ubuf.append("\n");
        String usage = ubuf.toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        if (it.hasNext()) {
            String arg = (String)it.next();
            for (int ic = 0; ic < COMMAND_CLASSES.length; ++ic) {
                String className = COMMAND_CLASSES[ic];
                if (!arg.toLowerCase().equals(JSamp.abbrev(className).toLowerCase())) continue;
                it.remove();
                return JSamp.runCommand(className, argList.toArray(new String[0]));
            }
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return 0;
            }
            if (arg.startsWith("-vers")) {
                System.out.println();
                System.out.println(JSamp.getVersionText());
                System.out.println();
                return 0;
            }
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        System.err.println();
        System.err.println(JSamp.getVersionText());
        System.err.println(usage);
        return 1;
    }

    private static int runCommand(String className, String[] args) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class " + className + " not available");
            return 1;
        }
        try {
            JSamp.getMainMethod(clazz).invoke(null, new Object[]{args});
            return 0;
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    static Method getMainMethod(Class clazz) {
        Method method;
        try {
            method = clazz.getMethod("main", String;.class);
        }
        catch (NoSuchMethodException e) {
            throw (IllegalArgumentException)((Throwable)((Object)new AssertionError((Object)("main() method missing for " + clazz.getName())))).initCause(e);
        }
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods) && Modifier.isPublic(mods) && method.getReturnType() == Void.TYPE) {
            return method;
        }
        throw new IllegalArgumentException("Wrong main() method signature for " + clazz.getName());
    }

    private static String abbrev(String className) {
        return className.substring(className.lastIndexOf(".") + 1).toLowerCase();
    }

    private static String getVersionText() {
        return "   This is JSAMP.\n" + "\n   " + "JSAMP toolkit version:" + "\n      " + SampUtils.getSoftwareVersion() + "\n   " + "SAMP standard version:" + "\n      " + SampUtils.getSampVersion() + "\n   " + "Author:" + "\n      " + "Mark Taylor (m.b.taylor@bristol.ac.uk)" + "\n   " + "WWW:" + "\n      " + "http://deployer.astrogrid.org/software/jsamp/index.html";
    }

    public static void main(String[] args) {
        int status = JSamp.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    static {
        $assertionsDisabled = !JSamp.class.desiredAssertionStatus();
        COMMAND_CLASSES = new String[]{"org.astrogrid.samp.gui.HubMonitor", "org.astrogrid.samp.test.HubTester", "org.astrogrid.samp.test.CalcStorm", "org.astrogrid.samp.test.MessageSender", "org.astrogrid.samp.test.Snooper", "org.astrogrid.samp.xmlrpc.HubRunner"};
    }
}

