/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.SampMap;
import org.astrogrid.samp.SampUtils;

public class LockInfo
extends SampMap {
    private static final Logger logger_ = Logger.getLogger(LockInfo.class.getName());
    public static final String SECRET_KEY = "samp.secret";
    public static final String XMLRPCURL_KEY = "samp.hub.xmlrpc.url";
    public static final String VERSION_KEY = "samp.profile.version";
    private static final String[] KNOWN_KEYS = new String[]{"samp.secret", "samp.hub.xmlrpc.url", "samp.profile.version"};
    public static final String DEFAULT_VERSION_VALUE = "1.1";
    private static final Pattern TOKEN_REGEX = Pattern.compile("[a-zA-Z0-9\\-_\\.]+");
    private static final Pattern ASSIGNMENT_REGEX = Pattern.compile("(" + TOKEN_REGEX.pattern() + ")=(.*)");
    private static final Pattern COMMENT_REGEX = Pattern.compile("#[ -\u007f]*");

    public LockInfo() {
        super(KNOWN_KEYS);
    }

    public LockInfo(Map map) {
        this();
        this.putAll(map);
    }

    public LockInfo(String secret, String xmlrpcurl) {
        this();
        this.put(SECRET_KEY, secret);
        this.put(XMLRPCURL_KEY, xmlrpcurl);
        this.put(VERSION_KEY, DEFAULT_VERSION_VALUE);
    }

    public URL getXmlrpcUrl() {
        return this.getUrl(XMLRPCURL_KEY);
    }

    public String getVersion() {
        return this.getString(VERSION_KEY);
    }

    public String getSecret() {
        return this.getString(SECRET_KEY);
    }

    public void check() {
        super.check();
        this.checkHasKeys(new String[]{SECRET_KEY, XMLRPCURL_KEY});
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            if (key instanceof String) {
                if (!TOKEN_REGEX.matcher(key.toString()).matches()) {
                    throw new DataException("Bad key syntax: " + key + " does not match " + TOKEN_REGEX.pattern());
                }
            } else {
                throw new DataException("Map key " + entry.getKey() + " is not a string");
            }
            Object value = entry.getValue();
            if (value instanceof String) {
                String sval = (String)value;
                for (int i = 0; i < sval.length(); ++i) {
                    char c = sval.charAt(i);
                    if (c >= ' ' && c <= '\u007f') continue;
                    throw new DataException("Value contains illegal character 0x" + Integer.toHexString(c));
                }
                continue;
            }
            throw new DataException("Map value " + value + " is not a string");
        }
    }

    public static LockInfo readLockFile() throws IOException {
        return LockInfo.readLockFile(SampUtils.getLockFile());
    }

    public static LockInfo readLockFile(File file) throws IOException {
        if (file.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                return LockInfo.readLockFile(in);
            }
            catch (IOException e) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
        return null;
    }

    public static LockInfo readLockFile(InputStream in) throws IOException {
        String line;
        LockInfo info = new LockInfo();
        while ((line = LockInfo.readLine(in)) != null) {
            Matcher assigner = ASSIGNMENT_REGEX.matcher(line);
            if (assigner.matches()) {
                info.put(assigner.group(1), assigner.group(2));
                continue;
            }
            if (COMMENT_REGEX.matcher(line).matches() || line.length() == 0) continue;
            logger_.warning("Ignoring lockfile line with bad syntax");
            logger_.info("Bad line: " + line);
        }
        in.close();
        return info;
    }

    public static LockInfo asLockInfo(Map map) {
        return map instanceof LockInfo ? (LockInfo)map : new LockInfo(map);
    }

    private static String readLine(InputStream in) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        while (true) {
            int c = in.read();
            switch (c) {
                case 10: 
                case 13: {
                    return sbuf.toString();
                }
                case -1: {
                    return sbuf.length() > 0 ? sbuf.toString() : null;
                }
            }
            sbuf.append((char)c);
        }
    }
}

