/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class Platform {
    private static Platform instance_;
    private final String name_;
    private static final Logger logger_;

    protected Platform(String name) {
        this.name_ = name;
    }

    public abstract File getHomeDirectory();

    public void setPrivateRead(File file) throws IOException {
        if (Platform.setPrivateReadReflect(file)) {
            return;
        }
        Platform.exec(this.getPrivateReadArgs(file));
    }

    protected abstract String[] getPrivateReadArgs(File var1) throws IOException;

    private static boolean setPrivateReadReflect(File file) throws IOException {
        try {
            boolean success;
            Method setReadableMethod = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            boolean bl = success = setReadableMethod.invoke((Object)file, Boolean.FALSE, Boolean.FALSE).equals(Boolean.TRUE) && setReadableMethod.invoke((Object)file, Boolean.TRUE, Boolean.TRUE).equals(Boolean.TRUE);
            if (success) {
                return true;
            }
            throw new IOException("Operation disallowed");
        }
        catch (InvocationTargetException e1) {
            Throwable e2 = e1.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private static String exec(String[] args) throws IOException {
        String err;
        Process process;
        String argv = Arrays.asList(args).toString();
        logger_.info("System exec: " + argv);
        try {
            process = Runtime.getRuntime().exec(args);
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Exec failed: " + argv);
        }
        catch (IOException e) {
            throw (IOException)new IOException("Exec failed: " + argv).initCause(e);
        }
        if (process.exitValue() == 0) {
            return Platform.readStream(process.getInputStream());
        }
        try {
            err = Platform.readStream(process.getErrorStream());
        }
        catch (IOException e) {
            err = "??";
        }
        throw new IOException("Exec failed: " + argv + " - " + err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream in) throws IOException {
        try {
            int c;
            StringBuffer sbuf = new StringBuffer();
            while ((c = in.read()) >= 0) {
                sbuf.append((char)c);
            }
            String string = sbuf.toString();
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Platform getPlatform() {
        if (instance_ == null) {
            instance_ = Platform.createPlatform();
        }
        return instance_;
    }

    private static Platform createPlatform() {
        String osname = System.getProperty("os.name");
        if (osname.toLowerCase().startsWith("windows") || osname.toLowerCase().indexOf("microsoft") >= 0) {
            return new WindowsPlatform();
        }
        return new UnixPlatform();
    }

    static {
        logger_ = Logger.getLogger(Platform.class.getName());
    }

    private static class WindowsPlatform
    extends Platform {
        WindowsPlatform() {
            super("MS Windows");
        }

        protected String[] getPrivateReadArgs(File file) throws IOException {
            return new String[]{"attrib", "-R", file.toString()};
        }

        public File getHomeDirectory() {
            String userprofile = null;
            try {
                userprofile = System.getenv("USERPROFILE");
            }
            catch (Throwable e) {
                try {
                    String[] argv = new String[]{"cmd", "/c", "echo", "%USERPROFILE%"};
                    return new File(Platform.exec(argv));
                }
                catch (Throwable e2) {
                    userprofile = null;
                }
            }
            if (userprofile != null && userprofile.trim().length() > 0) {
                return new File(userprofile);
            }
            return new File(System.getProperty("user.home"));
        }
    }

    private static class UnixPlatform
    extends Platform {
        UnixPlatform() {
            super("Un*x");
        }

        public File getHomeDirectory() {
            return new File(System.getProperty("user.home"));
        }

        protected String[] getPrivateReadArgs(File file) {
            return new String[]{"chmod", "600", file.toString()};
        }
    }
}

