/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.client.TrackedClientSet;

class ClientTracker
extends AbstractMessageHandler {
    private final TrackedClientSet clientSet_;
    private final Map clientMap_;
    private final OperationQueue opQueue_;
    private static final Logger logger_;
    private static final int QUEUE_TIME = 10000;
    private static final String REGISTER_MTYPE;
    private static final String UNREGISTER_MTYPE;
    private static final String METADATA_MTYPE;
    private static final String SUBSCRIPTIONS_MTYPE;
    private static final String[] TRACKED_MTYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClientTracker(TrackedClientSet clientSet) {
        super(TRACKED_MTYPES);
        this.clientSet_ = clientSet;
        this.clientMap_ = clientSet.getClientMap();
        this.opQueue_ = new OperationQueue();
    }

    public void clear() {
        block2: {
            try {
                this.initialise(null);
            }
            catch (SampException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void initialise(HubConnection connection) throws SampException {
        int ic;
        String[] clientIds;
        if (connection == null) {
            clientIds = new String[]{};
        } else {
            String[] otherIds = connection.getRegisteredClients();
            clientIds = new String[otherIds.length + 1];
            System.arraycopy(otherIds, 0, clientIds, 0, otherIds.length);
            clientIds[otherIds.length] = connection.getRegInfo().getSelfId();
        }
        int nc = clientIds.length;
        Client[] clients = new TrackedClient[nc];
        for (ic = 0; ic < nc; ++ic) {
            clients[ic] = new TrackedClient(clientIds[ic]);
        }
        this.clientSet_.setClients(clients);
        for (ic = 0; ic < nc; ++ic) {
            Client client = clients[ic];
            String id = ((TrackedClient)client).getId();
            ((TrackedClient)client).setMetadata(connection.getMetadata(id));
            ((TrackedClient)client).setSubscriptions(connection.getSubscriptions(id));
            this.clientSet_.updateClient(client);
            this.opQueue_.apply((TrackedClient)client);
        }
    }

    public Map processCall(HubConnection connection, String senderId, Message message) {
        String id;
        String mtype = message.getMType();
        if (!senderId.equals(connection.getRegInfo().getHubId())) {
            logger_.warning("Hub admin message " + mtype + " received from " + "non-hub client.  Acting on it anyhow");
        }
        if ((id = (String)message.getParams().get("id")) == null) {
            throw new IllegalArgumentException("id parameter missing in " + mtype);
        }
        String selfId = connection.getRegInfo().getSelfId();
        if (REGISTER_MTYPE.equals(mtype)) {
            TrackedClient client = new TrackedClient(id);
            this.opQueue_.apply(client);
            this.clientSet_.addClient(client);
        } else if (UNREGISTER_MTYPE.equals(mtype)) {
            this.performClientOperation(new ClientOperation(id, mtype){

                public void perform(TrackedClient client) {
                    ClientTracker.this.opQueue_.discard(client);
                    ClientTracker.this.clientSet_.removeClient(client);
                }
            }, connection);
        } else if (METADATA_MTYPE.equals(mtype)) {
            final Map meta = (Map)message.getParams().get("metadata");
            this.performClientOperation(new ClientOperation(id, mtype){

                public void perform(TrackedClient client) {
                    client.setMetadata(meta);
                    ClientTracker.this.clientSet_.updateClient(client);
                }
            }, connection);
        } else if (SUBSCRIPTIONS_MTYPE.equals(mtype)) {
            final Map subs = (Map)message.getParams().get("subscriptions");
            this.performClientOperation(new ClientOperation(id, mtype){

                public void perform(TrackedClient client) {
                    client.setSubscriptions(subs);
                    ClientTracker.this.clientSet_.updateClient(client);
                }
            }, connection);
        } else {
            throw new IllegalArgumentException("Shouldn't have received MType" + mtype);
        }
        return null;
    }

    private void performClientOperation(ClientOperation op, HubConnection connection) {
        String id = op.getId();
        TrackedClient client = (TrackedClient)this.clientMap_.get(id);
        if (client != null) {
            op.perform(client);
        } else if (id.equals(connection.getRegInfo().getSelfId())) {
            this.opQueue_.add(op);
        } else {
            if (id.equals(connection.getRegInfo().getSelfId())) {
                logger_.info("Message " + op.getMType() + " arrived for self" + " - holding till later");
            } else {
                logger_.info("No known client " + id + " for message " + op.getMType() + " - holding till later");
            }
            this.opQueue_.add(op);
        }
    }

    static {
        $assertionsDisabled = !ClientTracker.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(ClientTracker.class.getName());
        String[] stringArray = new String[4];
        REGISTER_MTYPE = "samp.hub.event.register";
        stringArray[0] = "samp.hub.event.register";
        UNREGISTER_MTYPE = "samp.hub.event.unregister";
        stringArray[1] = "samp.hub.event.unregister";
        METADATA_MTYPE = "samp.hub.event.metadata";
        stringArray[2] = "samp.hub.event.metadata";
        SUBSCRIPTIONS_MTYPE = "samp.hub.event.subscriptions";
        stringArray[3] = "samp.hub.event.subscriptions";
        TRACKED_MTYPES = stringArray;
    }

    private static class OperationQueue {
        private final Collection opList_ = new ArrayList();
        private Timer tidyTimer_;

        OperationQueue() {
        }

        public synchronized void add(ClientOperation op) {
            if (this.tidyTimer_ == null) {
                TimerTask tidy = new TimerTask(this){
                    private final /* synthetic */ OperationQueue this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        this.this$0.discardOld(10000L);
                    }
                };
                this.tidyTimer_ = new Timer(true);
                this.tidyTimer_.schedule(tidy, 10000L, 10000L);
            }
            this.opList_.add(op);
        }

        public synchronized void apply(TrackedClient client) {
            String id = client.getId();
            Iterator it = this.opList_.iterator();
            while (it.hasNext()) {
                ClientOperation op = (ClientOperation)it.next();
                if (!op.getId().equals(id)) continue;
                logger_.info("Performing queued " + op);
                op.perform(client);
                it.remove();
            }
        }

        public synchronized void discard(TrackedClient client) {
            String id = client.getId();
            Iterator it = this.opList_.iterator();
            while (it.hasNext()) {
                ClientOperation op = (ClientOperation)it.next();
                if (!op.getId().equals(id)) continue;
                logger_.warning("Discarding queued " + op);
                it.remove();
            }
        }

        public synchronized void discardOld(long maxAge) {
            long now = System.currentTimeMillis();
            Iterator it = this.opList_.iterator();
            while (it.hasNext()) {
                ClientOperation op = (ClientOperation)it.next();
                if (now - op.getBirthday() <= maxAge) continue;
                logger_.warning("Discarding queued " + op + " - client never showed up");
                it.remove();
            }
        }

        public synchronized void clear() {
            Iterator it = this.opList_.iterator();
            while (it.hasNext()) {
                ClientOperation op = (ClientOperation)it.next();
                logger_.warning("Discarding queued " + op);
            }
            this.opList_.clear();
        }
    }

    private static abstract class ClientOperation {
        private final String id_;
        private final String mtype_;
        private final long birthday_;

        ClientOperation(String id, String mtype) {
            this.id_ = id;
            this.mtype_ = mtype;
            this.birthday_ = System.currentTimeMillis();
        }

        public abstract void perform(TrackedClient var1);

        public String getId() {
            return this.id_;
        }

        public String getMType() {
            return this.mtype_;
        }

        public long getBirthday() {
            return this.birthday_;
        }

        public String toString() {
            return "message " + this.mtype_ + " for client " + this.id_;
        }
    }

    private static class TrackedClient
    implements Client {
        private final String id_;
        private Metadata metadata_;
        private Subscriptions subscriptions_;

        public TrackedClient(String id) {
            this.id_ = id;
        }

        public String getId() {
            return this.id_;
        }

        public Metadata getMetadata() {
            return this.metadata_;
        }

        public Subscriptions getSubscriptions() {
            return this.subscriptions_;
        }

        void setMetadata(Map metadata) {
            this.metadata_ = Metadata.asMetadata(metadata);
        }

        void setSubscriptions(Map subscriptions) {
            this.subscriptions_ = Subscriptions.asSubscriptions(subscriptions);
        }

        public boolean equals(Object o) {
            if (o instanceof TrackedClient) {
                TrackedClient other = (TrackedClient)o;
                return other.id_.equals(this.id_);
            }
            return false;
        }

        public int hashCode() {
            return this.id_.hashCode();
        }

        public String toString() {
            return SampUtils.toString(this);
        }
    }
}

