/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.hub.BasicClientSet;
import org.astrogrid.samp.hub.HubClient;

class GuiClientSet
extends BasicClientSet
implements ListModel {
    private final List clientList_ = Collections.synchronizedList(new ArrayList());
    private final List listenerList_ = new ArrayList();
    private static final HubClient MORIBUND_CLIENT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GuiClientSet(Comparator clientIdComparator) {
        super(clientIdComparator);
    }

    public synchronized void add(HubClient client) {
        super.add(client);
        int index = this.clientList_.size();
        this.clientList_.add(client);
        this.scheduleListDataEvent(1, index, index);
    }

    public synchronized void remove(HubClient client) {
        super.remove(client);
        this.clientList_.remove(client);
        int index = this.clientList_.size();
        this.scheduleListDataEvent(2, index, index);
    }

    public synchronized HubClient[] getClients() {
        return this.clientList_.toArray(new HubClient[0]);
    }

    public Object getElementAt(int index) {
        try {
            return this.clientList_.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return MORIBUND_CLIENT;
        }
    }

    public int getSize() {
        return this.clientList_.size();
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList_.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList_.remove(l);
    }

    public synchronized void scheduleClientChanged(String privateKey) {
        for (int ix = 0; ix < this.clientList_.size(); ++ix) {
            HubClient client = (HubClient)this.clientList_.get(ix);
            if (!client.getPrivateKey().equals(privateKey)) continue;
            this.scheduleListDataEvent(0, ix, ix);
            return;
        }
        this.scheduleListDataEvent(0, 0, this.clientList_.size());
    }

    private void scheduleListDataEvent(int type, int index0, int index1) {
        if (!this.listenerList_.isEmpty()) {
            final ListDataEvent evt = new ListDataEvent(this, type, index0, index1);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GuiClientSet.this.fireListDataEvent(evt);
                }
            });
        }
    }

    public void fireListDataEvent(ListDataEvent evt) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int type = evt.getType();
        Iterator it = this.listenerList_.iterator();
        while (it.hasNext()) {
            ListDataListener listener = (ListDataListener)it.next();
            if (type == 1) {
                listener.intervalAdded(evt);
                continue;
            }
            if (type == 2) {
                listener.intervalRemoved(evt);
                continue;
            }
            if (type == 0) {
                listener.contentsChanged(evt);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    static {
        $assertionsDisabled = !GuiClientSet.class.desiredAssertionStatus();
        MORIBUND_CLIENT = new HubClient("<no-id>", "<moribund>");
    }
}

