/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.astrogrid.samp.Platform;
import org.astrogrid.samp.SampUtils;

public class LockWriter {
    private final OutputStream out_;
    private static final byte[] linesep_ = LockWriter.getLineSeparator();
    private static final String TOKEN_REGEX = "[a-zA-Z0-9\\-_\\.]+";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_\\.]+");

    public LockWriter() throws IOException {
        this(new FileOutputStream(SampUtils.getLockFile()));
    }

    public LockWriter(OutputStream out) {
        this.out_ = out;
    }

    public void writeAssignments(Map map) throws IOException {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.writeAssignment((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void writeAssignment(String name, String value) throws IOException {
        if (!TOKEN_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Bad name sequence: " + name + " !~" + TOKEN_REGEX);
        }
        this.writeLine(name + "=" + value);
    }

    public void writeComment(String comment) throws IOException {
        this.writeLine("# " + comment);
    }

    public void writeLine() throws IOException {
        this.out_.write(linesep_);
    }

    protected void writeLine(String line) throws IOException {
        byte[] bbuf = new byte[line.length()];
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c < ' ' || c > '\u007f') {
                throw new IllegalArgumentException("Illegal character 0x" + Integer.toHexString(c));
            }
            bbuf[i] = (byte)c;
        }
        this.out_.write(bbuf);
        this.writeLine();
    }

    public void close() throws IOException {
        this.out_.close();
    }

    public static void setLockPermissions(File file) throws IOException {
        Platform.getPlatform().setPrivateRead(file);
    }

    private static final byte[] getLineSeparator() {
        String linesep = System.getProperty("line.separator");
        if (linesep.matches("[\\r\\n]+")) {
            byte[] lsbuf = new byte[linesep.length()];
            for (int i = 0; i < linesep.length(); ++i) {
                lsbuf[i] = (byte)linesep.charAt(i);
            }
            return lsbuf;
        }
        return new byte[]{10};
    }
}

