/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;

class ActorHandler
implements SampXmlRpcHandler {
    private final String prefix_;
    private final Object actor_;
    private final Map methodMap_;
    private final Logger logger_ = Logger.getLogger(ActorHandler.class.getName());
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;

    public ActorHandler(String namespace, Class actorType, Object actor) {
        this.prefix_ = namespace + ".";
        this.actor_ = actor;
        this.methodMap_ = new HashMap();
        Method[] methods = actorType.getDeclaredMethods();
        for (int im = 0; im < methods.length; ++im) {
            Method method = methods[im];
            if (!Modifier.isPublic(method.getModifiers())) continue;
            String name = method.getName();
            Class<?>[] clazzes = method.getParameterTypes();
            SampType[] types = new SampType[clazzes.length];
            for (int ic = 0; ic < clazzes.length; ++ic) {
                types[ic] = SampType.getClassType(clazzes[ic]);
            }
            Signature sig = new Signature(this.prefix_ + name, types);
            this.methodMap_.put(sig, method);
        }
    }

    public boolean canHandleCall(String fqName) {
        return fqName.startsWith(this.prefix_);
    }

    public Object handleCall(String fqName, List params) throws Exception {
        if (!this.canHandleCall(fqName)) {
            throw new IllegalArgumentException("No I can't");
        }
        String name = fqName.substring(this.prefix_.length());
        ArrayList<SampType> typeList = new ArrayList<SampType>();
        Iterator it = params.iterator();
        while (it.hasNext()) {
            typeList.add(SampType.getParamType(it.next()));
        }
        SampType[] types = typeList.toArray(new SampType[0]);
        Signature sig = new Signature(fqName, types);
        Method method = (Method)this.methodMap_.get(sig);
        if (method != null) {
            Object result;
            try {
                result = method.invoke(this.actor_, params.toArray());
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof Error) {
                    throw (Error)e2;
                }
                throw (Exception)e2;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            return result == null ? "" : result;
        }
        Iterator it2 = this.methodMap_.keySet().iterator();
        while (it2.hasNext()) {
            Signature foundSig = (Signature)it2.next();
            if (!foundSig.name_.equals(fqName)) continue;
            throw new IllegalArgumentException("Bad arguments: " + foundSig + " got " + sig.typeList_);
        }
        throw new UnsupportedOperationException("Unknown method " + fqName);
    }

    public Object getActor() {
        return this.actor_;
    }

    private static class Signature {
        private final String name_;
        private final List typeList_;

        Signature(String name, SampType[] types) {
            this.name_ = name;
            this.typeList_ = new ArrayList<SampType>(Arrays.asList(types));
        }

        public boolean equals(Object o) {
            if (o instanceof Signature) {
                Signature other = (Signature)o;
                return this.name_.equals(other.name_) && ((Object)this.typeList_).equals(other.typeList_);
            }
            return false;
        }

        public int hashCode() {
            int code = 999;
            code = 23 * code + this.name_.hashCode();
            code = 23 * code + ((Object)this.typeList_).hashCode();
            return code;
        }

        public String toString() {
            return this.name_ + this.typeList_;
        }
    }

    private static class SampType {
        public static final SampType STRING = new SampType(class$java$lang$String == null ? (class$java$lang$String = ActorHandler.class$("java.lang.String")) : class$java$lang$String, "string");
        public static final SampType LIST = new SampType(class$java$util$List == null ? (class$java$util$List = ActorHandler.class$("java.util.List")) : class$java$util$List, "list");
        public static final SampType MAP = new SampType(class$java$util$Map == null ? (class$java$util$Map = ActorHandler.class$("java.util.Map")) : class$java$util$Map, "map");
        private final Class clazz_;
        private final String name_;

        private SampType(Class clazz, String name) {
            this.clazz_ = clazz;
            this.name_ = name;
        }

        public Class getTypeClass() {
            return this.clazz_;
        }

        public String toString() {
            return this.name_;
        }

        public static SampType getClassType(Class clazz) {
            if ((class$java$lang$String == null ? (class$java$lang$String = ActorHandler.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                return STRING;
            }
            if ((class$java$util$List == null ? (class$java$util$List = ActorHandler.class$("java.util.List")) : class$java$util$List).equals(clazz)) {
                return LIST;
            }
            if ((class$java$util$Map == null ? (class$java$util$Map = ActorHandler.class$("java.util.Map")) : class$java$util$Map).equals(clazz)) {
                return MAP;
            }
            throw new IllegalArgumentException("Illegal type " + clazz.getName());
        }

        public static SampType getParamType(Object param) {
            if (param instanceof String) {
                return STRING;
            }
            if (param instanceof List) {
                return LIST;
            }
            if (param instanceof Map) {
                return MAP;
            }
            throw new DataException("Param is not a SAMP type");
        }
    }
}

