/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.LockInfo;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.LockWriter;
import org.astrogrid.samp.xmlrpc.HubMode;
import org.astrogrid.samp.xmlrpc.HubXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class HubRunner {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private final HubService hub_;
    private final File lockfile_;
    private LockInfo lockInfo_;
    private SampXmlRpcServer server_;
    private HubXmlRpcHandler hubHandler_;
    private boolean shutdown_;
    private static final Logger logger_;
    private static final Random random_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HubRunner(SampXmlRpcClientFactory xClientFactory, SampXmlRpcServerFactory xServerFactory, HubService hub, File lockfile) {
        this.xClientFactory_ = xClientFactory;
        this.xServerFactory_ = xServerFactory;
        this.hub_ = hub;
        this.lockfile_ = lockfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.lockfile_ != null && this.lockfile_.exists()) {
            if (HubRunner.isHubAlive(this.xClientFactory_, this.lockfile_)) {
                throw new IOException("A hub is already running");
            }
            logger_.warning("Overwriting " + this.lockfile_ + " lockfile " + "for apparently dead hub");
            this.lockfile_.delete();
        }
        try {
            this.server_ = this.xServerFactory_.getServer();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Can't start XML-RPC server").initCause(e);
        }
        this.hub_.start();
        String secret = this.createSecret();
        this.hubHandler_ = new HubXmlRpcHandler(this.xClientFactory_, this.hub_, secret);
        this.server_.addHandler(this.hubHandler_);
        Runtime.getRuntime().addShutdownHook(new Thread("HubRunner shutdown"){

            public void run() {
                HubRunner.this.shutdown();
            }
        });
        this.lockInfo_ = new LockInfo(secret, this.server_.getEndpoint().toString());
        this.lockInfo_.put("hub.impl", this.hub_.getClass().getName());
        this.lockInfo_.put("hub.start.date", new Date().toString());
        if (this.lockfile_ != null) {
            logger_.info("Writing new lockfile " + this.lockfile_);
            FileOutputStream out = new FileOutputStream(this.lockfile_);
            LockWriter writer = new LockWriter(out);
            try {
                writer.writeComment("SAMP Standard Profile lockfile written " + new Date());
                out.flush();
                try {
                    LockWriter.setLockPermissions(this.lockfile_);
                    logger_.info("Lockfile permissions set to user access only");
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Failed attempt to change " + this.lockfile_ + " permissions to user access only" + " - possible security implications", e);
                }
                writer.writeAssignments(this.lockInfo_);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    } else if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                } else if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public synchronized void shutdown() {
        block12: {
            if (this.shutdown_) {
                return;
            }
            this.shutdown_ = true;
            if (this.lockfile_ != null) {
                if (this.lockfile_.exists()) {
                    try {
                        LockInfo lockInfo = LockInfo.readLockFile(this.lockfile_);
                        if (lockInfo.getSecret().equals(this.lockInfo_.getSecret())) {
                            if (!$assertionsDisabled && !lockInfo.equals(this.lockInfo_)) {
                                throw new AssertionError();
                            }
                            boolean deleted = this.lockfile_.delete();
                            logger_.info("Lockfile " + this.lockfile_ + " " + (deleted ? "deleted" : "deletion attempt failed"));
                            break block12;
                        }
                        logger_.warning("Lockfile " + this.lockfile_ + " has been " + " overwritten - not deleting");
                    }
                    catch (Throwable e) {
                        logger_.log(Level.WARNING, "Failed to delete lockfile " + this.lockfile_, e);
                    }
                } else {
                    logger_.warning("Lockfile " + this.lockfile_ + " has disappeared");
                }
            }
        }
        if (this.hub_ != null) {
            try {
                this.hub_.shutdown();
            }
            catch (Throwable e) {
                logger_.log(Level.WARNING, "Hub service shutdown failed", e);
            }
        }
        if (this.hubHandler_ != null && this.server_ != null) {
            this.server_.removeHandler(this.hubHandler_);
            this.server_ = null;
        }
        this.lockInfo_ = null;
    }

    public HubService getHub() {
        return this.hub_;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo_;
    }

    public String createSecret() {
        return Long.toHexString(random_.nextLong());
    }

    private static boolean isHubAlive(SampXmlRpcClientFactory xClientFactory, File lockfile) {
        LockInfo info;
        try {
            info = LockInfo.readLockFile(lockfile);
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to read lockfile", e);
            return false;
        }
        if (info == null) {
            return false;
        }
        URL xurl = info.getXmlrpcUrl();
        if (xurl != null) {
            try {
                xClientFactory.createClient(xurl).callAndWait("samp.hub.ping", new ArrayList());
                return true;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "Hub ping method failed", e);
                return false;
            }
        }
        logger_.warning("No XMLRPC URL in lockfile");
        return false;
    }

    static Random createRandom() {
        byte[] seedBytes = new SecureRandom().generateSeed(8);
        long seed = 0L;
        for (int i = 0; i < 8; ++i) {
            seed = seed << 8 | (long)(seedBytes[i] & 0xFF);
        }
        return new Random(seed);
    }

    public static void main(String[] args) throws IOException {
        int status = HubRunner.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runMain(String[] args) throws IOException {
        StringBuffer ubuf = new StringBuffer();
        ubuf.append("\n   Usage:").append("\n      ").append(HubRunner.class.getName()).append("\n           ").append(" [-help]").append(" [-/+verbose]").append(" [-xmlrpc internal|apache|xml-log|rpc-log]").append("\n           ").append(" [-mode ");
        HubMode[] modes = HubMode.getAvailableModes();
        for (int im = 0; im < modes.length; ++im) {
            if (im > 0) {
                ubuf.append('|');
            }
            ubuf.append(modes[im].getName());
        }
        ubuf.append(']');
        ubuf.append("\n");
        String usage = ubuf.toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        HubMode hubMode = HubMode.MESSAGE_GUI;
        if (!Arrays.asList(HubMode.getAvailableModes()).contains(hubMode)) {
            hubMode = HubMode.NO_GUI;
        }
        int verbAdjust = 0;
        XmlRpcKit xmlrpc = null;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-mode") && it.hasNext()) {
                it.remove();
                String mode = (String)it.next();
                it.remove();
                hubMode = HubMode.getModeFromName(mode);
                if (hubMode != null) continue;
                System.err.println("Unknown mode " + mode);
                System.err.println(usage);
                return 1;
            }
            if (arg.equals("-xmlrpc") && it.hasNext()) {
                it.remove();
                String impl = (String)it.next();
                try {
                    xmlrpc = XmlRpcKit.getInstanceByName(impl);
                    continue;
                }
                catch (Exception e) {
                    logger_.log(Level.INFO, "No XMLRPC implementation " + impl, e);
                    System.err.println(usage);
                    return 1;
                }
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        HubRunner.runHub(hubMode, xmlrpc);
        if (hubMode.isDaemon()) {
            String lock;
            String string = lock = new String("Indefinite");
            synchronized (string) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public static void runHub(HubMode hubMode, XmlRpcKit xmlrpc) throws IOException {
        HubRunner[] hubRunners;
        HubRunner runner;
        if (xmlrpc == null) {
            xmlrpc = XmlRpcKit.getInstance();
        }
        hubRunners = new HubRunner[]{runner = new HubRunner(xmlrpc.getClientFactory(), xmlrpc.getServerFactory(), hubMode.createHubService(random_, hubRunners), SampUtils.getLockFile())};
        runner.start();
    }

    public static void runExternalHub(HubMode hubMode) throws IOException {
        File javaHome = new File(System.getProperty("java.home"));
        File javaExec = new File(new File(javaHome, "bin"), "java");
        String javacmd = javaExec.exists() && !javaExec.isDirectory() ? javaExec.toString() : "java";
        String[] propagateProps = new String[]{"jsamp.xmlrpc.impl"};
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(javacmd);
        for (int ip = 0; ip < propagateProps.length; ++ip) {
            String propName = propagateProps[ip];
            String propVal = System.getProperty(propName);
            if (propVal == null) continue;
            argList.add("-D" + propName + "=" + propVal);
        }
        argList.add("-classpath");
        argList.add(System.getProperty("java.class.path"));
        argList.add(HubRunner.class.getName());
        argList.add("-mode");
        argList.add(hubMode.toString());
        String[] args = argList.toArray(new String[0]);
        StringBuffer cmdbuf = new StringBuffer();
        for (int iarg = 0; iarg < args.length; ++iarg) {
            if (iarg > 0) {
                cmdbuf.append(' ');
            }
            cmdbuf.append(args[iarg]);
        }
        logger_.info("Starting external hub");
        logger_.info(cmdbuf.toString());
        Runtime.getRuntime().exec(args);
    }

    static {
        $assertionsDisabled = !HubRunner.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(HubRunner.class.getName());
        random_ = HubRunner.createRandom();
    }
}

