/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.net.URL;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.LockInfo;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcHubConnection;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class StandardClientProfile
implements ClientProfile {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private static StandardClientProfile defaultInstance_;

    public StandardClientProfile(SampXmlRpcClientFactory xClientFactory, SampXmlRpcServerFactory xServerFactory) {
        this.xClientFactory_ = xClientFactory;
        this.xServerFactory_ = xServerFactory;
    }

    public StandardClientProfile(XmlRpcKit xmlrpc) {
        this(xmlrpc.getClientFactory(), xmlrpc.getServerFactory());
    }

    public HubConnection register() throws SampException {
        SampXmlRpcClient xClient;
        LockInfo lockInfo;
        try {
            lockInfo = LockInfo.readLockFile();
        }
        catch (SampException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SampException("Error reading lockfile", e);
        }
        if (lockInfo == null) {
            return null;
        }
        try {
            lockInfo.check();
        }
        catch (DataException e) {
            throw new SampException("Incomplete/broken lock file", e);
        }
        URL xurl = lockInfo.getXmlrpcUrl();
        try {
            xClient = this.xClientFactory_.createClient(xurl);
        }
        catch (IOException e) {
            throw new SampException("Can't connect to " + xurl, e);
        }
        return new XmlRpcHubConnection(xClient, this.xServerFactory_, lockInfo.getSecret());
    }

    public static StandardClientProfile getInstance() {
        if (defaultInstance_ == null) {
            XmlRpcKit xmlrpc = XmlRpcKit.getInstance();
            defaultInstance_ = new StandardClientProfile(xmlrpc.getClientFactory(), xmlrpc.getServerFactory());
        }
        return defaultInstance_;
    }
}

