/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.hub.Receiver;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;

class XmlRpcReceiver
implements Receiver {
    private final String privateKey_;
    private final SampXmlRpcClient xClient_;

    public XmlRpcReceiver(SampXmlRpcClient xClient, String privateKey) {
        this.xClient_ = xClient;
        this.privateKey_ = privateKey;
    }

    public void receiveCall(String senderId, String msgId, Map message) throws HubServiceException {
        this.exec("receiveCall", new Object[]{senderId, msgId, message});
    }

    public void receiveNotification(String senderId, Map message) throws HubServiceException {
        this.exec("receiveNotification", new Object[]{senderId, message});
    }

    public void receiveResponse(String responderId, String msgTag, Map response) throws HubServiceException {
        this.exec("receiveResponse", new Object[]{responderId, msgTag, response});
    }

    private void exec(String methodName, Object[] params) throws HubServiceException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(this.privateKey_);
        for (int ip = 0; ip < params.length; ++ip) {
            paramList.add(params[ip]);
        }
        try {
            this.rawExec("samp.client." + methodName, paramList);
        }
        catch (IOException e) {
            throw new HubServiceException(e.getMessage(), e);
        }
    }

    private void rawExec(String fqName, List paramList) throws IOException {
        this.xClient_.callAndForget(fqName, paramList);
    }
}

