/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.astrogrid.samp.xmlrpc.internal.HttpServer;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;

public class XmlLoggingInternalServer
extends InternalServer {
    private final PrintStream out_;

    public XmlLoggingInternalServer(HttpServer server, String path, PrintStream out) throws IOException {
        super(server, path);
        this.out_ = out;
    }

    public XmlLoggingInternalServer(PrintStream out) throws IOException {
        this.out_ = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpServer.Response getXmlRpcResponse(byte[] body) {
        PrintStream printStream = this.out_;
        synchronized (printStream) {
            this.out_.println("SERVER IN:");
            try {
                this.out_.write(body);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out_.println();
        }
        return new LoggingResponse(super.getXmlRpcResponse(body));
    }

    private class LoggingResponse
    extends HttpServer.Response {
        final HttpServer.Response base_;

        LoggingResponse(HttpServer.Response base) {
            super(base.getStatusCode(), base.getStatusPhrase(), base.getHeaderMap());
            this.base_ = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeBody(OutputStream out) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.base_.writeBody(bout);
            byte[] bbuf = bout.toByteArray();
            PrintStream printStream = XmlLoggingInternalServer.this.out_;
            synchronized (printStream) {
                XmlLoggingInternalServer.this.out_.println("SERVER OUT:");
                XmlLoggingInternalServer.this.out_.write(bbuf);
                XmlLoggingInternalServer.this.out_.println();
            }
            out.write(bbuf);
        }
    }
}

