/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.acr;

import java.lang.reflect.Constructor;

public class ACRException
extends Exception {
    public ACRException() {
    }

    public ACRException(String message) {
        super(message);
    }

    public ACRException(Throwable cause) {
        super(ACRException.convertNonStandard(cause));
    }

    public ACRException(String message, Throwable cause) {
        super(message, ACRException.convertNonStandard(cause));
    }

    private static Throwable convertNonStandard(Throwable t) {
        Throwable newCause = t.getCause() == null ? null : ACRException.convertNonStandard(t.getCause());
        Throwable newT = null;
        if (t.getClass().getName().startsWith("java.")) {
            if (newCause == t.getCause()) {
                return t;
            }
            try {
                Constructor<?> c = t.getClass().getConstructor(String.class, Exception.class);
                newT = (Throwable)c.newInstance(t.getMessage(), newCause);
            }
            catch (Exception e) {
                try {
                    newT = (Throwable)t.getClass().newInstance();
                    newT.initCause(newCause);
                }
                catch (Exception e1) {
                    return t;
                }
            }
        } else {
            newT = new Exception(t.getClass().getName() + " " + t.getMessage(), newCause);
        }
        newT.setStackTrace(t.getStackTrace());
        return newT;
    }
}

