/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.acr;

import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import net.ladypleaser.rmilite.Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.acr.ACRException;
import org.astrogrid.acr.NotFoundException;
import org.astrogrid.acr.SecurityException;
import org.astrogrid.acr.builtin.ACR;
import org.astrogrid.acr.builtin.Shutdown;
import org.astrogrid.acr.builtin.ShutdownListener;
import org.astrogrid.acr.system.ApiHelp;

public class Finder {
    public static final String ACR_JNLP_URL = "http://software.astrogrid.org/jnlp/astrogrid-desktop/astrogrid-desktop.jnlp";
    private static final Log logger = LogFactory.getLog((Class)Finder.class);
    private ACR acr;
    static /* synthetic */ Class class$org$astrogrid$acr$builtin$ACR;

    public synchronized ACR find() throws ACRException {
        if (this.acr == null) {
            this.acr = this.createACR();
            try {
                Shutdown sd = (Shutdown)this.acr.getService(Shutdown.class);
                sd.addShutdownListener(new ShutdownListener(){

                    public void halting() {
                        logger.info((Object)"Host ACR shutting down");
                        Finder.this.acr = null;
                    }

                    public String lastChance() {
                        return null;
                    }
                });
            }
            catch (ACRException e) {
                logger.warn((Object)"Failed to register shutdown listener - no matter", (Throwable)e);
            }
        }
        return this.acr;
    }

    private ACR createACR() throws ACRException {
        int dialogueResult;
        logger.info((Object)"Searching for acr");
        ACR result = null;
        try {
            result = this.connectExternal();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to connect to external acr", (Throwable)e);
        }
        try {
            result = this.createInternal();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to create internal acr", (Throwable)e);
        }
        try {
            this.createExternal();
            long now = System.currentTimeMillis();
            long tooLong = now + 120000L;
            while (!Finder.configurationFile().exists() && System.currentTimeMillis() < tooLong) {
                Thread.sleep(5000L);
            }
            result = this.connectExternal();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to create external acr", (Throwable)e);
        }
        try {
            dialogueResult = JOptionPane.showConfirmDialog(null, "<html><b>Please start the ACR by hand</b><br>When started press 'Ok'. To halt press 'Cancel'", "Unable to automatically start ACR", 2, 2);
        }
        catch (HeadlessException e) {
            logger.warn((Object)"Not running in a ui environment - can't promt");
            dialogueResult = 1;
        }
        if (dialogueResult == 0) {
            try {
                result = this.connectExternal();
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to connect to external acr, after user claimed to start one.", (Throwable)e);
            }
        }
        throw new ACRException("Failed to find or create an ACR to connect to");
    }

    private ACR connectExternal() throws FileNotFoundException, NumberFormatException, IOException, RemoteException, NotBoundException {
        File conf = Finder.configurationFile();
        if (conf.exists()) {
            logger.info((Object)"configuration file indicates an acr is already running");
            BufferedReader br = new BufferedReader(new FileReader(conf));
            int port = Integer.parseInt(br.readLine());
            logger.info((Object)("Port determined to be " + port));
            final Client client = new Client("localhost", port);
            final ApiHelp api = (ApiHelp)client.lookup(ApiHelp.class);
            return new ACR(){

                public Object getService(Class interfaceClass) throws ACRException, NotFoundException {
                    if (interfaceClass.equals(class$org$astrogrid$acr$builtin$ACR == null ? (class$org$astrogrid$acr$builtin$ACR = Finder.class$("org.astrogrid.acr.builtin.ACR")) : class$org$astrogrid$acr$builtin$ACR)) {
                        return this;
                    }
                    try {
                        this.registerListeners(interfaceClass);
                        return client.lookup(interfaceClass);
                    }
                    catch (RemoteException e) {
                        throw new ACRException(e);
                    }
                    catch (NotBoundException e) {
                        throw new NotFoundException(e);
                    }
                }

                private void registerListeners(Class c) {
                    Method[] arr = c.getMethods();
                    for (int i = 0; i < arr.length; ++i) {
                        Method m = arr[i];
                        Class<?>[] ps = m.getParameterTypes();
                        for (int j = 0; j < ps.length; ++j) {
                            this.maybeRegister(ps[j]);
                        }
                        Class<?> ret = m.getReturnType();
                        this.maybeRegister(ret);
                    }
                }

                private void maybeRegister(Class c) {
                    if (c.isInterface() && c.getName().endsWith("Listener")) {
                        logger.debug((Object)("Exporting interface " + c.getName()));
                        client.exportInterface(c);
                    }
                }

                public Object getService(String componentName) throws ACRException, NotFoundException {
                    String className = api.interfaceClassName(componentName);
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(componentName);
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            clazz = Class.forName(className);
                        }
                        catch (ClassNotFoundException e1) {
                            throw new NotFoundException(e1);
                        }
                    }
                    return this.getService(clazz);
                }
            };
        }
        logger.info((Object)"No configuration file - suggests an acr instance is not running at the moment");
        return null;
    }

    public static final File configurationFile() {
        File homeDir = new File(System.getProperty("user.home"));
        return new File(homeDir, ".acr-rmi-port");
    }

    private void createExternal() throws SecurityException, NoSuchMethodException, MalformedURLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method showMethod = null;
        Object methodTarget = null;
        try {
            Class<?> managerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = managerClass.getMethod("lookup", String.class);
            methodTarget = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            showMethod = methodTarget.getClass().getMethod("showDocument", URL.class);
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)"Not running under java web start");
        }
        if (showMethod == null) {
            try {
                Class<?> jdicClass = Class.forName("org.jdesktop.jdic.desktop.Desktop");
                showMethod = jdicClass.getMethod("browse", URL.class);
            }
            catch (ClassNotFoundException e1) {
                logger.info((Object)"Not running with jdic libs");
            }
        }
        if (showMethod == null) {
            throw new ClassNotFoundException("Can't find any class that can control the system browser");
        }
        URL url = new URL(ACR_JNLP_URL);
        showMethod.invoke(methodTarget, url);
    }

    private ACR createInternal() throws InstantiationException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            Class<?> buildClass = Class.forName("org.astrogrid.desktop.BuildInprocessACR");
            Object o = buildClass.newInstance();
            Method m = buildClass.getMethod("start", null);
            m.invoke(o, null);
            m = buildClass.getMethod("getACR", null);
            return (ACR)m.invoke(o, null);
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)"ACR implementation classes not available - must connect to a remote acr", (Throwable)e);
            return null;
        }
    }
}

