/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.acr.astrogrid;

import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.acr.astrogrid.AbstractInformation;

public class NodeInformation
extends AbstractInformation {
    private final boolean file;
    private final long size;
    private final Calendar createDate;
    private final Calendar modifyDate;
    private final Map attributes;
    private final URI contentLocation;

    public NodeInformation(String name, URI node, Long size, Calendar createDate, Calendar modifyDate, Map attributes, boolean file, URI contentLocation) {
        super(name, node);
        this.size = size == null ? 0L : size;
        this.createDate = createDate;
        this.modifyDate = modifyDate;
        this.attributes = Collections.unmodifiableMap(new HashMap(attributes));
        this.file = file;
        this.contentLocation = contentLocation;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Calendar getCreateDate() {
        return this.createDate;
    }

    public Calendar getModifyDate() {
        return this.modifyDate;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isFolder() {
        return !this.file;
    }

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NodeInformation:");
        buffer.append(" id: ");
        buffer.append(this.id);
        buffer.append(" file: ");
        buffer.append(this.file);
        buffer.append(" size: ");
        buffer.append(this.size);
        buffer.append(" createDate: ");
        buffer.append(this.createDate);
        buffer.append(" modifyDate: ");
        buffer.append(this.modifyDate);
        buffer.append(" attributes: ");
        buffer.append(this.attributes);
        buffer.append(" contentLocation: ");
        buffer.append(this.contentLocation);
        buffer.append("]");
        return buffer.toString();
    }
}

