/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.connect.FileBranch;
import uk.ac.starlink.connect.Node;

public class BranchComboBox
extends JComboBox {
    private BranchComboBoxModel model_;
    private static FileView fileView_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BranchComboBox() {
        super(new BranchComboBoxModel());
        if (!$assertionsDisabled && !(this.model_ instanceof BranchComboBoxModel)) {
            throw new AssertionError();
        }
        this.setRenderer(new WrapperCellRenderer(this.getRenderer()));
    }

    public void setModel(ComboBoxModel model) {
        this.model_ = (BranchComboBoxModel)model;
        super.setModel(model);
        Object selected = model.getSelectedItem();
        int state = selected == null ? 2 : 1;
        this.fireItemStateChanged(new ItemEvent(this, 0, selected, state));
    }

    public void setSelectedBranch(Branch branch) {
        this.model_.setSelectedBranch(branch);
    }

    public Branch getSelectedBranch() {
        return this.model_.getSelectedBranch();
    }

    public void addBranch(Branch branch) {
        this.model_.addBranch(branch);
    }

    public void addConnection(ConnectorAction connAct) {
        this.model_.addBranch(new ConnectorBranch(connAct));
    }

    public ConnectorAction getConnectorAction() {
        return this.model_.getConnectorAction();
    }

    public static FileView getFileView() {
        if (fileView_ == null) {
            JFileChooser fc = new JFileChooser();
            fileView_ = fc.getUI().getFileView(fc);
        }
        return fileView_;
    }

    private static Connector getConnector(Branch branch) {
        return branch instanceof ConnectorBranch ? ((ConnectorBranch)branch).getConnectorAction().getConnector() : null;
    }

    static {
        $assertionsDisabled = !BranchComboBox.class.desiredAssertionStatus();
    }

    private static class ConnectorBranch
    implements Branch {
        final ConnectorAction connAct_;

        ConnectorBranch(ConnectorAction connAct) {
            this.connAct_ = connAct;
        }

        public String getName() {
            Connection conn = this.getConnection();
            return this.connAct_.getConnector().getName();
        }

        public Branch getParent() {
            return null;
        }

        public Node[] getChildren() {
            Connection conn = this.getConnection();
            return conn == null ? new Node[]{} : conn.getRoot().getChildren();
        }

        public Node createNode(String name) {
            Connection conn = this.getConnection();
            return conn == null ? null : conn.getRoot().createNode(name);
        }

        public ConnectorAction getConnectorAction() {
            return this.connAct_;
        }

        Connection getConnection() {
            return this.connAct_.getConnection();
        }

        public boolean equals(Object o) {
            return o instanceof ConnectorBranch && ((ConnectorBranch)o).connAct_.equals(this.connAct_);
        }

        public int hashCode() {
            return this.connAct_.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class BranchHolder {
        private final Branch root_;
        private final ConnectorAction connAct_;
        private Branch[] chain_;

        BranchHolder(Branch branch) {
            this.setBranch(branch);
            this.root_ = this.chain_[0];
            this.connAct_ = this.root_ instanceof ConnectorBranch ? ((ConnectorBranch)this.root_).getConnectorAction() : null;
        }

        void setBranch(Branch branch) {
            ArrayList<Branch> ancestors = new ArrayList<Branch>();
            for (Branch ancestor = branch; ancestor != null; ancestor = ancestor.getParent()) {
                ancestors.add(ancestor);
            }
            Collections.reverse(ancestors);
            this.chain_ = ancestors.toArray(new Branch[0]);
        }

        Branch getRoot() {
            Branch r;
            Connection conn;
            if (this.connAct_ != null && (conn = this.connAct_.getConnection()) != null && (r = conn.getRoot()) != null) {
                return r;
            }
            return this.root_;
        }

        int getDepth() {
            return this.chain_.length;
        }

        Branch getBranch() {
            return this.chain_[this.chain_.length - 1];
        }

        Branch getAncestor(int level) {
            return this.chain_[level];
        }

        ConnectorAction getConnectorAction() {
            return this.connAct_;
        }
    }

    private static class WrapperCellRenderer
    implements ListCellRenderer {
        final ListCellRenderer baseRenderer_;
        static final Icon FOLDER_ICON = UIManager.getIcon("Tree.closedIcon");
        final Icon ROOT_ICON = new ImageIcon(this.getClass().getResource("disk.gif"));

        public WrapperCellRenderer(ListCellRenderer base) {
            this.baseRenderer_ = base;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component comp;
            int depth = 0;
            Icon baseIcon = FOLDER_ICON;
            if (value instanceof Branch) {
                Icon icon;
                Branch branch = (Branch)value;
                value = branch.getName();
                while (branch.getParent() != null) {
                    branch = branch.getParent();
                    ++depth;
                }
                ListModel model = list.getModel();
                if (model instanceof BranchComboBoxModel && (icon = ((BranchComboBoxModel)model).getCustomIcon(branch)) != null) {
                    baseIcon = icon;
                }
            }
            if ((comp = this.baseRenderer_.getListCellRendererComponent(list, value, index, isSelected, hasFocus)) instanceof JLabel && baseIcon != null) {
                int offset = 2 + (index >= 0 ? depth * 10 : 0);
                Icon baseIcon1 = baseIcon;
                Icon icon = new Icon(this, baseIcon1, offset){
                    private final /* synthetic */ Icon val$baseIcon1;
                    private final /* synthetic */ int val$offset;
                    private final /* synthetic */ WrapperCellRenderer this$0;
                    {
                        this.this$0 = this$0;
                        this.val$baseIcon1 = val$baseIcon1;
                        this.val$offset = val$offset;
                    }

                    public int getIconHeight() {
                        return this.val$baseIcon1.getIconHeight();
                    }

                    public int getIconWidth() {
                        return this.val$baseIcon1.getIconWidth() + this.val$offset;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        this.val$baseIcon1.paintIcon(c, g, x + this.val$offset, y);
                    }
                };
                ((JLabel)comp).setIcon(icon);
            }
            return comp;
        }
    }

    private static class BranchComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private BranchHolder[] holders_ = new BranchHolder[0];
        private int selected_ = -1;
        private static final FileView fView_ = BranchComboBox.getFileView();

        private BranchComboBoxModel() {
        }

        public int getSize() {
            int size = 0;
            for (int i = 0; i < this.holders_.length; ++i) {
                size += this.holders_[i].getDepth();
            }
            return size;
        }

        public Object getElementAt(int index) {
            for (int i = 0; i < this.holders_.length; ++i) {
                BranchHolder holder = this.holders_[i];
                int depth = holder.getDepth();
                if (index < depth) {
                    return holder.getAncestor(index);
                }
                index -= depth;
            }
            return null;
        }

        public Object getSelectedItem() {
            return this.getSelectedBranch();
        }

        public void setSelectedItem(Object branch) {
            this.setSelectedBranch((Branch)branch);
        }

        public Branch getSelectedBranch() {
            return this.selected_ >= 0 ? this.holders_[this.selected_].getBranch() : null;
        }

        public void setSelectedBranch(Branch branch) {
            Branch root = new BranchHolder(branch).getRoot();
            for (int i = 0; i < this.holders_.length; ++i) {
                if (!root.equals(this.holders_[i].getRoot())) continue;
                this.holders_[i].setBranch(branch);
                this.selected_ = i;
                this.fireContentsChanged(this, -1, -1);
                return;
            }
            this.addBranch(branch);
            this.selected_ = this.holders_.length - 1;
            this.fireContentsChanged(this, -1, -1);
        }

        public void addBranch(Branch branch) {
            int oldSize = this.getSize();
            final BranchHolder holder = new BranchHolder(branch);
            ArrayList<BranchHolder> hlist = new ArrayList<BranchHolder>(Arrays.asList(this.holders_));
            hlist.add(holder);
            this.holders_ = hlist.toArray(new BranchHolder[0]);
            this.fireIntervalAdded(this, Math.max(0, oldSize - 1), this.getSize() - 1);
            if (branch instanceof ConnectorBranch) {
                final ConnectorBranch connBranch = (ConnectorBranch)branch;
                connBranch.getConnectorAction().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("connection")) {
                            Connection conn = (Connection)evt.getNewValue();
                            int oldSize = this.getSize();
                            if (conn == null) {
                                holder.setBranch(connBranch);
                            } else {
                                holder.setBranch(conn.getRoot());
                            }
                            int maxSize = Math.max(oldSize, this.getSize());
                            this.fireContentsChanged(this, 0, maxSize);
                        }
                    }
                });
            }
        }

        public ConnectorAction getConnectorAction() {
            return this.selected_ >= 0 ? this.holders_[this.selected_].getConnectorAction() : null;
        }

        Icon getCustomIcon(Branch branch) {
            if (branch instanceof FileBranch && fView_ != null) {
                return fView_.getIcon(((FileBranch)branch).getFile());
            }
            Branch root = new BranchHolder(branch).getRoot();
            for (int i = 0; i < this.holders_.length; ++i) {
                ConnectorAction connAct;
                BranchHolder holder = this.holders_[i];
                if (!root.equals(holder.getRoot()) || (connAct = holder.getConnectorAction()) == null) continue;
                return connAct.getConnector().getIcon();
            }
            return null;
        }
    }
}

