/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import uk.ac.starlink.connect.AuthKey;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.util.gui.ErrorDialog;

public class ConnectorAction
extends AbstractAction {
    private final Connector connector_;
    private final JPanel entryPanel_;
    private final Map fieldMap_;
    private final Action okAction_;
    private final boolean noAuth_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo.tree");
    private static final String LOGIN_TEXT = "Log In";
    private static final String LOGOUT_TEXT = "Log Out";
    public static final String CONNECTION_PROPERTY = "connection";

    public ConnectorAction(Connector connector) {
        super(LOGIN_TEXT, connector.getIcon());
        this.connector_ = connector;
        this.okAction_ = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                ConnectorAction.this.ok();
            }
        };
        GridBagLayout layer = new GridBagLayout();
        JPanel stack = new JPanel(layer);
        AuthKey[] keys = connector.getKeys();
        this.noAuth_ = keys.length == 0;
        this.fieldMap_ = new HashMap();
        Component firstField = null;
        JTextField firstEmpty = null;
        for (int i = 0; i < keys.length; ++i) {
            AuthKey key = keys[i];
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 0, 0);
            c.gridy = i;
            c.gridx = 0;
            c.anchor = 17;
            JLabel label = new JLabel(key.getName() + ": ");
            layer.setConstraints(label, c);
            stack.add(label);
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            JTextField field = key.isHidden() ? new JPasswordField(20) : new JTextField(20);
            layer.setConstraints(field, c);
            stack.add(field);
            if (firstField == null) {
                firstField = field;
            }
            this.fieldMap_.put(key, field);
            field.addActionListener(this.okAction_);
            String dfault = key.getDefault();
            if (dfault instanceof String) {
                field.setText(dfault);
            } else if (dfault instanceof char[]) {
                field.setText(new String((char[])dfault));
            } else if (firstEmpty == null) {
                firstEmpty = field;
            }
            String desc = key.getDescription();
            if (desc == null) continue;
            label.setToolTipText(desc);
            field.setToolTipText(desc);
        }
        this.entryPanel_ = new JPanel(new BorderLayout());
        this.entryPanel_.add((Component)stack, "Center");
        if (firstEmpty != null) {
            final JTextField initFocus = firstEmpty;
            firstField.addFocusListener(new FocusAdapter(){
                boolean done_;

                public void focusGained(FocusEvent evt) {
                    if (!this.done_) {
                        this.done_ = initFocus.requestFocusInWindow();
                    }
                }
            });
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getConnection() == null) {
            Object src = evt.getSource();
            Component parent = src instanceof Component ? (Component)src : null;
            final JDialog dialog = this.createDialog(parent);
            if (!this.noAuth_) {
                dialog.show();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dialog.show();
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ConnectorAction.this.noAuth_) {
                            ConnectorAction.this.ok();
                        }
                    }
                });
            }
        } else {
            try {
                this.getConnection().logOut();
            }
            catch (IOException e) {
                logger_.warning("Logout failed: " + e.getMessage());
            }
            this.setConnection(null);
        }
    }

    protected JDialog createDialog(Component parent) {
        Frame fparent = parent == null ? null : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        final JDialog dialog = new JDialog(fparent, this.connector_.getName() + " Log In", true);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                dialog.dispose();
            }
        };
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Box controlBox = Box.createHorizontalBox();
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(cancelAction));
        if (!this.noAuth_) {
            controlBox.add(Box.createHorizontalStrut(5));
            controlBox.add(new JButton(this.okAction_));
        }
        controlBox.setBorder(gapBorder);
        String iconID = this.noAuth_ ? "OptionPane.informationIcon" : "OptionPane.questionIcon";
        JLabel imageBox = new JLabel(UIManager.getIcon(iconID));
        imageBox.setBorder(gapBorder);
        JPanel main = new JPanel(new BorderLayout());
        JPanel entryHolder = new JPanel(new BorderLayout());
        entryHolder.setBorder(gapBorder);
        if (this.noAuth_) {
            entryHolder.add(new JLabel("Attempting " + this.connector_.getName() + " connection ..."));
        } else {
            entryHolder.add(this.entryPanel_);
        }
        main.add((Component)entryHolder, "Center");
        main.add((Component)controlBox, "South");
        main.add((Component)imageBox, "West");
        dialog.getContentPane().add(main);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ConnectorAction.CONNECTION_PROPERTY) && evt.getNewValue() != null) {
                    ConnectorAction.this.removePropertyChangeListener(this);
                    dialog.dispose();
                }
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    private void ok() {
        HashMap<AuthKey, char[]> valueMap = new HashMap<AuthKey, char[]>();
        Iterator it = this.fieldMap_.keySet().iterator();
        while (it.hasNext()) {
            char[] value;
            JTextField field;
            AuthKey key = (AuthKey)it.next();
            if (key.isHidden()) {
                field = (JPasswordField)this.fieldMap_.get(key);
                char[] pass = ((JPasswordField)field).getPassword();
                value = pass == null || pass.length == 0 ? null : pass;
            } else {
                field = (JTextField)this.fieldMap_.get(key);
                String text = field.getText();
                Object object = value = text == null || text.length() == 0 ? null : (Object)text;
            }
            if (key.isRequired() && value == null) {
                String msg = "Must supply value for field " + key.getName();
                JOptionPane.showMessageDialog(this.entryPanel_, msg, "Login Error", 0);
                return;
            }
            valueMap.put(key, value);
        }
        this.attemptLogin(valueMap);
    }

    private void attemptLogin(final Map authMap) {
        this.setEnabled(false);
        new Thread("Login"){
            Connection conn;
            IOException error;

            public void run() {
                try {
                    this.conn = ConnectorAction.this.connector_.logIn(authMap);
                }
                catch (IOException e) {
                    this.error = e;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (this.this$1.conn != null) {
                            ConnectorAction.access$400(7.access$300(this.this$1), this.this$1.conn);
                        } else {
                            ErrorDialog.showError(ConnectorAction.access$500(7.access$300(this.this$1)), "Login Error", this.this$1.error);
                        }
                        7.access$300(this.this$1).setEnabled(true);
                    }
                });
            }

            static /* synthetic */ ConnectorAction access$300(7 x0) {
                return x0.ConnectorAction.this;
            }
        }.start();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.okAction_.setEnabled(enabled);
        Iterator it = this.fieldMap_.keySet().iterator();
        while (it.hasNext()) {
            ((JTextField)this.fieldMap_.get(it.next())).setEnabled(enabled);
        }
    }

    private void setConnection(Connection connection) {
        this.putValue("Name", connection == null ? LOGIN_TEXT : LOGOUT_TEXT);
        this.putValue(CONNECTION_PROPERTY, connection);
    }

    public Connector getConnector() {
        return this.connector_;
    }

    public Connection getConnection() {
        Connection conn = (Connection)this.getValue(CONNECTION_PROPERTY);
        if (conn == null) {
            return null;
        }
        if (conn.isConnected()) {
            return conn;
        }
        this.putValue(CONNECTION_PROPERTY, null);
        return null;
    }

    static /* synthetic */ void access$400(ConnectorAction x0, Connection x1) {
        x0.setConnection(x1);
    }

    static /* synthetic */ JPanel access$500(ConnectorAction x0) {
        return x0.entryPanel_;
    }
}

