/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.coco;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import uk.ac.starlink.coco.CoordinateConversion;
import uk.ac.starlink.pal.AngleDR;

public class CocoPanel
extends JPanel
implements ActionListener {
    private CoordinateConversion coco;
    private final boolean TRACE = false;
    private final boolean DEBUG = false;
    private final String RESET = "Reset";
    private final String CALCULATE = "Calculate";
    private final String CLOSE = "Exit";
    private static final double D2R = Math.PI / 180;
    private static final double R2D = 57.29577951308232;
    private static final double S2R = 7.27220521664304E-5;
    private static final double AS2R = 4.84813681109536E-6;
    private static final double PIBY2 = 1.5707963267948966;
    private static char insys = (char)52;
    private static char inJB = (char)66;
    private static double inepoch = 1950.0;
    private static char inJBeq = (char)66;
    private static double inequinox = 1950.0;
    private static char outsys = (char)53;
    private static char outJB = (char)74;
    private static double outepoch = 2000.0;
    private static char outJBeq = (char)74;
    private static double outequinox = 2000.0;
    private static boolean hours = true;
    private static boolean degrees = !hours;
    private static boolean lowprec = false;
    private static boolean mediumprec = true;
    private static boolean highprec = false;
    private String task = "Applet";
    private boolean applet = false;
    private boolean webservice = false;
    private String text = null;
    private String insystem = null;
    private String outsystem = null;
    private String inbase = null;
    private String outbase = null;
    private String coords = null;
    private String answer = null;
    private static String[] system_table = new String[]{"Equatorial, FK4", "4", "B1950", "FK4, without E-Terms", "B", "B1950", "Equatorial, FK5", "5", "J2000", "Ecliptic", "A", "", "Equatorial, geocentric", "E", "", "Galactic", "G", "B1950"};
    private final String label1 = "RA                  Dec             PM             PX      RV";
    private final String label2 = "h    m    s        d    '   \"      [s/y   \"/y     [\"       [km/s]]]";
    private static String system_in_def = system_table[0];
    private static String system_in = system_table[0];
    private static char code_in = system_table[1].charAt(0);
    private static String equinox_in = system_table[2];
    private static String system_out_def = system_table[6];
    private static String system_out = system_table[6];
    private static char code_out = system_table[7].charAt(0);
    private static String equinox_out = system_table[8];
    private static char units = (char)72;
    private static char resolution = (char)77;
    private final int XSIZE = 640;
    private final int YSIZE = 380;
    private final Color FOREGROUND = Color.blue;
    private final Color BACKGROUND = Color.lightGray;
    private Container Pane;
    private GridBagConstraints default_constraint;
    private JComboBox inSystembox;
    private JComboBox outSystembox;
    private JTextField inEquinox;
    private JTextField outEquinox;
    private JTextField inputfield;
    private JTextField inEpoch;
    private JTextField outEpoch;
    private JTextField outputfield;
    private JRadioButton hourButton;
    private JRadioButton degreeButton;
    private JRadioButton highButton;
    private JRadioButton mediumButton;
    private JRadioButton lowButton;
    private ButtonGroup Alpha;
    private ButtonGroup Resolution;

    CocoPanel(Container pane) {
        this.coco = new CoordinateConversion();
        this.Pane = pane;
    }

    public void paintComponent(Graphics gc) {
        super.paintComponent(gc);
        gc.setColor(this.BACKGROUND);
        gc.fillRect(0, 0, 640, 380);
    }

    public void setup(String task) {
        this.trace("Setup: " + task + " Date: " + this.getToday());
        if (task == null) {
            this.applet = true;
        }
        this.Pane.setBackground(this.BACKGROUND);
        this.Pane.setForeground(this.FOREGROUND);
        this.initPanel(this.Pane);
        this.trace("Make Visible");
        this.setVisible(true);
    }

    private void initPanel(Container pane) {
        int i;
        String SPACE = " ";
        JLabel BLANK = new JLabel(SPACE);
        this.trace("initPanel: " + this.task);
        pane.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.weightx = 50.0;
        constraint.weighty = 50.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        constraint.ipady = 2;
        constraint.ipadx = 2;
        constraint.fill = 1;
        constraint.anchor = 17;
        constraint.gridx = 0;
        constraint.gridy = 0;
        pane.add((Component)new JLabel("INPUT"), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("System:"), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("Equinox:"), constraint);
        ++constraint.gridx;
        pane.add((Component)new JLabel("Epoch:    "), constraint);
        this.inSystembox = new JComboBox();
        this.inSystembox.setEditable(false);
        this.inSystembox.setBackground(this.Pane.getBackground());
        for (i = 0; i < system_table.length; i += 3) {
            this.inSystembox.addItem(system_table[i]);
        }
        this.inSystembox.setSelectedItem(system_in);
        this.inSystembox.addActionListener(this);
        ++constraint.gridy;
        constraint.gridx = 1;
        constraint.fill = 2;
        pane.add((Component)this.inSystembox, constraint);
        ++constraint.gridx;
        this.inEquinox = new JTextField(equinox_in);
        pane.add((Component)this.inEquinox, constraint);
        ++constraint.gridx;
        this.text = SPACE;
        this.inEpoch = new JTextField(this.text);
        pane.add((Component)this.inEpoch, constraint);
        ++constraint.gridy;
        constraint.gridx = 0;
        constraint.gridwidth = 2;
        constraint.fill = 0;
        ++constraint.gridx;
        pane.add((Component)new JLabel("RA                  Dec             PM             PX      RV"), constraint);
        constraint.gridy += 2;
        constraint.gridx = 1;
        pane.add((Component)new JLabel("h    m    s        d    '   \"      [s/y   \"/y     [\"       [km/s]]]"), constraint);
        --constraint.gridy;
        constraint.gridx = 0;
        pane.add((Component)new JLabel("Coordinate:  "), constraint);
        constraint.fill = 2;
        ++constraint.gridx;
        this.inputfield = new JTextField(SPACE);
        pane.add((Component)this.inputfield, constraint);
        this.inputfield.addActionListener(this);
        this.hourButton = new JRadioButton("Hour");
        this.degreeButton = new JRadioButton("Degree");
        this.hourButton.setBackground(this.Pane.getBackground());
        this.degreeButton.setBackground(this.Pane.getBackground());
        --constraint.gridy;
        constraint.gridx += 2;
        constraint.gridwidth = 1;
        this.hourButton.setSelected(true);
        pane.add((Component)this.hourButton, constraint);
        this.hourButton.addActionListener(this);
        constraint.gridy += 2;
        pane.add((Component)this.degreeButton, constraint);
        this.degreeButton.addActionListener(this);
        this.Alpha = new ButtonGroup();
        this.Alpha.add(this.hourButton);
        this.Alpha.add(this.degreeButton);
        constraint.gridy += 2;
        constraint.gridx = 1;
        constraint.gridwidth = 0;
        this.Pane.add((Component)new JSeparator(), constraint);
        constraint.gridy += 2;
        constraint.gridx = 0;
        constraint.gridwidth = 1;
        constraint.fill = 0;
        pane.add((Component)new JLabel("OUTPUT"), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 2;
        pane.add((Component)new JLabel("System:"), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 1;
        pane.add((Component)new JLabel("Equinox:"), constraint);
        ++constraint.gridx;
        pane.add((Component)new JLabel("Epoch:           "), constraint);
        this.outSystembox = new JComboBox();
        this.outSystembox.setEditable(false);
        this.outSystembox.setBackground(this.Pane.getBackground());
        for (i = 0; i < system_table.length; i += 3) {
            this.outSystembox.addItem(system_table[i]);
        }
        this.outSystembox.setSelectedItem(system_out);
        this.outSystembox.addActionListener(this);
        ++constraint.gridy;
        constraint.gridx = 1;
        constraint.fill = 2;
        pane.add((Component)this.outSystembox, constraint);
        ++constraint.gridx;
        constraint.fill = 2;
        this.outEquinox = new JTextField(equinox_out);
        pane.add((Component)this.outEquinox, constraint);
        ++constraint.gridx;
        this.outEpoch = new JTextField(SPACE);
        pane.add((Component)this.outEpoch, constraint);
        ResolvePanel resolve = new ResolvePanel();
        resolve.setBackground(this.Pane.getBackground());
        this.highButton = new JRadioButton("High");
        this.highButton.setBackground(this.Pane.getBackground());
        resolve.add(this.highButton);
        this.highButton.addActionListener(this);
        this.mediumButton = new JRadioButton("Medium");
        this.mediumButton.setBackground(this.Pane.getBackground());
        resolve.add(this.mediumButton);
        this.mediumButton.addActionListener(this);
        this.lowButton = new JRadioButton("Low");
        this.lowButton.setBackground(this.Pane.getBackground());
        resolve.add(this.lowButton);
        this.lowButton.addActionListener(this);
        this.mediumButton.setSelected(true);
        this.Resolution = new ButtonGroup();
        this.Resolution.add(this.highButton);
        this.Resolution.add(this.mediumButton);
        this.Resolution.add(this.lowButton);
        ++constraint.gridy;
        constraint.gridx = 0;
        constraint.gridwidth = 0;
        pane.add((Component)resolve, constraint);
        ++constraint.gridy;
        constraint.gridx = 0;
        pane.add((Component)new JLabel(" "), constraint);
        ActionPanel actions = new ActionPanel();
        actions.setBackground(this.Pane.getBackground());
        JButton button = new JButton("Reset");
        button.addActionListener(this);
        actions.add(button, "West");
        button = new JButton("Calculate");
        button.addActionListener(this);
        actions.add(button, "Center");
        if (!this.applet) {
            button = new JButton("Exit");
            button.addActionListener(this);
            actions.add(button, "East");
        }
        ++constraint.gridy;
        constraint.gridx = 0;
        constraint.gridwidth = 0;
        pane.add((Component)actions, constraint);
        if (!this.applet) {
            ++constraint.gridy;
            constraint.gridx = 1;
            JCheckBox wserver = new JCheckBox("Use Web Service");
            wserver.addActionListener(this);
            wserver.setBackground(this.Pane.getBackground());
            pane.add((Component)wserver, constraint);
        }
        constraint.gridy += 2;
        constraint.gridx = 1;
        constraint.gridwidth = 0;
        this.Pane.add((Component)new JSeparator(), constraint);
        constraint.gridx = 0;
        constraint.gridwidth = 1;
        ++constraint.gridy;
        constraint.fill = 0;
        pane.add((Component)new JLabel("RESULT"), constraint);
        ++constraint.gridx;
        constraint.gridwidth = 2;
        constraint.anchor = 17;
        constraint.fill = 0;
        constraint.gridx = 1;
        pane.add((Component)new JLabel("RA                  Dec             PM             PX      RV"), constraint);
        constraint.gridy += 2;
        constraint.gridx = 0;
        pane.add((Component)new JLabel("Coordinate:  "), constraint);
        constraint.fill = 2;
        ++constraint.gridx;
        this.answer = SPACE;
        this.outputfield = new JTextField(this.answer);
        this.outputfield.setEditable(false);
        pane.add((Component)this.outputfield, constraint);
    }

    public void actionPerformed(ActionEvent evt) {
        this.trace("Action Event: ");
        this.printDebug("Action Event: " + evt);
        Object source = evt.getSource();
        String arg = evt.getActionCommand();
        if (source instanceof JComboBox) {
            int i;
            this.trace("Combo Box Event: " + arg);
            JComboBox box = (JComboBox)source;
            String selection = (String)box.getSelectedItem();
            this.trace(selection + " selected");
            if (box == this.inSystembox) {
                this.insystem = selection;
                for (i = 0; i < system_table.length; i += 3) {
                    if (!selection.equals(system_table[i])) continue;
                    code_in = system_table[i + 1].charAt(0);
                    equinox_in = system_table[i + 2];
                }
                this.inEquinox.setText(equinox_in);
            } else if (box == this.outSystembox) {
                this.outsystem = selection;
                for (i = 0; i < system_table.length; i += 3) {
                    if (!selection.equals(system_table[i])) continue;
                    code_out = system_table[i + 1].charAt(0);
                    equinox_out = system_table[i + 2];
                }
                this.outEquinox.setText(equinox_out);
            }
        } else if (source instanceof JRadioButton) {
            if (arg.equals("Hour")) {
                this.trace("Hours Selected");
                units = (char)72;
            } else if (arg.equals("Degree")) {
                this.trace("Degrees Selected");
                units = (char)68;
            } else if (arg.equals("High")) {
                this.trace("High Resolution");
                resolution = (char)72;
            } else if (arg.equals("Medium")) {
                this.trace("Medium Resolution");
                resolution = (char)77;
            } else if (arg.equals("Low")) {
                this.trace("Low Resolution");
                resolution = (char)76;
            }
        } else if (source instanceof JCheckBox) {
            boolean index = false;
            this.trace("Check Box Event: " + arg);
            JCheckBox box = (JCheckBox)source;
            this.webservice = box.isSelected();
            if (this.webservice) {
                this.trace("web service selected");
            } else {
                this.trace("web service not selected");
            }
            this.Pane.validate();
        }
        if (source instanceof JButton) {
            this.trace("Button Event: " + arg);
            if (arg.equals("Calculate")) {
                AngleDR r;
                String epoch_out;
                String epoch_in;
                this.coords = this.inputfield.getText().trim();
                this.trace("Coords: " + this.coords);
                CoordinateConversion coco = new CoordinateConversion(code_in, code_out);
                String text = this.inEquinox.getText().trim();
                if (text != null && text.length() > 0) {
                    equinox_in = text;
                }
                if ((text = this.outEquinox.getText().trim()) != null && text.length() > 0) {
                    equinox_out = text;
                }
                if ((epoch_in = this.inEpoch.getText().trim()) == null || epoch_in.length() == 0 || epoch_in.equals("")) {
                    epoch_in = equinox_in;
                }
                if ((epoch_out = this.outEpoch.getText().trim()) == null || epoch_out.length() == 0 || epoch_out.equals("")) {
                    epoch_out = equinox_out;
                }
                if (equinox_in != null) {
                    coco.setInEquinox(equinox_in);
                }
                if (equinox_out != null) {
                    coco.setOutEquinox(equinox_out);
                }
                if (epoch_in != null) {
                    coco.setInEpoch(epoch_in);
                }
                if (epoch_out != null) {
                    coco.setOutEpoch(epoch_out);
                }
                if (resolution != '\u0000') {
                    coco.setPrecision(resolution);
                }
                if (units != '\u0000') {
                    coco.setUnits(units);
                }
                this.answer = (r = coco.validate(this.coords)) != null ? coco.convert(r) : "Invalid Coordinate: " + this.coords;
                this.outputfield.setText(this.answer);
                this.outputfield.setForeground(Color.red);
                this.outputfield.setBackground(Color.white);
            } else if (arg.equals("Reset")) {
                this.trace("Reset");
                this.inSystembox.setSelectedItem(system_in_def);
                this.outSystembox.setSelectedItem(system_out_def);
                this.outputfield.setText(null);
                this.inEpoch.setText(null);
                this.outEpoch.setText(null);
                units = (char)72;
                this.hourButton.setSelected(true);
                resolution = (char)77;
                this.mediumButton.setSelected(true);
            } else if (arg.equals("Exit")) {
                this.trace(this.task + " killed");
                System.exit(0);
            }
        } else if (source instanceof JTextField) {
            this.trace("Text Field: " + arg);
            this.coords = this.inputfield.getText().trim();
            AngleDR r = this.coco.validate(this.coords);
            this.answer = r != null ? this.coco.convert(r) : "Invalid Coordinate: " + r;
            this.outputfield.setText(this.answer);
            this.outputfield.setForeground(Color.blue);
        }
        this.Pane.validate();
    }

    private void trace(String message) {
    }

    private void printDebug(String message) {
    }

    private String getToday() {
        return this.getToday(true);
    }

    private String getToday(boolean decimal) {
        DateFormat currentDateFormat = DateFormat.getDateInstance(3, Locale.UK);
        Date currentDate = new Date();
        Calendar today = Calendar.getInstance();
        int day = today.get(5);
        int month = today.get(2) + 1;
        int year = today.get(1);
        int days = today.get(6);
        if (decimal) {
            return year + "." + days;
        }
        return currentDateFormat.format(currentDate);
    }

    class ResolvePanel
    extends JPanel {
        JPanel buttonPanel = new JPanel();

        public ResolvePanel() {
            this.buttonPanel.setLayout(new FlowLayout(0, 60, 0));
            this.buttonPanel.setBackground(CocoPanel.this.Pane.getBackground());
            this.add(this.buttonPanel);
        }

        public void add(JRadioButton button) {
            this.buttonPanel.add(button);
        }
    }

    class ActionPanel
    extends JPanel {
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();

        public ActionPanel() {
            this.buttonPanel.setLayout(new BorderLayout(50, 5));
            this.buttonPanel.setBackground(CocoPanel.this.Pane.getBackground());
            this.add((Component)this.separator, (Object)"North");
            this.add((Component)this.buttonPanel, (Object)"Center");
        }

        public void add(JButton button, String pos) {
            this.buttonPanel.add((Component)button, pos);
        }
    }
}

