/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedFile;
import org.xml.sax.SAXException;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.ColFitsPlusTableWriter;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class ColFitsPlusTableBuilder
implements TableBuilder {
    private static final ColFitsPlusTableWriter writer_ = new ColFitsPlusTableWriter();

    public String getFormatName() {
        return "colfits-plus";
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream from " + this.getFormatName() + " format");
    }

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        long dataPos;
        TableElement tableMeta;
        if (datsrc.getPosition() != null) {
            throw new TableFormatException("Can't locate numbered HDU");
        }
        if (!(datsrc instanceof FileDataSource) || datsrc.getCompression() != Compression.NONE) {
            throw new TableFormatException("Not uncompressed file on disk");
        }
        File file = ((FileDataSource)datsrc).getFile();
        if (!ColFitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a " + this.getFormatName() + " file");
        }
        Header hdr = new Header();
        BufferedFile in = new BufferedFile(file.toString());
        try {
            long[] pos = new long[1];
            tableMeta = this.readMetadata(in, pos);
            hdr = new Header();
            pos[0] = pos[0] + (long)FitsConstants.readHeader((Header)hdr, (ArrayDataInput)in);
            dataPos = pos[0];
        }
        catch (FitsException e) {
            throw (IOException)new IOException("FITS read error").initCause(e);
        }
        finally {
            in.close();
        }
        ColFitsStarTable tableData = new ColFitsStarTable(file, hdr, dataPos);
        if (tableMeta != null) {
            tableMeta.setData(new TableBodies.StarTableTabularData((StarTable)tableData));
            return new VOStarTable(tableMeta);
        }
        return tableData;
    }

    public static boolean isMagic(byte[] buffer) {
        return writer_.isMagic(buffer);
    }

    private TableElement readMetadata(ArrayDataInput in, long[] pos) throws IOException {
        byte[] headBuf = new byte[2880];
        in.readFully(headBuf);
        try {
            Header hdr = new Header();
            BufferedDataInputStream hstrm = new BufferedDataInputStream(new ByteArrayInputStream(headBuf));
            int headsize = FitsConstants.readHeader((Header)hdr, (ArrayDataInput)hstrm);
            int datasize = (int)FitsConstants.getDataSize((Header)hdr);
            pos[0] = headsize + datasize;
            int nbyte = hdr.getIntValue("NAXIS1");
            byte[] vobuf = new byte[nbyte];
            in.readFully(vobuf);
            int pad = datasize - nbyte;
            IOUtils.skipBytes(in, pad);
            if (!hdr.getBooleanValue("VOTMETA")) {
                return null;
            }
            VOElementFactory vofact = new VOElementFactory();
            DOMSource domsrc = vofact.transformToDOM(new StreamSource(new ByteArrayInputStream(vobuf)), false);
            VODocument doc = (VODocument)domsrc.getNode();
            VOElement topel = (VOElement)doc.getDocumentElement();
            VOElement resel = topel.getChildByName("RESOURCE");
            if (resel == null) {
                throw new TableFormatException("Embedded VOTable document has no RESOURCE element");
            }
            TableElement tabel = (TableElement)resel.getChildByName("TABLE");
            if (tabel == null) {
                throw new TableFormatException("Embedded VOTable document has no TABLE element");
            }
            if (tabel.getChildByName("DATA") != null) {
                throw new TableFormatException("Embedded VOTable document has unexpected DATA element");
            }
            return tabel;
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
    }
}

