/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import [Ljava.lang.String;;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOStarTable;

abstract class Encoder {
    final ValueInfo info;
    final Map attMap = new HashMap();
    String description;
    String nullString;
    String links;
    private String content;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static /* synthetic */ Class class$java$net$URL;

    public abstract String encodeAsText(Object var1);

    public abstract void encodeToStream(Object var1, DataOutput var2) throws IOException;

    private Encoder(ValueInfo info, String datatype) {
        String desc;
        String ucd;
        String units;
        this.info = info;
        this.attMap.put("datatype", datatype.trim());
        String name = info.getName();
        if (name != null && name.trim().length() > 0) {
            this.attMap.put("name", name.trim());
        }
        if ((units = info.getUnitString()) != null && units.trim().length() > 0) {
            this.attMap.put("unit", units.trim());
        }
        if ((ucd = info.getUCD()) != null && ucd.trim().length() > 0) {
            this.attMap.put("ucd", ucd.trim());
        }
        if (info instanceof ColumnInfo) {
            String precision;
            Integer width;
            String utype;
            ColumnInfo cinfo = (ColumnInfo)info;
            String id = (String)cinfo.getAuxDatumValue(VOStarTable.ID_INFO, String.class);
            if (id != null && id.trim().length() > 0) {
                this.attMap.put("ID", id.trim());
            }
            if ((utype = Tables.getUtype(cinfo)) != null && utype.trim().length() > 0) {
                this.attMap.put("utype", utype.trim());
            }
            if ((width = (Integer)cinfo.getAuxDatumValue(VOStarTable.WIDTH_INFO, Integer.class)) != null && width > 0) {
                this.attMap.put("width", width.toString());
            }
            if ((precision = (String)cinfo.getAuxDatumValue(VOStarTable.PRECISION_INFO, String.class)) != null && precision.trim().length() > 0) {
                this.attMap.put("precision", precision.trim());
            }
        }
        if ((desc = info.getDescription()) != null && (desc = desc.trim()).length() > 0) {
            this.description = "<DESCRIPTION>" + VOSerializer.formatText(desc) + "</DESCRIPTION>";
        }
        if (info instanceof ColumnInfo) {
            StringBuffer linksBuf = new StringBuffer();
            Iterator it = ((ColumnInfo)info).getAuxData().iterator();
            while (it.hasNext()) {
                DescribedValue dval;
                ValueInfo linkInfo;
                if (!(class$java$net$URL == null ? Encoder.class$("java.net.URL") : class$java$net$URL).equals((linkInfo = (dval = (DescribedValue)it.next()).getInfo()).getContentClass())) continue;
                String linkName = linkInfo.getName();
                URL linkUrl = (URL)dval.getValue();
                if (linkName == null || linkUrl == null) continue;
                if (linksBuf.length() > 0) {
                    linksBuf.append('\n');
                }
                linksBuf.append("<LINK").append(VOSerializer.formatAttribute("title", linkName)).append(VOSerializer.formatAttribute("href", linkUrl.toString())).append("/>");
            }
            this.links = linksBuf.toString();
        }
    }

    public String getFieldContent() {
        if (this.content == null) {
            StringBuffer contBuf = new StringBuffer();
            if (this.description != null && this.description.trim().length() > 0) {
                contBuf.append('\n').append(this.description);
            }
            if (this.nullString != null && this.nullString.trim().length() > 0) {
                contBuf.append('\n').append("<VALUES null='" + this.nullString + "'/>");
            }
            if (this.links != null && this.links.trim().length() > 0) {
                contBuf.append('\n').append(this.links);
            }
            this.content = contBuf.toString();
        }
        return this.content;
    }

    public Map getFieldAttributes() {
        return this.attMap;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public static Encoder getEncoder(ValueInfo info) {
        Encoder1 enc1;
        String badString;
        Object o;
        DescribedValue nullValue;
        Class clazz = info.getContentClass();
        int[] dims = info.getShape();
        boolean isNullable = info.isNullable();
        final boolean isVariable = dims != null && dims.length > 0 && dims[dims.length - 1] < 0;
        Number nullObj = null;
        if (info instanceof ColumnInfo && (nullValue = ((ColumnInfo)info).getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (o = nullValue.getValue()) instanceof Number) {
            nullObj = (Number)o;
        }
        if (clazz == Boolean.class) {
            return new ScalarEncoder(info, "boolean", null){

                public String encodeAsText(Object val) {
                    Boolean value = (Boolean)val;
                    return value == null ? "" : (value != false ? "T" : "F");
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Boolean value = (Boolean)val;
                    int b = value == null ? 32 : (value != false ? 84 : 70);
                    out.write(b);
                }
            };
        }
        if (clazz == Byte.class || clazz == Short.class) {
            final int badVal = nullObj == null ? Short.MIN_VALUE : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "short", badString){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeShort(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == Integer.class) {
            final int badVal = nullObj == null ? Integer.MIN_VALUE : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "int", badString){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeInt(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == Long.class) {
            final long badVal = nullObj == null ? Long.MIN_VALUE : nullObj.longValue();
            String badString2 = isNullable ? Long.toString(badVal) : null;
            return new ScalarEncoder(info, "long", badString2){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeLong(value == null ? badVal : value.longValue());
                }
            };
        }
        if (clazz == Float.class) {
            return new ScalarEncoder(info, "float", null){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeFloat(value == null ? Float.NaN : value.floatValue());
                }
            };
        }
        if (clazz == Double.class) {
            return new ScalarEncoder(info, "double", null){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeDouble(value == null ? Double.NaN : value.doubleValue());
                }
            };
        }
        if (clazz == Character.class) {
            boolean badVal = false;
            return new ScalarEncoder(info, "char", null){
                {
                    this.attMap.put("arraysize", "1");
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Character value = (Character)val;
                    out.write(value == null ? (char)'\u0000' : value.charValue());
                }
            };
        }
        if (clazz == [Z.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    boolean value = ((boolean[])array)[index];
                    out.write(value ? 84 : 70);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.write(32);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "boolean", dims, enc1) : new FixedArrayEncoder(info, "boolean", dims, enc1);
        }
        if (clazz == [B.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    byte value = ((byte[])array)[index];
                    out.writeShort(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == [S.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    short value = ((short[])array)[index];
                    out.writeShort(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == [I.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    int value = ((int[])array)[index];
                    out.writeInt(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeInt(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "int", dims, enc1) : new FixedArrayEncoder(info, "int", dims, enc1);
        }
        if (clazz == [J.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    long value = ((long[])array)[index];
                    out.writeLong(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeLong(0L);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "long", dims, enc1) : new FixedArrayEncoder(info, "long", dims, enc1);
        }
        if (clazz == [F.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    float value = ((float[])array)[index];
                    out.writeFloat(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeFloat(Float.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "float", dims, enc1) : new FixedArrayEncoder(info, "float", dims, enc1);
        }
        if (clazz == [D.class) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    double value = ((double[])array)[index];
                    out.writeDouble(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeDouble(Double.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "double", dims, enc1) : new FixedArrayEncoder(info, "double", dims, enc1);
        }
        if (clazz == String.class) {
            int nChar;
            int n = nChar = clazz == String.class ? info.getElementSize() : -1;
            if (nChar > 0) {
                final byte[] padBuf = new byte[nChar];
                return new Encoder(info, "char"){
                    {
                        super(x0, x1);
                        this.attMap.put("arraysize", Integer.toString(nChar));
                    }

                    public String encodeAsText(Object val) {
                        return val == null ? "" : val.toString();
                    }

                    public void encodeToStream(Object val, DataOutput out) throws IOException {
                        int i;
                        if (val != null) {
                            String value = val.toString();
                            int limit = Math.min(value.length(), nChar);
                            for (i = 0; i < limit; ++i) {
                                out.write(value.charAt(i));
                            }
                        }
                        out.write(padBuf, 0, nChar - i);
                    }
                };
            }
            return new Encoder(info, "char"){
                {
                    this.attMap.put("arraysize", "*");
                }

                public String encodeAsText(Object val) {
                    return val == null ? "" : val.toString();
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    if (val == null) {
                        out.writeInt(0);
                    } else {
                        String value = val.toString();
                        int leng = value.length();
                        out.writeInt(leng);
                        for (int i = 0; i < leng; ++i) {
                            out.write(value.charAt(i));
                        }
                    }
                }
            };
        }
        if (clazz == String;.class) {
            int nChar;
            int n = nChar = clazz == String;.class ? info.getElementSize() : -1;
            if (nChar < 0) {
                logger.warning("Oh dear - can't serialize array of variable-length strings to VOTable - sorry");
                return null;
            }
            int[] charDims = new int[dims.length + 1];
            charDims[0] = nChar;
            System.arraycopy(dims, 0, charDims, 1, dims.length);
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < charDims.length; ++i) {
                if (i > 0) {
                    sbuf.append('x');
                }
                if (i == charDims.length - 1 && charDims[i] < 0) {
                    sbuf.append('*');
                    continue;
                }
                sbuf.append(charDims[i]);
            }
            int ns = 0;
            if (!isVariable) {
                ns = 1;
                for (int i = 0; i < dims.length; ++i) {
                    ns *= dims[i];
                }
            }
            final String arraysize = sbuf.toString();
            final int nString = ns;
            return new Encoder(info, "char"){
                char[] cbuf;
                byte[] bbuf;
                byte[] padding;
                {
                    super(x0, x1);
                    this.cbuf = new char[nChar];
                    this.bbuf = new byte[nChar];
                    this.padding = new byte[nChar];
                    this.attMap.put("arraysize", arraysize);
                }

                public String encodeAsText(Object val) {
                    if (val != null) {
                        Object[] value = (Object[])val;
                        StringBuffer sbuf = new StringBuffer();
                        for (int i = 0; i < value.length; ++i) {
                            int j;
                            Object el = value[i];
                            String str = el == null ? "" : el.toString();
                            int limit = Math.min(str.length(), nChar);
                            for (j = 0; j < limit; ++j) {
                                this.cbuf[j] = str.charAt(j);
                            }
                            while (j < nChar) {
                                this.cbuf[j] = 32;
                                ++j;
                            }
                            sbuf.append(new String(this.cbuf));
                        }
                        return sbuf.toString();
                    }
                    return null;
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    int is;
                    int slimit;
                    Object[] value;
                    Object[] objectArray = value = val == null ? new Object[]{} : (Object[])val;
                    if (isVariable) {
                        slimit = value.length;
                        out.writeInt(nChar * slimit);
                    } else {
                        slimit = Math.min(value.length, nString);
                    }
                    for (is = 0; is < slimit; ++is) {
                        int ic;
                        Object v = value[is];
                        String str = v == null ? "" : v.toString();
                        int climit = Math.min(str.length(), nChar);
                        for (ic = 0; ic < climit; ++ic) {
                            this.bbuf[ic] = (byte)str.charAt(ic);
                        }
                        while (ic < nChar) {
                            this.bbuf[ic] = 0;
                            ++ic;
                        }
                        out.write(this.bbuf);
                    }
                    if (!isVariable) {
                        while (is < nString) {
                            out.write(this.padding);
                            ++is;
                        }
                    }
                }
            };
        }
        return null;
    }

    private static interface Encoder1 {
        public void encode1(Object var1, int var2, DataOutput var3) throws IOException;

        public void pad1(DataOutput var1) throws IOException;
    }

    private static class FixedArrayEncoder
    extends ArrayEncoder {
        final int nfixed;

        FixedArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
            int nfixed = 1;
            for (int i = 0; i < dims.length; ++i) {
                nfixed *= dims[i];
            }
            this.nfixed = nfixed;
        }

        public void encodeToStream(Object val, DataOutput out) throws IOException {
            int i;
            if (val != null) {
                int nel = Array.getLength(val);
                int limit = Math.min(nel, this.nfixed);
                for (i = 0; i < limit; ++i) {
                    this.enc1.encode1(val, i, out);
                }
            }
            while (i < this.nfixed) {
                this.enc1.pad1(out);
                ++i;
            }
        }
    }

    private static class VariableArrayEncoder
    extends ArrayEncoder {
        VariableArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
        }

        public void encodeToStream(Object val, DataOutput out) throws IOException {
            if (val == null) {
                out.writeInt(0);
            } else {
                int nel = Array.getLength(val);
                out.writeInt(nel);
                for (int i = 0; i < nel; ++i) {
                    this.enc1.encode1(val, i, out);
                }
            }
        }
    }

    private static abstract class ArrayEncoder
    extends Encoder {
        final Encoder1 enc1;

        ArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype);
            this.enc1 = enc1;
            StringBuffer sizeBuf = new StringBuffer();
            for (int i = 0; i < dims.length; ++i) {
                if (i > 0) {
                    sizeBuf.append('x');
                }
                if (i == dims.length - 1 && dims[i] < 0) {
                    sizeBuf.append('*');
                    continue;
                }
                sizeBuf.append(dims[i]);
            }
            this.attMap.put("arraysize", sizeBuf.toString());
        }

        public String encodeAsText(Object val) {
            if (val == null) {
                return "";
            }
            int nel = Array.getLength(val);
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < nel; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(Array.get(val, i).toString());
            }
            return sbuf.toString();
        }
    }

    private static abstract class ScalarEncoder
    extends Encoder {
        private final String nullText;

        ScalarEncoder(ValueInfo info, String datatype, String nullString) {
            super(info, datatype);
            this.setNullString(nullString);
            this.nullText = nullString == null ? "" : nullString;
        }

        public String encodeAsText(Object val) {
            return val == null ? this.nullText : val.toString();
        }
    }
}

