/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.Base64InputStream;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.BinaryRowSequence;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.LinkElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TabularData;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;

public class TableElement
extends VOElement {
    private TabularData tdata_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    TableElement(Element base, VODocument doc) {
        super(base, doc, "TABLE");
    }

    public FieldElement[] getFields() {
        VOElement[] voels = this.getMetadataElement().getChildrenByName("FIELD");
        FieldElement[] fels = new FieldElement[voels.length];
        System.arraycopy(voels, 0, fels, 0, voels.length);
        return fels;
    }

    public LinkElement[] getLinks() {
        VOElement[] voels = this.getChildrenByName("LINK");
        LinkElement[] lels = new LinkElement[voels.length];
        System.arraycopy(voels, 0, lels, 0, voels.length);
        return lels;
    }

    public ParamElement[] getParams() {
        VOElement[] voels = this.getChildrenByName("PARAM");
        ParamElement[] pels = new ParamElement[voels.length];
        System.arraycopy(voels, 0, pels, 0, voels.length);
        return pels;
    }

    public long getNrows() {
        if (this.hasAttribute("nrows")) {
            String nr = this.getAttribute("nrows");
            try {
                return Long.parseLong(nr);
            }
            catch (NumberFormatException e) {
                logger_.warning("nrows value not an integer: " + nr);
                return -1L;
            }
        }
        if (this.tdata_ != null) {
            return this.tdata_.getRowCount();
        }
        if (this.getChildByName("DATA") == null) {
            return 0L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularData getData() throws IOException {
        TableElement tableElement = this;
        synchronized (tableElement) {
            if (this.tdata_ == null) {
                this.setData(this.makeTabularData());
            }
        }
        return this.tdata_;
    }

    void setData(TabularData tdata) {
        this.tdata_ = tdata;
    }

    StarTable getMetadataTable() {
        long nr;
        if (this.hasAttribute("nrows")) {
            try {
                nr = Long.parseLong(this.getAttribute("nrows"));
            }
            catch (NumberFormatException e) {
                nr = -1L;
            }
        } else {
            nr = -1L;
        }
        final long nrow = nr;
        FieldElement[] fields = this.getFields();
        int ncol = fields.length;
        Class[] clazzes = new Class[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            clazzes[icol] = fields[icol].getDecoder().getContentClass();
        }
        TableBodies.EmptyTabularData tdata = new TableBodies.EmptyTabularData(clazzes);
        return new VOStarTable(this, tdata){

            public long getRowCount() {
                return nrow;
            }

            public boolean isRandom() {
                return false;
            }
        };
    }

    private TabularData makeTabularData() throws IOException {
        FieldElement[] fields = this.getFields();
        int ncol = fields.length;
        Class[] clazzes = new Class[ncol];
        final Decoder[] decoders = new Decoder[ncol];
        for (int i = 0; i < ncol; ++i) {
            decoders[i] = fields[i].getDecoder();
            clazzes[i] = decoders[i].getContentClass();
        }
        VOElement dataEl = this.getChildByName("DATA");
        if (dataEl == null) {
            return new TableBodies.EmptyTabularData(clazzes);
        }
        VOElement tdEl = dataEl.getChildByName("TABLEDATA");
        if (tdEl != null) {
            return new TableBodies.TabledataTabularData(decoders, tdEl);
        }
        VOElement binaryEl = dataEl.getChildByName("BINARY");
        if (binaryEl != null) {
            final VOElement streamEl = binaryEl.getChildByName("STREAM");
            if (streamEl == null) {
                logger_.warning("No BINARY/STREAM element");
                return new TableBodies.EmptyTabularData(clazzes);
            }
            String href = streamEl.getAttribute("href");
            if (href != null && href.length() > 0) {
                URL url = this.getContextURL(href);
                String encoding = streamEl.getAttribute("encoding");
                return new TableBodies.HrefBinaryTabularData(decoders, url, encoding);
            }
            return new TableBodies.SequentialTabularData(clazzes){

                public RowSequence getRowSequence() throws IOException {
                    InputStream istrm = TableElement.getTextChildrenStream(streamEl);
                    return new BinaryRowSequence(decoders, istrm, "base64");
                }
            };
        }
        VOElement fitsEl = dataEl.getChildByName("FITS");
        if (fitsEl != null) {
            DataSource datsrc;
            VOElement streamEl;
            String extnum = fitsEl.getAttribute("extnum");
            if (extnum != null && extnum.trim().length() == 0) {
                extnum = null;
            }
            if ((streamEl = fitsEl.getChildByName("STREAM")) == null) {
                logger_.warning("No FITS/STREAM element");
                return new TableBodies.EmptyTabularData(clazzes);
            }
            String href = streamEl.getAttribute("href");
            if (href != null && href.length() > 0) {
                URL url = this.getContextURL(href);
                datsrc = DataSource.makeDataSource(url);
            } else {
                datsrc = new DataSource(){

                    protected InputStream getRawInputStream() {
                        return new BufferedInputStream(new Base64InputStream(TableElement.getTextChildrenStream(streamEl)));
                    }
                };
                datsrc.setName("STREAM");
            }
            datsrc.setPosition(extnum);
            StarTable startab = new FitsTableBuilder().makeStarTable(datsrc, false, ((VODocument)this.getOwnerDocument()).getStoragePolicy());
            if (startab == null) {
                throw new IOException("STREAM element does not contain a FITS table");
            }
            return new TableBodies.StarTableTabularData(startab);
        }
        logger_.warning("DATA element contains none of TABLEDATA, FITS or BINARY");
        return new TableBodies.EmptyTabularData(clazzes);
    }

    private TableElement getMetadataElement() {
        if (this.hasAttribute("ref")) {
            String ref = this.getAttribute("ref");
            Element node = this.getOwnerDocument().getElementById(ref);
            if (node instanceof TableElement) {
                return (TableElement)node;
            }
            logger_.warning("No TABLE element is referenced by ID " + ref);
            return (TableElement)this.getOwnerDocument().createElement("TABLE");
        }
        return this;
    }

    private static InputStream getTextChildrenStream(Node node) {
        ArrayList<Node> tchildren = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            tchildren.add(child);
        }
        final Enumeration en = Collections.enumeration(tchildren);
        return new SequenceInputStream(new Enumeration(){

            public boolean hasMoreElements() {
                return en.hasMoreElements();
            }

            public Object nextElement() {
                Text textNode = (Text)en.nextElement();
                String text = textNode.getData();
                StringInputStream tstrm = new StringInputStream(text);
                return tstrm;
            }
        });
    }

    static class StringInputStream
    extends InputStream {
        private final String text;
        private final int leng;
        private int pos = 0;
        private int marked = 0;

        public StringInputStream(String text) {
            this.text = text;
            this.leng = text.length();
        }

        public int available() {
            return this.leng - this.pos;
        }

        public int read() {
            return this.pos < this.leng ? (int)this.text.charAt(this.pos++) : -1;
        }

        public int read(byte[] b, int off, int size) {
            int i;
            for (i = 0; i < size && this.pos < this.leng; ++i) {
                b[off++] = (byte)this.text.charAt(this.pos++);
            }
            return i;
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) {
            long i = Math.min(n, (long)(this.leng - this.pos));
            this.pos += (int)i;
            return i;
        }

        public void mark(int limit) {
            this.marked = this.pos;
        }

        public void reset() {
            this.pos = this.marked;
        }

        public boolean markSupported() {
            return true;
        }
    }
}

