/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.TableContentHandler;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VOElementFactory;

class TableStreamer
extends TableContentHandler
implements TableHandler {
    private int skipTables_;
    private final TableSink sink_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    public TableStreamer(TableSink sink, int itable, boolean strict) {
        super(strict);
        this.setTableHandler(null);
        this.setReadHrefTables(false);
        this.sink_ = sink;
        this.skipTables_ = itable;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        if (("TABLE".equals(localName) || "TABLE".equals(qName) || qName != null && qName.endsWith(":TABLE")) && this.skipTables_-- == 0) {
            this.setReadHrefTables(true);
            this.setTableHandler(this);
        }
    }

    public void startTable(StarTable meta) throws SAXException {
        try {
            this.sink_.acceptMetadata(meta);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
        }
    }

    public void rowData(Object[] row) throws SAXException {
        try {
            this.sink_.acceptRow(row);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
        }
    }

    public void endTable() throws SAXException {
        try {
            this.sink_.endRows();
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator()).initCause(e);
        }
        throw new SuccessfulCompletionException();
    }

    public static void streamStarTable(InputSource saxsrc, TableSink sink, int itable, boolean strict) throws IOException, SAXException {
        XMLReader parser;
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        parser.setContentHandler(new TableStreamer(sink, itable, strict));
        try {
            parser.parse(saxsrc);
        }
        catch (SuccessfulCompletionException e) {
            return;
        }
        catch (SAXException e) {
            throw VOElementFactory.fixStackTrace(e);
        }
        throw new IOException("No TABLE element found");
    }

    private static class SuccessfulCompletionException
    extends SAXException {
        SuccessfulCompletionException() {
            super("Table extraction complete");
        }
    }
}

